/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.audit.AtlasAuditEntry;
import org.apache.atlas.model.audit.AuditSearchParameters;
import org.apache.atlas.repository.audit.AtlasAuditService;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasAuditServiceTest {
    private static final int WAIT_TIME_FOR_INDEX_CREATION_IN_MILLI = 5000;
    private static final String AUDIT_PARAMETER_RESOURCE_DIR = "auditSearchParameters";
    private static final String DEFAULT_USER = "admin";
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    AtlasAuditService auditService;

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadBaseModel(this.typeDefStore, this.typeRegistry);
    }

    @Test
    public void checkTypeRegistered() throws AtlasBaseException {
        AtlasType auditEntryType = this.typeRegistry.getType("__" + AtlasAuditEntry.class.getSimpleName());
        Assert.assertNotNull((Object)auditEntryType);
    }

    @Test
    public void checkStoringOfAuditEntry() throws AtlasBaseException {
        String clientId1 = "client1";
        AtlasAuditEntry entryTobeStored1 = this.saveEntry(AtlasAuditEntry.AuditOperation.PURGE, "client1");
        String clientId2 = "client2";
        AtlasAuditEntry entryTobeStored2 = this.saveEntry(AtlasAuditEntry.AuditOperation.PURGE, clientId2);
        this.waitForIndexCreation();
        AtlasAuditEntry storedEntry1 = this.retrieveEntry(entryTobeStored1);
        AtlasAuditEntry storedEntry2 = this.retrieveEntry(entryTobeStored2);
        Assert.assertNotEquals((Object)storedEntry1.getGuid(), (Object)storedEntry2.getGuid());
        Assert.assertNotNull((Object)storedEntry1.getGuid());
        Assert.assertNotNull((Object)storedEntry2.getGuid());
        Assert.assertEquals((String)storedEntry1.getUserName(), (String)DEFAULT_USER);
        Assert.assertEquals((String)storedEntry2.getUserName(), (String)DEFAULT_USER);
        Assert.assertEquals((String)storedEntry1.getClientId(), (String)entryTobeStored1.getClientId());
        Assert.assertEquals((String)storedEntry2.getClientId(), (String)entryTobeStored2.getClientId());
        Assert.assertEquals((Object)storedEntry1.getOperation(), (Object)entryTobeStored1.getOperation());
        Assert.assertEquals((Object)storedEntry2.getOperation(), (Object)entryTobeStored2.getOperation());
    }

    @Test
    public void checkStoringMultipleAuditEntries() throws AtlasBaseException, InterruptedException {
        String clientId = "client1";
        int MAX_ENTRIES = 5;
        int LIMIT_PARAM = 3;
        for (int i = 0; i < 5; ++i) {
            this.saveEntry(AtlasAuditEntry.AuditOperation.PURGE, "client1");
        }
        this.waitForIndexCreation();
        AuditSearchParameters auditSearchParameters = this.createAuditParameter("audit-search-parameter-purge");
        auditSearchParameters.setLimit(3);
        auditSearchParameters.setOffset(0);
        List resultLimitedByParam = this.auditService.get(auditSearchParameters);
        Assert.assertTrue((resultLimitedByParam.size() == 3 ? 1 : 0) != 0);
        auditSearchParameters.setLimit(5);
        auditSearchParameters.setOffset(3);
        List results = this.auditService.get(auditSearchParameters);
        Assert.assertTrue((results.size() == 2 ? 1 : 0) != 0);
    }

    private AuditSearchParameters createAuditParameter(String fileName) {
        try {
            return TestResourceFileUtils.readObjectFromJson(AUDIT_PARAMETER_RESOURCE_DIR, fileName, AuditSearchParameters.class);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private AtlasAuditEntry retrieveEntry(AtlasAuditEntry entry) throws AtlasBaseException {
        AuditSearchParameters auditSearchParameters = this.createAuditParameter("audit-search-parameter-purge");
        AtlasAuditEntry result = this.auditService.get(entry);
        Assert.assertNotNull((Object)result);
        entry.setGuid(result.getGuid());
        return this.auditService.get(entry);
    }

    private AtlasAuditEntry saveEntry(AtlasAuditEntry.AuditOperation operation, String clientId) throws AtlasBaseException {
        AtlasAuditEntry entry = new AtlasAuditEntry(operation, DEFAULT_USER, clientId);
        entry.setStartTime(new Date());
        entry.setEndTime(new Date());
        this.auditService.save(entry);
        return entry;
    }

    protected void waitForIndexCreation() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            throw new SkipException("Wait interrupted.");
        }
    }
}

