/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import javax.inject.Inject;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.atlas.TestModules;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.query.BaseDSLComposer;
import org.apache.atlas.query.DSLVisitor;
import org.apache.atlas.query.GremlinClauseList;
import org.apache.atlas.query.GremlinQueryComposer;
import org.apache.atlas.query.Lookup;
import org.apache.atlas.query.antlr4.AtlasDSLParser;
import org.apache.atlas.query.executors.GremlinClauseToTraversalTranslator;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphTraversal;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class TraversalComposerTest
extends BaseDSLComposer {
    @Inject
    public AtlasGraph graph;

    @Test
    public void queries() {
        this.verify("hive_db", "[JanusGraphStep([],[__typeName.eq(hive_db)]), DedupGlobalStep, RangeGlobalStep(0,25)]");
        this.verify("hive_db where owner = 'hdfs'", "[JanusGraphStep([],[__typeName.eq(hive_db), hive_db.owner.eq(hdfs)]), DedupGlobalStep, RangeGlobalStep(0,25)]");
        this.verify("DB where owner = ['hdfs', 'anon']", "[JanusGraphStep([],[__typeName.eq(DB), DB.owner.within([hdfs, anon])]), DedupGlobalStep, RangeGlobalStep(0,25)]");
        this.verify("hive_db where hive_db.name='Reporting' and hive_db.createTime < '2017-12-12T02:35:58.440Z'", "[JanusGraphStep([],[__typeName.eq(hive_db), hive_db.name.eq(Reporting), hive_db.createTime.lt(1513046158440)]), DedupGlobalStep, RangeGlobalStep(0,25)]");
        this.verify("DB as d select d.name, d.owner", "[JanusGraphStep([],[__typeName.eq(DB)]), DedupGlobalStep@[d], RangeGlobalStep(0,25)]");
        this.verify("Table groupby(owner) select name, owner, clusterName orderby name", "[JanusGraphStep([],[__typeName.eq(Table)]), TraversalFilterStep([JanusGraphPropertiesStep([Table.owner],property)]), GroupStep(value(Table.owner),[FoldStep]), DedupGlobalStep, RangeGlobalStep(0,25)]");
    }

    private void verify(String dsl, String expected) {
        AtlasDSLParser.QueryContext queryContext = this.getParsedQuery(dsl);
        String actual = this.getTraversalAsStr(queryContext);
        Assert.assertEquals((String)actual, (String)expected, (String)dsl);
    }

    private String getTraversalAsStr(AtlasDSLParser.QueryContext queryContext) {
        BaseDSLComposer.TestLookup lookup = new BaseDSLComposer.TestLookup(this.registry);
        GremlinQueryComposer.Context context = new GremlinQueryComposer.Context((Lookup)lookup);
        AtlasDSL.QueryMetadata queryMetadata = new AtlasDSL.QueryMetadata(queryContext);
        GremlinQueryComposer gremlinQueryComposer = new GremlinQueryComposer((Lookup)lookup, context, queryMetadata);
        DSLVisitor qv = new DSLVisitor(gremlinQueryComposer);
        qv.visit((ParseTree)queryContext);
        gremlinQueryComposer.get();
        AtlasGraphTraversal traversal = GremlinClauseToTraversalTranslator.run((AtlasGraph)this.graph, (GremlinClauseList)gremlinQueryComposer.clauses());
        return traversal.toString();
    }
}

