/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.pc;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.atlas.pc.WorkItemBuilder;
import org.apache.atlas.pc.WorkItemConsumer;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class WorkItemManagerTest {
    private static final Logger LOG = LoggerFactory.getLogger(WorkItemManagerTest.class);

    @Test
    public void oneWorkerSequences() {
        int i;
        IntegerConsumerBuilder cb = new IntegerConsumerBuilder();
        int numberOfItems = 10;
        try {
            WorkItemManager<Integer, WorkItemConsumer> wi = this.getWorkItemManger(cb, 1);
            for (i = 0; i < numberOfItems; ++i) {
                wi.produce((Object)i);
            }
            wi.shutdown();
        }
        catch (InterruptedException e) {
            throw new SkipException("Test skipped!");
        }
        Assert.assertEquals((int)cb.integers.size(), (int)numberOfItems);
        Integer[] ints = cb.integers.toArray(new Integer[0]);
        for (i = 0; i < numberOfItems; ++i) {
            Assert.assertEquals((float)ints[i].intValue(), (float)i, (float)i);
        }
    }

    @Test
    public void multipleWorkersUnpredictableSequence() {
        IntegerConsumerBuilder cb = new IntegerConsumerBuilder();
        int numberOfItems = 100;
        try {
            WorkItemManager<Integer, WorkItemConsumer> wi = this.getWorkItemManger(cb, 5);
            for (int i = 0; i < numberOfItems; ++i) {
                wi.produce((Object)i);
            }
            wi.shutdown();
        }
        catch (InterruptedException e) {
            throw new SkipException("Test skipped!");
        }
        Assert.assertEquals((int)cb.integers.size(), (int)numberOfItems);
    }

    private WorkItemManager<Integer, WorkItemConsumer> getWorkItemManger(IntegerConsumerBuilder cb, int numWorkers) {
        return new WorkItemManager((WorkItemBuilder)cb, 5, numWorkers);
    }

    private class IntegerConsumerBuilder
    implements WorkItemBuilder<IntegerConsumer, Integer> {
        ConcurrentLinkedQueue<Integer> integers = new ConcurrentLinkedQueue();

        private IntegerConsumerBuilder() {
        }

        public IntegerConsumer build(BlockingQueue<Integer> queue) {
            return new IntegerConsumer(queue, this.integers);
        }
    }

    private class IntegerConsumer
    extends WorkItemConsumer<Integer> {
        private final ConcurrentLinkedQueue<Integer> target;

        public IntegerConsumer(BlockingQueue<Integer> queue, ConcurrentLinkedQueue<Integer> target) {
            super(queue);
            this.target = target;
        }

        protected void doCommit() {
            try {
                Thread.sleep(20 * RandomUtils.nextInt((int)10, (int)15));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        protected void processItem(Integer item) {
            LOG.info("adding: {}: size: {}", (Object)item, (Object)this.target.size());
            this.target.add(item);
        }
    }
}

