/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.pc;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.atlas.pc.WorkItemConsumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class WorkItemConsumerWithResultsTest {
    @Test
    public void runningConsumerWillPopulateResults() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        LinkedBlockingQueue<Integer> bc = new LinkedBlockingQueue<Integer>(5);
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        IntegerConsumerSpy ic = new IntegerConsumerSpy(bc);
        ic.setResults(results);
        ic.setCountDownLatch(countDownLatch);
        ic.run();
        Assert.assertTrue((boolean)bc.isEmpty());
        Assert.assertEquals((int)results.size(), (int)bc.size());
        Assert.assertEquals((long)countDownLatch.getCount(), (long)0L);
    }

    @Test
    public void errorInConsumerWillDecrementCountdownLatch() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        LinkedBlockingQueue<Integer> bc = new LinkedBlockingQueue<Integer>(5);
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        IntegerConsumerThrowingError ic = new IntegerConsumerThrowingError(bc);
        ic.setCountDownLatch(countDownLatch);
        ic.setResults(results);
        ic.run();
        Assert.assertTrue((boolean)bc.isEmpty());
        Assert.assertTrue((boolean)results.isEmpty());
        Assert.assertEquals((long)countDownLatch.getCount(), (long)0L);
    }

    private class IntegerConsumerThrowingError
    extends WorkItemConsumer<Integer> {
        int payload;

        public IntegerConsumerThrowingError(BlockingQueue<Integer> queue) {
            super(queue);
            this.payload = -1;
        }

        protected void doCommit() {
            throw new NullPointerException();
        }

        protected void processItem(Integer item) {
            this.payload = item;
        }

        protected void commitDirty() {
            super.commitDirty();
        }
    }

    private class IntegerConsumerSpy
    extends WorkItemConsumer<Integer> {
        int payload;

        public IntegerConsumerSpy(BlockingQueue<Integer> queue) {
            super(queue);
            this.payload = -1;
        }

        protected void doCommit() {
            this.addResult(this.payload);
        }

        protected void processItem(Integer item) {
            this.payload = item;
        }

        protected void commitDirty() {
            super.commitDirty();
        }
    }
}

