/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.pc;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.atlas.pc.WorkItemConsumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class WorkItemConsumerTest {
    @Test
    public void callingRunOnEmptyQueueCallsDoesNotCallCommitDirty() {
        LinkedBlockingQueue<Integer> bc = new LinkedBlockingQueue<Integer>(5);
        IntegerConsumerSpy ic = new IntegerConsumerSpy(bc);
        ic.run();
        Assert.assertTrue((boolean)bc.isEmpty());
        Assert.assertTrue((boolean)ic.isCommitDirtyCalled());
        Assert.assertFalse((boolean)ic.isUpdateCommitTimeCalled());
    }

    @Test
    public void runOnQueueRemovesItemFromQueuCallsCommitDirty() {
        LinkedBlockingQueue<Integer> bc = new LinkedBlockingQueue<Integer>(5);
        bc.add(1);
        IntegerConsumerSpy ic = new IntegerConsumerSpy(bc);
        ic.run();
        Assert.assertTrue((boolean)bc.isEmpty());
        Assert.assertTrue((boolean)ic.isCommitDirtyCalled());
        Assert.assertTrue((boolean)ic.isUpdateCommitTimeCalled());
    }

    static class IntegerConsumerSpy
    extends WorkItemConsumer<Integer> {
        boolean commitDirtyCalled = false;
        private boolean updateCommitTimeCalled;

        public IntegerConsumerSpy(BlockingQueue<Integer> queue) {
            super(queue);
            this.setCountDownLatch(new CountDownLatch(1));
        }

        protected void doCommit() {
        }

        protected void processItem(Integer item) {
        }

        protected void commitDirty() {
            this.commitDirtyCalled = true;
            super.commitDirty();
        }

        protected void updateCommitTime(long commitTime) {
            this.updateCommitTimeCalled = true;
        }

        public boolean isCommitDirtyCalled() {
            return this.commitDirtyCalled;
        }

        public boolean isUpdateCommitTimeCalled() {
            return this.updateCommitTimeCalled;
        }
    }
}

