/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.patches;

import javax.inject.Inject;
import org.apache.atlas.TestModules;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.patches.AtlasPatchRegistry;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasPatchRegistryTest {
    @Inject
    private AtlasGraph graph;

    @Test
    public void noPatchesRegistered() {
        AtlasPatchRegistry registry = new AtlasPatchRegistry(this.graph);
        this.assertPatches(registry, 0);
    }

    @Test(dependsOnMethods={"noPatchesRegistered"})
    public void registerPatch() {
        AtlasPatchRegistry registry = new AtlasPatchRegistry(this.graph);
        registry.register("1", "test patch", "TYPEDEF_PATCH", "apply", AtlasPatch.PatchStatus.UNKNOWN);
        this.assertPatches(registry, 1);
    }

    @Test(dependsOnMethods={"registerPatch"})
    public void updateStatusForPatch() {
        AtlasPatch.PatchStatus expectedStatus = AtlasPatch.PatchStatus.APPLIED;
        String patchId = "1";
        AtlasPatchRegistry registry = new AtlasPatchRegistry(this.graph);
        registry.updateStatus(patchId, expectedStatus);
        AtlasPatch.AtlasPatches patches = this.assertPatches(registry, 1);
        Assert.assertEquals((String)((AtlasPatch)patches.getPatches().get(0)).getId(), (String)patchId);
        Assert.assertEquals((Object)((AtlasPatch)patches.getPatches().get(0)).getStatus(), (Object)expectedStatus);
    }

    private AtlasPatch.AtlasPatches assertPatches(AtlasPatchRegistry registry, int i) {
        AtlasPatch.AtlasPatches patches = registry.getAllPatches();
        Assert.assertNotNull((Object)patches);
        Assert.assertEquals((int)patches.getPatches().size(), (int)i);
        return patches;
    }
}

