/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.BasicTestSetup;
import org.apache.atlas.SortOrder;
import org.apache.atlas.TestModules;
import org.apache.atlas.discovery.FreeTextSearchProcessor;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class FreeTextSearchProcessorTest
extends BasicTestSetup {
    @Inject
    private AtlasGraph graph;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private EntityGraphRetriever entityRetriever;

    @BeforeClass
    public void setup() throws Exception {
        super.initialize();
        this.setupTestData();
    }

    @Test
    public void searchTablesByName() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setQuery("sales");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        Assert.assertEquals((long)processor.getResultCount(), (long)3L);
        Assert.assertEquals((int)processor.execute().size(), (int)3);
    }

    @Test
    public void searchByNameSortBy() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setQuery("sales");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        params.setSortBy("owner");
        params.setSortOrder(SortOrder.ASCENDING);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertEquals((long)processor.getResultCount(), (long)3L);
        Assert.assertEquals((int)vertices.size(), (int)3);
        AtlasVertex firstVertex = (AtlasVertex)vertices.get(0);
        String firstOwner = (String)this.entityRetriever.toAtlasEntityHeader(firstVertex, (Set)Sets.newHashSet((Object[])new String[]{params.getSortBy()})).getAttribute(params.getSortBy());
        AtlasVertex secondVertex = (AtlasVertex)vertices.get(1);
        String secondOwner = (String)this.entityRetriever.toAtlasEntityHeader(secondVertex, (Set)Sets.newHashSet((Object[])new String[]{params.getSortBy()})).getAttribute(params.getSortBy());
        Assert.assertEquals((String)firstOwner, (String)"Jane BI");
        Assert.assertEquals((String)secondOwner, (String)"Joe");
    }

    @Test
    public void emptySearch() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setQuery("not_exists");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        Assert.assertEquals((long)processor.getResultCount(), (long)0L);
        Assert.assertEquals((int)processor.execute().size(), (int)0);
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="not_exists_type: Unknown/invalid typename")
    public void searchByNonExistingClassification() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("not_exists_type");
        params.setQuery("aaa");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        new FreeTextSearchProcessor(context);
    }

    @AfterClass
    public void teardown() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }
}

