/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.BasicTestSetup;
import org.apache.atlas.SortOrder;
import org.apache.atlas.TestModules;
import org.apache.atlas.discovery.EntitySearchProcessor;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class EntitySearchProcessorTest
extends BasicTestSetup {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySearchProcessorTest.class);
    private final SimpleDateFormat formattedDate = new SimpleDateFormat("dd-MMM-yyyy");
    @Inject
    private AtlasGraph graph;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private EntityGraphRetriever entityRetriever;
    @Inject
    public GraphBackedSearchIndexer indexer;
    private String expectedEntityName = "hive_Table_Null_tableType";

    @BeforeClass
    public void setup() throws Exception {
        super.initialize();
        this.setupTestData();
    }

    @Test
    public void searchTablesByClassification() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_column");
        params.setClassification("PII");
        params.setLimit(10);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        Assert.assertEquals((long)processor.getResultCount(), (long)4L);
        Assert.assertEquals((int)processor.execute().size(), (int)4);
    }

    @Test
    public void searchByClassificationSortBy() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setClassification("Metric");
        params.setLimit(10);
        params.setSortBy("createTime");
        params.setSortOrder(SortOrder.ASCENDING);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertEquals((long)processor.getResultCount(), (long)4L);
        Assert.assertEquals((int)vertices.size(), (int)4);
        AtlasVertex firstVertex = (AtlasVertex)vertices.get(0);
        Date firstDate = (Date)this.entityRetriever.toAtlasEntityHeader(firstVertex, (Set)Sets.newHashSet((Object[])new String[]{params.getSortBy()})).getAttribute(params.getSortBy());
        AtlasVertex secondVertex = (AtlasVertex)vertices.get(1);
        Date secondDate = (Date)this.entityRetriever.toAtlasEntityHeader(secondVertex, (Set)Sets.newHashSet((Object[])new String[]{params.getSortBy()})).getAttribute(params.getSortBy());
        Assert.assertTrue((boolean)firstDate.before(secondDate));
    }

    @Test
    public void emptySearchByClassification() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setClassification("PII");
        params.setLimit(10);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        Assert.assertEquals((long)processor.getResultCount(), (long)0L);
        Assert.assertEquals((int)processor.execute().size(), (int)0);
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="NotExisting: Unknown/invalid classification")
    public void searchByNonExistingClassification() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_process");
        params.setClassification("NotExisting");
        params.setLimit(10);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        new EntitySearchProcessor(context);
    }

    @Test(priority=-1)
    public void searchWithNEQ_stringAttr() throws AtlasBaseException {
        this.createDummyEntity(this.expectedEntityName, "hive_table", new String[0]);
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("tableType", SearchParameters.Operator.NEQ, "Managed");
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertEquals((int)vertices.size(), (int)3);
        ArrayList<String> nameList = new ArrayList<String>();
        for (AtlasVertex vertex : vertices) {
            nameList.add((String)this.entityRetriever.toAtlasEntityHeader(vertex, Collections.singleton("name")).getAttribute("name"));
        }
        Assert.assertTrue((boolean)nameList.contains(this.expectedEntityName));
    }

    @Test
    public void searchWithNEQ_pipeSeperatedAttr() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("__classificationNames", SearchParameters.Operator.NEQ, "Metric");
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertEquals((int)vertices.size(), (int)7);
        ArrayList<String> nameList = new ArrayList<String>();
        for (AtlasVertex vertex : vertices) {
            nameList.add((String)this.entityRetriever.toAtlasEntityHeader(vertex, Collections.singleton("name")).getAttribute("name"));
        }
        Assert.assertTrue((boolean)nameList.contains(this.expectedEntityName));
    }

    @Test
    public void searchWithNEQ_doubleAttr() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("retention", SearchParameters.Operator.NEQ, "5");
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertEquals((int)vertices.size(), (int)1);
        ArrayList<String> nameList = new ArrayList<String>();
        for (AtlasVertex vertex : vertices) {
            nameList.add((String)this.entityRetriever.toAtlasEntityHeader(vertex, Collections.singleton("name")).getAttribute("name"));
        }
        Assert.assertTrue((boolean)nameList.contains("hive_Table_Null_tableType"));
    }

    @Test
    public void ALLEntityType() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("_ALL_ENTITY_TYPES");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        Assert.assertEquals((int)processor.execute().size(), (int)20);
    }

    @Test
    public void ALLEntityTypeWithTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("_ALL_ENTITY_TYPES");
        params.setClassification("Fact");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        Assert.assertEquals((int)processor.execute().size(), (int)5);
    }

    @Test
    public void entityType() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_db");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        Assert.assertEquals((int)processor.execute().size(), (int)3);
    }

    @Test
    public void entityTypes() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_db,hive_table");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        Assert.assertEquals((int)processor.execute().size(), (int)14);
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="Not_Exists: Unknown/invalid typename")
    public void entityTypesNotAllowed() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("Not_Exists");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="Attribute tableType not found for type hive_db")
    public void entityFiltersNotAllowed() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_db,hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("tableType", SearchParameters.Operator.CONTAINS, "ETL");
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
    }

    @Test
    public void entityTypesAndTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_db,hive_table");
        params.setClassification("Fact");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        Assert.assertEquals((int)processor.execute().size(), (int)3);
    }

    @Test
    public void searchWithEntityTypesAndEntityFilters() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_db,hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("owner", SearchParameters.Operator.CONTAINS, "ETL");
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        Assert.assertEquals((int)processor.execute().size(), (int)4);
    }

    @Test
    public void searchWithEntityTypesAndEntityFiltersAndTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_db,hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("owner", SearchParameters.Operator.CONTAINS, "ETL");
        params.setEntityFilters(filterCriteria);
        params.setClassification("Log Data");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        Assert.assertEquals((int)processor.execute().size(), (int)2);
    }

    @Test
    public void searchWithNotContains_stringAttr() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("tableType", SearchParameters.Operator.NOT_CONTAINS, "Managed");
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertEquals((int)vertices.size(), (int)3);
        ArrayList<String> nameList = new ArrayList<String>();
        for (AtlasVertex vertex : vertices) {
            nameList.add((String)this.entityRetriever.toAtlasEntityHeader(vertex, Collections.singleton("name")).getAttribute("name"));
        }
        Assert.assertTrue((boolean)nameList.contains(this.expectedEntityName));
    }

    @Test
    public void searchWithNotContains_pipeSeperatedAttr() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("__classificationNames", SearchParameters.Operator.NOT_CONTAINS, "Metric");
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertEquals((int)vertices.size(), (int)7);
        ArrayList<String> nameList = new ArrayList<String>();
        for (AtlasVertex vertex : vertices) {
            nameList.add((String)this.entityRetriever.toAtlasEntityHeader(vertex, Collections.singleton("name")).getAttribute("name"));
        }
        Assert.assertTrue((boolean)nameList.contains(this.expectedEntityName));
    }

    @AfterClass
    public void teardown() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @Test
    public void testLast7Days() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("LAST_7_DAYS", this.typeRegistry, this.graph);
        ret.setAttributeName("createTime");
        GregorianCalendar startDate = new GregorianCalendar();
        GregorianCalendar endDate = new GregorianCalendar();
        startDate.add(5, -6);
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(startDate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(endDate.getTime()));
    }

    @Test
    public void testLastMonth() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("LAST_MONTH", this.typeRegistry, this.graph);
        Calendar originalstartdate = Calendar.getInstance();
        Calendar originalenddate = Calendar.getInstance();
        originalstartdate.add(2, -1);
        originalstartdate.set(5, originalstartdate.getActualMinimum(5));
        originalenddate.add(2, -1);
        originalenddate.set(5, originalenddate.getActualMaximum(5));
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(originalstartdate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(originalenddate.getTime()));
    }

    @Test
    public void testLast30Days() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("LAST_30_DAYS", this.typeRegistry, this.graph);
        GregorianCalendar startDate = new GregorianCalendar();
        GregorianCalendar endDate = new GregorianCalendar();
        startDate.add(5, -29);
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(startDate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(endDate.getTime()));
    }

    @Test
    public void testYesterday() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("YESTERDAY", this.typeRegistry, this.graph);
        GregorianCalendar yesterdayDate = new GregorianCalendar();
        yesterdayDate.add(5, -1);
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(yesterdayDate.getTime()));
    }

    @Test
    public void testThisMonth() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("THIS_MONTH", this.typeRegistry, this.graph);
        Calendar originalstartdate = Calendar.getInstance();
        Calendar originalenddate = Calendar.getInstance();
        originalstartdate.set(5, originalstartdate.getActualMinimum(5));
        originalenddate.set(5, originalenddate.getActualMaximum(5));
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(originalstartdate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(originalenddate.getTime()));
    }

    @Test
    public void testThisQuarter() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("THIS_QUARTER", this.typeRegistry, this.graph);
        Calendar originalstartdate = Calendar.getInstance();
        Calendar originalenddate = Calendar.getInstance();
        originalstartdate.add(2, -1);
        originalstartdate.set(5, originalstartdate.getActualMinimum(5));
        originalenddate.add(2, 1);
        originalenddate.set(5, originalenddate.getActualMaximum(5));
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(originalstartdate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(originalenddate.getTime()));
    }

    @Test
    public void testLastQuarter() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("LAST_QUARTER", this.typeRegistry, this.graph);
        Calendar originalstartdate = Calendar.getInstance();
        Calendar originalenddate = Calendar.getInstance();
        originalstartdate.add(2, -4);
        originalstartdate.set(5, originalstartdate.getActualMinimum(5));
        originalenddate.add(2, -2);
        originalenddate.set(5, originalenddate.getActualMaximum(5));
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(originalstartdate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(originalenddate.getTime()));
    }

    @Test
    public void testLast3Months() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("LAST_3_MONTHS", this.typeRegistry, this.graph);
        Calendar originalstartdate = Calendar.getInstance();
        Calendar originalenddate = Calendar.getInstance();
        originalstartdate.add(2, -3);
        originalstartdate.set(5, originalstartdate.getActualMinimum(5));
        originalenddate.add(2, -1);
        originalenddate.set(5, originalenddate.getActualMaximum(5));
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(originalstartdate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(originalenddate.getTime()));
    }

    @Test
    public void testThisYear() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("THIS_YEAR", this.typeRegistry, this.graph);
        Calendar originalstartdate = Calendar.getInstance();
        Calendar originalenddate = Calendar.getInstance();
        originalstartdate.set(2, 0);
        originalstartdate.set(5, originalstartdate.getActualMinimum(5));
        originalenddate.set(2, 11);
        originalenddate.set(5, originalenddate.getActualMaximum(5));
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(originalstartdate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(originalenddate.getTime()));
    }

    @Test
    public void testLastYear() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("LAST_YEAR", this.typeRegistry, this.graph);
        Calendar originalstartdate = Calendar.getInstance();
        Calendar originalenddate = Calendar.getInstance();
        originalstartdate.add(1, -1);
        originalstartdate.set(2, 0);
        originalstartdate.set(5, originalstartdate.getActualMinimum(5));
        originalenddate.add(1, -1);
        originalenddate.set(2, 11);
        originalenddate.set(5, originalenddate.getActualMaximum(5));
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(originalstartdate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(originalenddate.getTime()));
    }

    @Test
    public void testLast12Months() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("LAST_12_MONTHS", this.typeRegistry, this.graph);
        Calendar originalstartdate = Calendar.getInstance();
        Calendar originalenddate = Calendar.getInstance();
        originalstartdate.add(2, -12);
        originalstartdate.set(5, originalstartdate.getActualMinimum(5));
        originalenddate.add(2, -1);
        originalenddate.set(5, originalenddate.getActualMaximum(5));
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(originalstartdate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(originalenddate.getTime()));
    }

    @Test
    public void testLast6Months() throws AtlasBaseException {
        SearchParameters.FilterCriteria ret = EntitySearchProcessorTest.filtercriteriaDateRange("LAST_6_MONTHS", this.typeRegistry, this.graph);
        Calendar originalstartdate = Calendar.getInstance();
        Calendar originalenddate = Calendar.getInstance();
        originalstartdate.add(2, -6);
        originalstartdate.set(5, originalstartdate.getActualMinimum(5));
        originalenddate.add(2, -1);
        originalenddate.set(5, originalenddate.getActualMaximum(5));
        String[] dates = ret.getAttributeValue().split(",");
        String attrValue1 = dates[0];
        String attrValue2 = dates[1];
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue1))), (String)this.formattedDate.format(originalstartdate.getTime()));
        Assert.assertEquals((String)this.formattedDate.format(new Date(Long.parseLong(attrValue2))), (String)this.formattedDate.format(originalenddate.getTime()));
    }

    private static SearchParameters.FilterCriteria filtercriteriaDateRange(String attributeValue, AtlasTypeRegistry typeRegistry, AtlasGraph graph) throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = new SearchParameters.FilterCriteria();
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, typeRegistry, graph, Collections.emptySet());
        EntitySearchProcessor processor = new EntitySearchProcessor(context);
        filterCriteria.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        filterCriteria.setOperator(SearchParameters.Operator.TIME_RANGE);
        filterCriteria.setAttributeValue(attributeValue);
        SearchParameters.FilterCriteria ret = processor.processDateRange(filterCriteria);
        return ret;
    }
}

