/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryService;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.glossary.relations.AtlasGlossaryHeader;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;

public abstract class BasicTestSetup
extends AtlasTestBase {
    protected static final String DATABASE_TYPE = "hive_db";
    protected static final String HIVE_TABLE_TYPE = "hive_table";
    private static final String COLUMN_TYPE = "hive_column";
    private static final String HIVE_PROCESS_TYPE = "hive_process";
    private static final String STORAGE_DESC_TYPE = "hive_storagedesc";
    private static final String VIEW_TYPE = "hive_process";
    protected static final String DATASET_SUBTYPE = "Asset";
    public static final String DIMENSION_CLASSIFICATION = "Dimension";
    public static final String FACT_CLASSIFICATION = "Fact";
    public static final String PII_CLASSIFICATION = "PII";
    public static final String METRIC_CLASSIFICATION = "Metric";
    public static final String ETL_CLASSIFICATION = "ETL";
    public static final String JDBC_CLASSIFICATION = "JdbcAccess";
    public static final String LOGDATA_CLASSIFICATION = "Log Data";
    public static final String DIMENSIONAL_CLASSIFICATION = "Dimensional";
    public static final String SALES_GLOSSARY = "salesGlossary";
    public static final String SALES_TERM = "salesTerm";
    public static final String MODERNTRADE_TERM = "modernTrade";
    public static final String ECOMMERCE_TERM = "ecommerce";
    @Inject
    protected AtlasTypeRegistry typeRegistry;
    @Inject
    protected AtlasTypeDefStore typeDefStore;
    @Inject
    protected AtlasEntityStore entityStore;
    @Inject
    protected GlossaryService glossaryService;
    private boolean baseLoaded = false;
    private EntityMutationResponse hiveEntities;
    private AtlasEntity timeDim;
    private AtlasEntity productDim;
    private AtlasEntity loggingFactMonthly;

    protected void setupTestData() {
        this.loadBaseModels();
        this.loadHiveDataset();
        this.loadEmployeeDataset();
        this.assignGlossary();
    }

    private void loadBaseModels() {
        try {
            TestLoadModelUtils.loadModelFromJson("0000-Area0/0010-base_model.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("0000-Area0/0011-glossary_model.json", this.typeDefStore, this.typeRegistry);
            this.baseLoaded = true;
        }
        catch (IOException | AtlasBaseException e) {
            Assert.fail((String)"Base model setup is required for test to run!");
        }
    }

    protected void loadHiveDataset() {
        if (!this.baseLoaded) {
            this.loadBaseModels();
        }
        try {
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1030-hive_model.json", this.typeDefStore, this.typeRegistry);
        }
        catch (IOException | AtlasBaseException e) {
            Assert.fail((String)"Hive model setup is required for test to run!");
        }
        AtlasEntity.AtlasEntitiesWithExtInfo hiveTestEntities = this.hiveTestEntities();
        try {
            this.hiveEntities = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(hiveTestEntities), false);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Hive entities need to be created for test to run!");
        }
    }

    protected void loadEmployeeDataset() {
        if (!this.baseLoaded) {
            this.loadBaseModels();
        }
        AtlasTypesDef employeeTypes = TestUtilsV2.defineDeptEmployeeTypes();
        try {
            this.typeDefStore.createTypesDef(employeeTypes);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Employee Type setup is required");
        }
        AtlasEntity.AtlasEntitiesWithExtInfo deptEg2 = TestUtilsV2.createDeptEg2();
        try {
            this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(deptEg2), false);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Employee entity setup should've passed");
        }
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo hiveTestEntities() {
        ArrayList<AtlasEntity> entities = new ArrayList<AtlasEntity>();
        this.createClassificationTypes();
        AtlasEntity salesDB = this.database("Sales", "/apps/warehouse/Sales Database", "John ETL", "hdfs://host:8000/apps/warehouse/sales", new String[0]);
        entities.add(salesDB);
        AtlasEntity sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        ImmutableList salesFactColumns = ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0]), (Object)this.column("product_id", "int", "product id", new String[0]), (Object)this.column("customer_id", "int", "customer id", PII_CLASSIFICATION), (Object)this.column("sales", "double", "product id", METRIC_CLASSIFICATION));
        entities.addAll((Collection<AtlasEntity>)salesFactColumns);
        AtlasEntity salesFact = this.table("sales_fact", "sales fact table", salesDB, sd, "Joe", "Managed", (List<AtlasEntity>)salesFactColumns, FACT_CLASSIFICATION);
        salesFact.setAttribute("createTime", (Object)new Date(2018, 1, 1));
        entities.add(salesFact);
        ImmutableList logFactColumns = ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0]), (Object)this.column("app_id", "int", "app id", new String[0]), (Object)this.column("machine_id", "int", "machine id", new String[0]), (Object)this.column("log", "string", "log data", LOGDATA_CLASSIFICATION));
        entities.addAll((Collection<AtlasEntity>)logFactColumns);
        ImmutableList timeDimColumns = ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0]), (Object)this.column("dayOfYear", "int", "day Of Year", new String[0]), (Object)this.column("weekDay", "int", "week Day", new String[0]));
        entities.addAll((Collection<AtlasEntity>)timeDimColumns);
        sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        this.timeDim = this.table("time_dim", "time dimension table", salesDB, sd, "John Doe", "External", (List<AtlasEntity>)timeDimColumns, DIMENSION_CLASSIFICATION);
        entities.add(this.timeDim);
        AtlasEntity reportingDB = this.database("Reporting", "/apps/warehouse/reporting database", "Jane BI", "hdfs://host:8000/apps/warehouse/reporting", new String[0]);
        entities.add(reportingDB);
        sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        AtlasEntity salesFactDaily = this.table("sales_fact_daily_mv", "sales fact daily materialized view", reportingDB, sd, "Joe BI", "Managed", (List<AtlasEntity>)salesFactColumns, METRIC_CLASSIFICATION);
        salesFactDaily.setAttribute("createTime", (Object)Date.from(LocalDate.of(2016, 8, 19).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        entities.add(salesFactDaily);
        sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        AtlasEntity circularLineageTable1 = this.table("table1", "", reportingDB, sd, "Vimal", "Managed", (List<AtlasEntity>)salesFactColumns, METRIC_CLASSIFICATION);
        entities.add(circularLineageTable1);
        sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        AtlasEntity circularLineageTable2 = this.table("table2", "", reportingDB, sd, "Vimal 2", "Managed", (List<AtlasEntity>)salesFactColumns, METRIC_CLASSIFICATION);
        entities.add(circularLineageTable2);
        AtlasEntity circularLineage1Process = this.loadProcess("circularLineage1", "hive query for daily summary", "John ETL", (List<AtlasEntity>)ImmutableList.of((Object)circularLineageTable1), (List<AtlasEntity>)ImmutableList.of((Object)circularLineageTable2), "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        entities.add(circularLineage1Process);
        AtlasEntity circularLineage2Process = this.loadProcess("circularLineage2", "hive query for daily summary", "John ETL", (List<AtlasEntity>)ImmutableList.of((Object)circularLineageTable2), (List<AtlasEntity>)ImmutableList.of((Object)circularLineageTable1), "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        entities.add(circularLineage2Process);
        AtlasEntity loadSalesDaily = this.loadProcess("loadSalesDaily", "hive query for daily summary", "John ETL", (List<AtlasEntity>)ImmutableList.of((Object)salesFact, (Object)this.timeDim), (List<AtlasEntity>)ImmutableList.of((Object)salesFactDaily), "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        entities.add(loadSalesDaily);
        AtlasEntity logDB = this.database("Logging", "/apps/warehouse/logging", "Tim ETL", "hdfs://host:8000/apps/warehouse/logging", new String[0]);
        entities.add(logDB);
        sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        AtlasEntity loggingFactDaily = this.table("log_fact_daily_mv", "log fact daily materialized view", logDB, sd, "Tim ETL", "Managed", (List<AtlasEntity>)logFactColumns, LOGDATA_CLASSIFICATION);
        entities.add(loggingFactDaily);
        ImmutableList productDimColumns = ImmutableList.of((Object)this.column("product_id", "int", "product id", new String[0]), (Object)this.column("product_name", "string", "product name", new String[0]), (Object)this.column("brand_name", "int", "brand name", new String[0]));
        entities.addAll((Collection<AtlasEntity>)productDimColumns);
        sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        this.productDim = this.table("product_dim", "product dimension table", salesDB, sd, "John Doe 2", "Managed", (List<AtlasEntity>)productDimColumns, DIMENSION_CLASSIFICATION);
        entities.add(this.productDim);
        AtlasEntity productDimView = this.view("product_dim_view", reportingDB, (List<AtlasEntity>)ImmutableList.of((Object)this.productDim), DIMENSION_CLASSIFICATION, JDBC_CLASSIFICATION);
        entities.add(productDimView);
        ImmutableList customerDimColumns = ImmutableList.of((Object)this.column("customer_id", "int", "customer id", PII_CLASSIFICATION), (Object)this.column("name", "string", "customer name", PII_CLASSIFICATION), (Object)this.column("address", "string", "customer address", PII_CLASSIFICATION));
        entities.addAll((Collection<AtlasEntity>)customerDimColumns);
        sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        AtlasEntity customerDim = this.table("customer_dim", "customer dimension table", salesDB, sd, "fetl", "External", (List<AtlasEntity>)customerDimColumns, DIMENSION_CLASSIFICATION);
        entities.add(customerDim);
        AtlasEntity customerDimView = this.view("customer_dim_view", reportingDB, (List<AtlasEntity>)ImmutableList.of((Object)customerDim), DIMENSION_CLASSIFICATION, JDBC_CLASSIFICATION);
        entities.add(customerDimView);
        sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        AtlasEntity salesFactMonthly = this.table("sales_fact_monthly_mv", "sales fact monthly materialized view", reportingDB, sd, "Jane BI", "Managed", (List<AtlasEntity>)salesFactColumns, METRIC_CLASSIFICATION);
        entities.add(salesFactMonthly);
        AtlasEntity loadSalesMonthly = this.loadProcess("loadSalesMonthly", "hive query for monthly summary", "John ETL", (List<AtlasEntity>)ImmutableList.of((Object)salesFactDaily), (List<AtlasEntity>)ImmutableList.of((Object)salesFactMonthly), "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        entities.add(loadSalesMonthly);
        sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<AtlasEntity>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        entities.add(sd);
        this.loggingFactMonthly = this.table("logging_fact_monthly_mv", "logging fact monthly materialized view", logDB, sd, "Tim ETL 2", "Managed", (List<AtlasEntity>)logFactColumns, LOGDATA_CLASSIFICATION);
        entities.add(this.loggingFactMonthly);
        AtlasEntity loadLogsMonthly = this.loadProcess("loadLogsMonthly", "hive query for monthly summary", "Tim ETL", (List<AtlasEntity>)ImmutableList.of((Object)loggingFactDaily), (List<AtlasEntity>)ImmutableList.of((Object)this.loggingFactMonthly), "create table as select ", "plan", "id", "graph", ETL_CLASSIFICATION);
        entities.add(loadLogsMonthly);
        AtlasEntity datasetSubType = this.datasetSubType("dataSetSubTypeInst1", "testOwner");
        entities.add(datasetSubType);
        return new AtlasEntity.AtlasEntitiesWithExtInfo(entities);
    }

    protected void createClassificationTypes() {
        List<AtlasClassificationDef> cds = Arrays.asList(new AtlasClassificationDef(DIMENSION_CLASSIFICATION, "Dimension Classification", "1.0", Arrays.asList(new AtlasStructDef.AtlasAttributeDef("timeAttr", "string"), new AtlasStructDef.AtlasAttributeDef("productAttr", "string"))), new AtlasClassificationDef(FACT_CLASSIFICATION, "Fact Classification", "1.0"), new AtlasClassificationDef(PII_CLASSIFICATION, "PII Classification", "1.0"), new AtlasClassificationDef(METRIC_CLASSIFICATION, "Metric Classification", "1.0"), new AtlasClassificationDef(ETL_CLASSIFICATION, "ETL Classification", "1.0"), new AtlasClassificationDef(JDBC_CLASSIFICATION, "JdbcAccess Classification", "1.0"), new AtlasClassificationDef(LOGDATA_CLASSIFICATION, "LogData Classification", "1.0"), new AtlasClassificationDef(DIMENSIONAL_CLASSIFICATION, "Dimensional Classification", "1.0", Arrays.asList(new AtlasStructDef.AtlasAttributeDef("attr1", "string"))));
        AtlasTypesDef tds = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), cds, Collections.emptyList());
        this.createUpdateClassificationDef(tds);
    }

    private void createUpdateClassificationDef(AtlasTypesDef td) {
        try {
            this.typeDefStore.createTypesDef(td);
        }
        catch (Exception e) {
            Assert.fail((String)"Error creating classifications definitions.");
        }
    }

    AtlasEntity database(String name, String description, String owner, String locationUri, String ... traitNames) {
        AtlasEntity database = new AtlasEntity(DATABASE_TYPE);
        database.setAttribute("name", (Object)name);
        database.setAttribute("qualifiedName", (Object)("qualified:" + name));
        database.setAttribute("description", (Object)description);
        database.setAttribute("userDescription", (Object)description);
        database.setAttribute("owner", (Object)owner);
        database.setAttribute("location", (Object)locationUri);
        database.setAttribute("createTime", (Object)System.currentTimeMillis());
        database.setAttribute("clusterName", (Object)"cl1");
        database.setClassifications(Stream.of(traitNames).map(AtlasClassification::new).collect(Collectors.toList()));
        return database;
    }

    protected AtlasEntity storageDescriptor(String location, String inputFormat, String outputFormat, boolean compressed, List<AtlasEntity> columns) {
        AtlasEntity storageDescriptor = new AtlasEntity(STORAGE_DESC_TYPE);
        storageDescriptor.setAttribute("location", (Object)location);
        storageDescriptor.setAttribute("qualifiedName", (Object)("qualified:" + location));
        storageDescriptor.setAttribute("inputFormat", (Object)inputFormat);
        storageDescriptor.setAttribute("outputFormat", (Object)outputFormat);
        storageDescriptor.setAttribute("compressed", (Object)compressed);
        storageDescriptor.setAttribute("cols", this.getAtlasObjectIds(columns));
        return storageDescriptor;
    }

    protected AtlasEntity column(String name, String dataType, String comment, String ... traitNames) {
        AtlasEntity column = new AtlasEntity(COLUMN_TYPE);
        column.setAttribute("name", (Object)name);
        column.setAttribute("qualifiedName", (Object)("qualified:" + name));
        column.setAttribute("type", (Object)dataType);
        column.setAttribute("comment", (Object)comment);
        column.setClassifications(Stream.of(traitNames).map(AtlasClassification::new).collect(Collectors.toList()));
        return column;
    }

    protected AtlasEntity table(String name, String description, AtlasEntity db, AtlasEntity sd, String owner, String tableType, List<AtlasEntity> columns, String ... traitNames) {
        AtlasClassification classification;
        String dbName = db.getAttribute("name").toString();
        String clusterName = db.getAttribute("clusterName").toString();
        AtlasEntity table = new AtlasEntity(HIVE_TABLE_TYPE);
        table.setAttribute("name", (Object)name);
        table.setAttribute("qualifiedName", (Object)(dbName + "." + name));
        table.setAttribute("description", (Object)description);
        table.setAttribute("owner", (Object)owner);
        table.setAttribute("tableType", (Object)tableType);
        table.setAttribute("temporary", (Object)false);
        table.setAttribute("createTime", (Object)new Date(System.currentTimeMillis()));
        table.setAttribute("lastAccessTime", (Object)System.currentTimeMillis());
        table.setAttribute("retention", (Object)5.0);
        table.setAttribute("db", (Object)this.getAtlasObjectId(db));
        table.setAttribute("sd", (Object)this.getAtlasObjectId(sd));
        table.setAttribute("columns", this.getAtlasObjectIds(columns));
        if (name.equals("time_dim")) {
            classification = new AtlasClassification(traitNames[0], (Map)new HashMap<String, Object>(){
                {
                    this.put("timeAttr", "timeValue");
                }
            });
            table.setClassifications(Collections.singletonList(classification));
        } else if (name.equals("product_dim")) {
            classification = new AtlasClassification(traitNames[0], (Map)new HashMap<String, Object>(){
                {
                    this.put("productAttr", "productValue");
                }
            });
            table.setClassifications(Collections.singletonList(classification));
        } else {
            table.setClassifications(Stream.of(traitNames).map(AtlasClassification::new).collect(Collectors.toList()));
        }
        sd.setAttribute("qualifiedName", (Object)(dbName + "." + name + "@" + clusterName + "_storage"));
        AtlasObjectId tableId = this.getAtlasObjectId(table);
        sd.setAttribute("table", (Object)tableId);
        for (AtlasEntity column : columns) {
            column.setAttribute("qualifiedName", (Object)(dbName + "." + name + "." + column.getAttribute("name").toString() + "@" + clusterName));
            column.setAttribute("table", (Object)tableId);
        }
        return table;
    }

    private List<AtlasObjectId> getAtlasObjectIds(List<AtlasEntity> columns) {
        ArrayList<AtlasObjectId> objIds = new ArrayList<AtlasObjectId>();
        for (AtlasEntity e : columns) {
            AtlasObjectId oid = this.getAtlasObjectId(e);
            objIds.add(oid);
        }
        return objIds;
    }

    private AtlasObjectId getAtlasObjectId(AtlasEntity e) {
        return new AtlasObjectId(e.getGuid(), e.getTypeName());
    }

    protected AtlasEntity loadProcess(String name, String description, String user, List<AtlasEntity> inputTables, List<AtlasEntity> outputTables, String queryText, String queryPlan, String queryId, String queryGraph, String ... traitNames) {
        AtlasEntity process = new AtlasEntity("hive_process");
        process.setAttribute("name", (Object)name);
        process.setAttribute("qualifiedName", (Object)name);
        process.setAttribute("description", (Object)description);
        process.setAttribute("userName", (Object)user);
        process.setAttribute("startTime", (Object)System.currentTimeMillis());
        process.setAttribute("endTime", (Object)(System.currentTimeMillis() + 10000L));
        process.setAttribute("operationType", (Object)"load");
        process.setAttribute("inputs", this.getAtlasObjectIds(inputTables));
        process.setAttribute("outputs", this.getAtlasObjectIds(outputTables));
        process.setAttribute("queryText", (Object)queryText);
        process.setAttribute("queryPlan", (Object)queryPlan);
        process.setAttribute("queryId", (Object)queryId);
        process.setAttribute("queryGraph", (Object)queryGraph);
        process.setClassifications(Stream.of(traitNames).map(AtlasClassification::new).collect(Collectors.toList()));
        return process;
    }

    AtlasEntity view(String name, AtlasEntity dbId, List<AtlasEntity> inputTables, String ... traitNames) {
        AtlasEntity view = new AtlasEntity("hive_process");
        view.setAttribute("name", (Object)name);
        view.setAttribute("qualifiedName", (Object)name);
        view.setAttribute("userName", (Object)"testUser");
        view.setAttribute("startTime", (Object)System.currentTimeMillis());
        view.setAttribute("endTime", (Object)(System.currentTimeMillis() + 10000L));
        view.setAttribute("operationType", (Object)"view");
        view.setAttribute("query", (Object)"create table as select");
        view.setAttribute("queryText", (Object)"create table as select");
        view.setAttribute("queryPlan", (Object)"viewPlan");
        view.setAttribute("queryId", (Object)"view1");
        view.setAttribute("db", (Object)this.getAtlasObjectId(dbId));
        view.setAttribute("inputs", this.getAtlasObjectIds(inputTables));
        view.setClassifications(Stream.of(traitNames).map(AtlasClassification::new).collect(Collectors.toList()));
        return view;
    }

    AtlasEntity datasetSubType(String name, String owner) {
        AtlasEntity datasetSubType = new AtlasEntity(DATASET_SUBTYPE);
        datasetSubType.setAttribute("qualifiedName", (Object)name);
        datasetSubType.setAttribute("name", (Object)name);
        datasetSubType.setAttribute("owner", (Object)owner);
        return datasetSubType;
    }

    public EntityMutationResponse createDummyEntity(String name, String type, String ... traitNames) throws AtlasBaseException {
        AtlasEntity entity = new AtlasEntity(type);
        entity.setAttribute("name", (Object)name);
        entity.setAttribute("qualifiedName", (Object)name);
        entity.setClassifications(Stream.of(traitNames).map(AtlasClassification::new).collect(Collectors.toList()));
        EntityMutationResponse resp = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entity)), false);
        return resp;
    }

    public SearchParameters.FilterCriteria getSingleFilterCondition(String attName, SearchParameters.Operator op, String attrValue) {
        SearchParameters.FilterCriteria filterCriteria = new SearchParameters.FilterCriteria();
        filterCriteria.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        ArrayList<SearchParameters.FilterCriteria> criteria = new ArrayList<SearchParameters.FilterCriteria>();
        SearchParameters.FilterCriteria f1 = new SearchParameters.FilterCriteria();
        f1.setAttributeName(attName);
        f1.setOperator(op);
        String time = String.valueOf(System.currentTimeMillis());
        f1.setAttributeValue(attrValue);
        criteria.add(f1);
        filterCriteria.setCriterion(criteria);
        return filterCriteria;
    }

    public void assignGlossary() {
        try {
            AtlasGlossary glossary = new AtlasGlossary();
            glossary.setName(SALES_GLOSSARY);
            glossary = this.glossaryService.createGlossary(glossary);
            AtlasGlossaryTerm term = new AtlasGlossaryTerm();
            term.setAnchor(new AtlasGlossaryHeader(glossary.getGuid()));
            term.setName(SALES_TERM);
            term = this.glossaryService.createTerm(term);
            AtlasGlossaryTerm modernTrade = new AtlasGlossaryTerm();
            modernTrade.setAnchor(new AtlasGlossaryHeader(glossary.getGuid()));
            modernTrade.setName(MODERNTRADE_TERM);
            modernTrade = this.glossaryService.createTerm(modernTrade);
            AtlasGlossaryTerm ecomm = new AtlasGlossaryTerm();
            ecomm.setAnchor(new AtlasGlossaryHeader(glossary.getGuid()));
            ecomm.setName(ECOMMERCE_TERM);
            ecomm = this.glossaryService.createTerm(ecomm);
            ArrayList<AtlasRelatedObjectId> guids = new ArrayList<AtlasRelatedObjectId>();
            ArrayList<AtlasRelatedObjectId> mordernTradeGuids = new ArrayList<AtlasRelatedObjectId>();
            ArrayList<AtlasRelatedObjectId> ecomGuid = new ArrayList<AtlasRelatedObjectId>();
            for (AtlasEntityHeader p : this.hiveEntities.getCreatedEntities()) {
                if (!StringUtils.equals((String)p.getTypeName(), (String)HIVE_TABLE_TYPE)) continue;
                AtlasRelatedObjectId obj = new AtlasRelatedObjectId();
                obj.setGuid(p.getGuid());
                obj.setTypeName(p.getTypeName());
                guids.add(obj);
                if (p.getAttribute("name").equals(this.timeDim.getAttribute("name"))) {
                    this.timeDim.setGuid(p.getGuid());
                    AtlasRelatedObjectId obj1 = new AtlasRelatedObjectId();
                    obj1.setGuid(p.getGuid());
                    obj1.setTypeName(p.getTypeName());
                    mordernTradeGuids.add(obj1);
                    continue;
                }
                if (p.getAttribute("name").equals(this.productDim.getAttribute("name"))) {
                    this.productDim.setGuid(p.getGuid());
                    AtlasRelatedObjectId obj2 = new AtlasRelatedObjectId();
                    obj2.setGuid(p.getGuid());
                    obj2.setTypeName(p.getTypeName());
                    ecomGuid.add(obj2);
                    continue;
                }
                if (!p.getAttribute("name").equals(this.loggingFactMonthly.getAttribute("name"))) continue;
                this.loggingFactMonthly.setGuid(p.getGuid());
                AtlasRelatedObjectId obj3 = new AtlasRelatedObjectId();
                obj3.setGuid(p.getGuid());
                obj3.setTypeName(p.getTypeName());
                mordernTradeGuids.add(obj3);
            }
            this.glossaryService.assignTermToEntities(term.getGuid(), guids);
            this.glossaryService.assignTermToEntities(modernTrade.getGuid(), mordernTradeGuids);
            this.glossaryService.assignTermToEntities(ecomm.getGuid(), ecomGuid);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Failed to assign glossary term");
        }
    }
}

