/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool.utils.local;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.atlas.notification.spool.utils.local.FileOpAppend;
import org.apache.atlas.notification.spool.utils.local.FileOperation;

public class FileOpUpdate
extends FileOperation {
    private String id;
    private final FileOpAppend fileOpAppend;

    public FileOpUpdate(String source, FileOpAppend fileOpAppend) {
        super(source);
        this.fileOpAppend = fileOpAppend;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public FileLock run(RandomAccessFile file, FileChannel channel, String json) throws IOException {
        FileLock ret;
        long position = FileOpUpdate.find(file, this.getId());
        if (position < 0L) {
            ret = this.fileOpAppend.run(file, channel, json);
        } else {
            ret = channel.tryLock(position, json.length(), false);
            channel.position(position);
            file.writeBytes(json);
        }
        return ret;
    }
}

