define([ "require", "backbone", "hbs!tmpl/tag/TagAttributeItemView_tmpl" ], function(require, Backbone, TagAttributeItemViewTmpl) {
    "use strict";
    return Backbone.Marionette.ItemView.extend({
        template: TagAttributeItemViewTmpl,
        regions: {},
        ui: {
            attributeInput: "[data-id='attributeInput']",
            close: "[data-id='close']",
            dataTypeSelector: "[data-id='dataTypeSelector']"
        },
        events: function() {
            var events = {};
            return events["keyup " + this.ui.attributeInput] = function(e) {
                this.model.set({
                    name: e.target.value.trim()
                });
            }, events["change " + this.ui.dataTypeSelector] = function(e) {
                this.model.set({
                    typeName: e.target.value.trim()
                });
            }, events["click " + this.ui.close] = "onCloseButton", events;
        },
        initialize: function(options) {
            this.parentView = options.parentView;
        },
        onRender: function() {
            var that = this;
            this.parentView.enumDefCollection.fullCollection.each(function(model) {
                that.ui.dataTypeSelector.append("<option>" + model.get("name") + "</option>");
            });
        },
        onCloseButton: function() {
            this.parentView.$el.find('[data-id="tagName"]').val();
            this.parentView.collection.models.length > 0 && this.model.destroy(), 1 === this.parentView.$el.find("input").length && $(this.ui.close).hide();
        }
    });
});