require.config({
    hbs: {
        disableI18n: !0,
        helperPathCallback: function(name) {
            return "modules/Helpers";
        },
        templateExtension: "html",
        compileOptions: {}
    },
    urlArgs: "bust=" + getBustValue(),
    deps: [ "marionette" ],
    waitSeconds: 30,
    shim: {
        backbone: {
            deps: [ "underscore", "jquery" ],
            exports: "Backbone"
        },
        bootstrap: {
            deps: [ "jquery" ],
            exports: "jquery"
        },
        underscore: {
            exports: "_"
        },
        marionette: {
            deps: [ "backbone" ]
        },
        hbs: {
            deps: [ "underscore", "handlebars" ]
        },
        "jquery-placeholder": {
            deps: [ "jquery" ]
        },
        "jquery-ui": {
            deps: [ "jquery" ]
        },
        "moment-timezone": {
            deps: [ "moment" ]
        },
        moment: {
            exports: [ "moment" ]
        },
        pnotify: {
            exports: [ "pnotify" ]
        },
        d3: {
            exports: [ "d3" ]
        }
    },
    paths: {
        jquery: "libs/jquery/js/jquery.min",
        underscore: "libs/underscore/underscore-min",
        bootstrap: "libs/bootstrap/js/bootstrap.min",
        backbone: "libs/backbone/backbone-min",
        "backbone.babysitter": "libs/backbone.babysitter/lib/backbone.babysitter.min",
        marionette: "libs/backbone-marionette/backbone.marionette.min",
        "backbone.paginator": "libs/backbone-paginator/backbone.paginator.min",
        tmpl: "templates",
        "requirejs.text": "libs/requirejs-text/text",
        handlebars: "external_lib/require-handlebars-plugin/js/handlebars",
        hbs: "external_lib/require-handlebars-plugin/js/hbs",
        i18nprecompile: "external_lib/require-handlebars-plugin/js/i18nprecompile",
        "jquery-placeholder": "libs/jquery-placeholder/js/jquery.placeholder",
        platform: "libs/platform/platform",
        pnotify: "external_lib/pnotify/pnotify.custom.min",
        "pnotify.buttons": "external_lib/pnotify/pnotify.custom.min",
        "pnotify.confirm": "external_lib/pnotify/pnotify.custom.min",
        moment: "libs/moment/js/moment.min",
        "moment-timezone": "libs/moment-timezone/moment-timezone-with-data.min",
        "jquery-ui": "external_lib/jquery-ui/jquery-ui.min",
        d3: "libs/d3/d3.min"
    },
    enforceDefine: !1
}), require([ "marionette", "utils/Helper", "bootstrap" ], function(Marionette, Helper) {
    var App = new Marionette.Application();
    App.addRegions({
        rContent: ".page-wrapper"
    }), App.addInitializer(function() {
        Backbone.history.start();
    });
    var Router = Backbone.Router.extend({
        routes: {
            "": "defaultAction",
            "*actions": "defaultAction"
        },
        initialize: function(options) {},
        showRegions: function() {},
        execute: function(callback, args) {
            this.preRouteExecute(), callback && callback.apply(this, args), this.postRouteExecute();
        },
        preRouteExecute: function() {},
        postRouteExecute: function(name, args) {},
        defaultAction: function() {
            require([ "views/migration/MigrationView" ], function(MigrationView) {
                App.rContent.show(new MigrationView());
            });
        }
    });
    App.appRouter = new Router({
        entityDefCollection: this.entityDefCollection
    }), App.start();
});