/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.util;

import junit.framework.TestCase;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.util.VectorBatchAppender;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestVectorBatchAppender {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testBatchAppendIntVector() {
        int length1 = 10;
        int length2 = 5;
        int length3 = 7;
        try (IntVector target = new IntVector("", this.allocator);
             IntVector delta1 = new IntVector("", this.allocator);
             IntVector delta2 = new IntVector("", this.allocator);){
            target.allocateNew(10);
            delta1.allocateNew(5);
            delta2.allocateNew(7);
            ValueVectorDataPopulator.setVector(target, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
            ValueVectorDataPopulator.setVector(delta1, 10, 11, 12, 13, 14);
            ValueVectorDataPopulator.setVector(delta2, 15, 16, 17, 18, 19, 20, 21);
            VectorBatchAppender.batchAppend((ValueVector)target, (ValueVector[])new IntVector[]{delta1, delta2});
            TestCase.assertEquals((int)22, (int)target.getValueCount());
            for (int i = 0; i < target.getValueCount(); ++i) {
                TestCase.assertEquals((int)i, (int)target.get(i));
            }
        }
    }
}

