/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.types.pojo;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.vector.ExtensionTypeVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.compare.Range;
import org.apache.arrow.vector.compare.RangeEqualsVisitor;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.ExtensionTypeRegistry;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.VectorBatchAppender;
import org.apache.arrow.vector.validate.ValidateVectorVisitor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestExtensionType {
    @Test
    public void roundtripUuid() throws IOException {
        ExtensionTypeRegistry.register((ArrowType.ExtensionType)new UuidType());
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"a", (ArrowType)new UuidType())));
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);){
            Throwable throwable;
            UUID u1 = UUID.randomUUID();
            UUID u2 = UUID.randomUUID();
            UuidVector vector = (UuidVector)root.getVector("a");
            vector.setValueCount(2);
            vector.set(0, u1);
            vector.set(1, u2);
            root.setRowCount(2);
            File file = File.createTempFile("uuidtest", ".arrow");
            try (SeekableByteChannel channel = FileChannel.open(Paths.get(file.getAbsolutePath(), new String[0]), StandardOpenOption.WRITE);){
                throwable = null;
                try (ArrowFileWriter writer = new ArrowFileWriter(root, null, (WritableByteChannel)channel);){
                    writer.start();
                    writer.writeBatch();
                    writer.end();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            channel = Files.newByteChannel(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);
            var11_13 = null;
            try {
                throwable = null;
                try (ArrowFileReader reader = new ArrowFileReader(channel, (BufferAllocator)allocator);){
                    reader.loadNextBatch();
                    VectorSchemaRoot readerRoot = reader.getVectorSchemaRoot();
                    Assert.assertEquals((Object)root.getSchema(), (Object)readerRoot.getSchema());
                    Field field = (Field)readerRoot.getSchema().getFields().get(0);
                    UuidType expectedType = new UuidType();
                    Assert.assertEquals(field.getMetadata().get("ARROW:extension:name"), (Object)expectedType.extensionName());
                    Assert.assertEquals(field.getMetadata().get("ARROW:extension:metadata"), (Object)expectedType.serialize());
                    ExtensionTypeVector deserialized = (ExtensionTypeVector)readerRoot.getFieldVectors().get(0);
                    Assert.assertEquals((long)vector.getValueCount(), (long)deserialized.getValueCount());
                    for (int i = 0; i < vector.getValueCount(); ++i) {
                        Assert.assertEquals((Object)vector.isNull(i), (Object)deserialized.isNull(i));
                        if (vector.isNull(i)) continue;
                        Assert.assertEquals((Object)vector.getObject(i), (Object)deserialized.getObject(i));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var11_13 = throwable4;
                throw throwable4;
            }
            finally {
                if (channel != null) {
                    TestExtensionType.$closeResource(var11_13, channel);
                }
            }
        }
    }

    @Test
    public void readUnderlyingType() throws IOException {
        ExtensionTypeRegistry.register((ArrowType.ExtensionType)new UuidType());
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"a", (ArrowType)new UuidType())));
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);){
            Throwable throwable;
            UUID u1 = UUID.randomUUID();
            UUID u2 = UUID.randomUUID();
            UuidVector vector = (UuidVector)root.getVector("a");
            vector.setValueCount(2);
            vector.set(0, u1);
            vector.set(1, u2);
            root.setRowCount(2);
            File file = File.createTempFile("uuidtest", ".arrow");
            try (SeekableByteChannel channel = FileChannel.open(Paths.get(file.getAbsolutePath(), new String[0]), StandardOpenOption.WRITE);){
                throwable = null;
                try (ArrowFileWriter writer = new ArrowFileWriter(root, null, (WritableByteChannel)channel);){
                    writer.start();
                    writer.writeBatch();
                    writer.end();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            ExtensionTypeRegistry.unregister((ArrowType.ExtensionType)new UuidType());
            channel = Files.newByteChannel(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);
            var11_13 = null;
            try {
                throwable = null;
                try (ArrowFileReader reader = new ArrowFileReader(channel, (BufferAllocator)allocator);){
                    reader.loadNextBatch();
                    VectorSchemaRoot readerRoot = reader.getVectorSchemaRoot();
                    Assert.assertEquals((long)1L, (long)readerRoot.getSchema().getFields().size());
                    Assert.assertEquals((Object)"a", (Object)((Field)readerRoot.getSchema().getFields().get(0)).getName());
                    Assert.assertTrue((boolean)(((Field)readerRoot.getSchema().getFields().get(0)).getType() instanceof ArrowType.FixedSizeBinary));
                    Assert.assertEquals((long)16L, (long)((ArrowType.FixedSizeBinary)((Field)readerRoot.getSchema().getFields().get(0)).getType()).getByteWidth());
                    Field field = (Field)readerRoot.getSchema().getFields().get(0);
                    UuidType expectedType = new UuidType();
                    Assert.assertEquals(field.getMetadata().get("ARROW:extension:name"), (Object)expectedType.extensionName());
                    Assert.assertEquals(field.getMetadata().get("ARROW:extension:metadata"), (Object)expectedType.serialize());
                    FixedSizeBinaryVector deserialized = (FixedSizeBinaryVector)readerRoot.getFieldVectors().get(0);
                    Assert.assertEquals((long)vector.getValueCount(), (long)deserialized.getValueCount());
                    for (int i = 0; i < vector.getValueCount(); ++i) {
                        Assert.assertEquals((Object)vector.isNull(i), (Object)deserialized.isNull(i));
                        if (vector.isNull(i)) continue;
                        UUID uuid = vector.getObject(i);
                        ByteBuffer bb = ByteBuffer.allocate(16);
                        bb.putLong(uuid.getMostSignificantBits());
                        bb.putLong(uuid.getLeastSignificantBits());
                        Assert.assertArrayEquals((byte[])bb.array(), (byte[])deserialized.get(i));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var11_13 = throwable4;
                throw throwable4;
            }
            finally {
                if (channel != null) {
                    TestExtensionType.$closeResource(var11_13, channel);
                }
            }
        }
    }

    @Test
    public void testNullCheck() {
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> {
            RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
            Throwable throwable = null;
            try {
                UuidVector vector = new UuidVector("uuid", (BufferAllocator)allocator, null);
                Throwable throwable2 = null;
                try {
                    vector.getField();
                    vector.allocateNewSafe();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    TestExtensionType.$closeResource(throwable2, (AutoCloseable)((Object)vector));
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                TestExtensionType.$closeResource(throwable, (AutoCloseable)allocator);
            }
        });
        Assert.assertTrue((boolean)e.getMessage().contains("underlyingVector can not be null."));
    }

    @Test
    public void roundtripLocation() throws IOException {
        ExtensionTypeRegistry.register((ArrowType.ExtensionType)new LocationType());
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"location", (ArrowType)new LocationType())));
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);){
            Throwable throwable;
            LocationVector vector = (LocationVector)root.getVector("location");
            vector.allocateNew();
            vector.set(0, 34.073814f, -118.24078f);
            vector.set(2, 37.768055f, -122.3875f);
            vector.set(3, 40.739716f, -73.84078f);
            vector.setValueCount(4);
            root.setRowCount(4);
            File file = File.createTempFile("locationtest", ".arrow");
            try (SeekableByteChannel channel = FileChannel.open(Paths.get(file.getAbsolutePath(), new String[0]), StandardOpenOption.WRITE);){
                throwable = null;
                try (ArrowFileWriter writer = new ArrowFileWriter(root, null, (WritableByteChannel)channel);){
                    writer.start();
                    writer.writeBatch();
                    writer.end();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            channel = Files.newByteChannel(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);
            var9_11 = null;
            try {
                throwable = null;
                try (ArrowFileReader reader = new ArrowFileReader(channel, (BufferAllocator)allocator);){
                    reader.loadNextBatch();
                    VectorSchemaRoot readerRoot = reader.getVectorSchemaRoot();
                    Assert.assertEquals((Object)root.getSchema(), (Object)readerRoot.getSchema());
                    Field field = (Field)readerRoot.getSchema().getFields().get(0);
                    LocationType expectedType = new LocationType();
                    Assert.assertEquals(field.getMetadata().get("ARROW:extension:name"), (Object)expectedType.extensionName());
                    Assert.assertEquals(field.getMetadata().get("ARROW:extension:metadata"), (Object)expectedType.serialize());
                    ExtensionTypeVector deserialized = (ExtensionTypeVector)readerRoot.getFieldVectors().get(0);
                    Assert.assertTrue((boolean)(deserialized instanceof LocationVector));
                    Assert.assertEquals((Object)deserialized.getName(), (Object)"location");
                    StructVector deserStruct = (StructVector)deserialized.getUnderlyingVector();
                    Assert.assertNotNull((Object)deserStruct.getChild("Latitude"));
                    Assert.assertNotNull((Object)deserStruct.getChild("Longitude"));
                    Assert.assertEquals((long)vector.getValueCount(), (long)deserialized.getValueCount());
                    for (int i = 0; i < vector.getValueCount(); ++i) {
                        Assert.assertEquals((Object)vector.isNull(i), (Object)deserialized.isNull(i));
                        if (vector.isNull(i)) continue;
                        Assert.assertEquals((Object)vector.getObject(i), (Object)deserialized.getObject(i));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var9_11 = throwable4;
                throw throwable4;
            }
            finally {
                if (channel != null) {
                    TestExtensionType.$closeResource(var9_11, channel);
                }
            }
        }
    }

    @Test
    public void testVectorCompare() {
        UuidType uuidType = new UuidType();
        ExtensionTypeRegistry.register((ArrowType.ExtensionType)uuidType);
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             UuidVector a1 = (UuidVector)uuidType.getNewVector("a", FieldType.nullable((ArrowType)uuidType), (BufferAllocator)allocator);
             UuidVector a2 = (UuidVector)uuidType.getNewVector("a", FieldType.nullable((ArrowType)uuidType), (BufferAllocator)allocator);
             UuidVector bb = (UuidVector)uuidType.getNewVector("a", FieldType.nullable((ArrowType)uuidType), (BufferAllocator)allocator);){
            UUID u1 = UUID.randomUUID();
            UUID u2 = UUID.randomUUID();
            ValidateVectorVisitor validateVisitor = new ValidateVectorVisitor();
            validateVisitor.visit((ExtensionTypeVector)a1, null);
            a1.setValueCount(2);
            a1.set(0, u1);
            a1.set(1, u2);
            a2.setValueCount(2);
            a2.set(0, u1);
            a2.set(1, u2);
            bb.setValueCount(2);
            bb.set(0, u2);
            bb.set(1, u1);
            Range range = new Range(0, 0, a1.getValueCount());
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)a1, (ValueVector)a2);
            Assert.assertTrue((boolean)visitor.rangeEquals(range));
            visitor = new RangeEqualsVisitor((ValueVector)a1, (ValueVector)bb);
            Assert.assertFalse((boolean)visitor.rangeEquals(range));
            VectorBatchAppender.batchAppend((ValueVector)a1, (ValueVector[])new UuidVector[]{a2, bb});
            Assert.assertEquals((long)a1.getValueCount(), (long)6L);
            validateVisitor.visit((ExtensionTypeVector)a1, null);
        }
    }

    public static class LocationVector
    extends ExtensionTypeVector<StructVector> {
        private static StructVector buildUnderlyingVector(String name, BufferAllocator allocator) {
            StructVector underlyingVector = new StructVector(name, allocator, FieldType.nullable((ArrowType)ArrowType.Struct.INSTANCE), null);
            underlyingVector.addOrGet("Latitude", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), Float4Vector.class);
            underlyingVector.addOrGet("Longitude", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), Float4Vector.class);
            return underlyingVector;
        }

        public LocationVector(String name, BufferAllocator allocator) {
            super(name, allocator, (ValueVector)LocationVector.buildUnderlyingVector(name, allocator));
        }

        public int hashCode(int index) {
            return this.hashCode(index, null);
        }

        public int hashCode(int index, ArrowBufHasher hasher) {
            return ((StructVector)this.getUnderlyingVector()).hashCode(index, hasher);
        }

        public Map<String, ?> getObject(int index) {
            return ((StructVector)this.getUnderlyingVector()).getObject(index);
        }

        public void set(int index, float latitude, float longitude) {
            ((Float4Vector)((StructVector)this.getUnderlyingVector()).getChild("Latitude", Float4Vector.class)).set(index, latitude);
            ((Float4Vector)((StructVector)this.getUnderlyingVector()).getChild("Longitude", Float4Vector.class)).set(index, longitude);
            ((StructVector)this.getUnderlyingVector()).setIndexDefined(index);
        }
    }

    static class LocationType
    extends ArrowType.ExtensionType {
        LocationType() {
        }

        public ArrowType storageType() {
            return ArrowType.Struct.INSTANCE;
        }

        public String extensionName() {
            return "location";
        }

        public boolean extensionEquals(ArrowType.ExtensionType other) {
            return other instanceof LocationType;
        }

        public ArrowType deserialize(ArrowType storageType, String serializedData) {
            if (!storageType.equals(this.storageType())) {
                throw new UnsupportedOperationException("Cannot construct LocationType from underlying type " + storageType);
            }
            return new LocationType();
        }

        public String serialize() {
            return "";
        }

        public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator) {
            return new LocationVector(name, allocator);
        }
    }

    static class UuidVector
    extends ExtensionTypeVector<FixedSizeBinaryVector> {
        public UuidVector(String name, BufferAllocator allocator, FixedSizeBinaryVector underlyingVector) {
            super(name, allocator, (ValueVector)underlyingVector);
        }

        public UUID getObject(int index) {
            ByteBuffer bb = ByteBuffer.wrap(((FixedSizeBinaryVector)this.getUnderlyingVector()).getObject(index));
            return new UUID(bb.getLong(), bb.getLong());
        }

        public int hashCode(int index) {
            return this.hashCode(index, null);
        }

        public int hashCode(int index, ArrowBufHasher hasher) {
            return ((FixedSizeBinaryVector)this.getUnderlyingVector()).hashCode(index, hasher);
        }

        public void set(int index, UUID uuid) {
            ByteBuffer bb = ByteBuffer.allocate(16);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            ((FixedSizeBinaryVector)this.getUnderlyingVector()).set(index, bb.array());
        }
    }

    static class UuidType
    extends ArrowType.ExtensionType {
        UuidType() {
        }

        public ArrowType storageType() {
            return new ArrowType.FixedSizeBinary(16);
        }

        public String extensionName() {
            return "uuid";
        }

        public boolean extensionEquals(ArrowType.ExtensionType other) {
            return other instanceof UuidType;
        }

        public ArrowType deserialize(ArrowType storageType, String serializedData) {
            if (!storageType.equals(this.storageType())) {
                throw new UnsupportedOperationException("Cannot construct UuidType from underlying type " + storageType);
            }
            return new UuidType();
        }

        public String serialize() {
            return "";
        }

        public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator) {
            return new UuidVector(name, allocator, new FixedSizeBinaryVector(name, allocator, 16));
        }
    }
}

