/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.testing;

import junit.framework.TestCase;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.compare.VectorEqualsVisitor;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestValueVectorPopulator {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testPopulateBigIntVector() {
        try (BigIntVector vector1 = new BigIntVector("vector", this.allocator);
             BigIntVector vector2 = new BigIntVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1L, null, 3L, null, 5L, null, 7L, null, 9L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateBitVector() {
        try (BitVector vector1 = new BitVector("vector", this.allocator);
             BitVector vector2 = new BitVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i > 5 ? 0 : 1);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1, null, 1, null, 1, null, 0, null, 0);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateDateDayVector() {
        try (DateDayVector vector1 = new DateDayVector("vector", this.allocator);
             DateDayVector vector2 = new DateDayVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i * 10);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 10, null, 30, null, 50, null, 70, null, 90);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateDateMilliVector() {
        try (DateMilliVector vector1 = new DateMilliVector("vector", this.allocator);
             DateMilliVector vector2 = new DateMilliVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)(i * 1000));
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1000L, null, 3000L, null, 5000L, null, 7000L, null, 9000L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateDecimalVector() {
        try (DecimalVector vector1 = new DecimalVector("vector", this.allocator, 10, 3);
             DecimalVector vector2 = new DecimalVector("vector", this.allocator, 10, 3);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1L, null, 3L, null, 5L, null, 7L, null, 9L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateDurationVector() {
        FieldType fieldType = FieldType.nullable((ArrowType)new ArrowType.Duration(TimeUnit.SECOND));
        try (DurationVector vector1 = new DurationVector("vector", fieldType, this.allocator);
             DurationVector vector2 = new DurationVector("vector", fieldType, this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1L, null, 3L, null, 5L, null, 7L, null, 9L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateFixedSizeBinaryVector() {
        try (FixedSizeBinaryVector vector1 = new FixedSizeBinaryVector("vector", this.allocator, 5);
             FixedSizeBinaryVector vector2 = new FixedSizeBinaryVector("vector", this.allocator, 5);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, ("test" + i).getBytes());
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{null, "test1".getBytes(), null, "test3".getBytes(), null, "test5".getBytes(), null, "test7".getBytes(), null, "test9".getBytes()});
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateFloat4Vector() {
        try (Float4Vector vector1 = new Float4Vector("vector", this.allocator);
             Float4Vector vector2 = new Float4Vector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (float)i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, Float.valueOf(1.0f), null, Float.valueOf(3.0f), null, Float.valueOf(5.0f), null, Float.valueOf(7.0f), null, Float.valueOf(9.0f));
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateFloat8Vector() {
        try (Float8Vector vector1 = new Float8Vector("vector", this.allocator);
             Float8Vector vector2 = new Float8Vector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (double)i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1.0, null, 3.0, null, 5.0, null, 7.0, null, 9.0);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateIntVector() {
        try (IntVector vector1 = new IntVector("vector", this.allocator);
             IntVector vector2 = new IntVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1, null, 3, null, 5, null, 7, null, 9);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateSmallIntVector() {
        try (SmallIntVector vector1 = new SmallIntVector("vector", this.allocator);
             SmallIntVector vector2 = new SmallIntVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, (short)1, null, (short)3, null, (short)5, null, (short)7, null, (short)9);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateIntervalDayVector() {
        try (IntervalYearVector vector1 = new IntervalYearVector("vector", this.allocator);
             IntervalYearVector vector2 = new IntervalYearVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1, null, 3, null, 5, null, 7, null, 9);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateTimeMicroVector() {
        try (TimeMicroVector vector1 = new TimeMicroVector("vector", this.allocator);
             TimeMicroVector vector2 = new TimeMicroVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)(i * 10000));
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 10000L, null, 30000L, null, 50000L, null, 70000L, null, 90000L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateTimeMilliVector() {
        try (TimeMilliVector vector1 = new TimeMilliVector("vector", this.allocator);
             TimeMilliVector vector2 = new TimeMilliVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i * 100);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 100, null, 300, null, 500, null, 700, null, 900);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateTimeNanoVector() {
        try (TimeNanoVector vector1 = new TimeNanoVector("vector", this.allocator);
             TimeNanoVector vector2 = new TimeNanoVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)(i * 10000));
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 10000L, null, 30000L, null, 50000L, null, 70000L, null, 90000L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateTimeSecVector() {
        try (TimeSecVector vector1 = new TimeSecVector("vector", this.allocator);
             TimeSecVector vector2 = new TimeSecVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i * 100);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 100, null, 300, null, 500, null, 700, null, 900);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateTimeStampMicroVector() {
        try (TimeStampMicroVector vector1 = new TimeStampMicroVector("vector", this.allocator);
             TimeStampMicroVector vector2 = new TimeStampMicroVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)(i * 10000));
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 10000L, null, 30000L, null, 50000L, null, 70000L, null, 90000L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateTimeStampMilliVector() {
        try (TimeStampMilliVector vector1 = new TimeStampMilliVector("vector", this.allocator);
             TimeStampMilliVector vector2 = new TimeStampMilliVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)(i * 10000));
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 10000L, null, 30000L, null, 50000L, null, 70000L, null, 90000L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateTimeStampNanoVector() {
        try (TimeStampNanoVector vector1 = new TimeStampNanoVector("vector", this.allocator);
             TimeStampNanoVector vector2 = new TimeStampNanoVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)(i * 10000));
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 10000L, null, 30000L, null, 50000L, null, 70000L, null, 90000L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateTimeStampSecVector() {
        try (TimeStampSecVector vector1 = new TimeStampSecVector("vector", this.allocator);
             TimeStampSecVector vector2 = new TimeStampSecVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)(i * 100));
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 100L, null, 300L, null, 500L, null, 700L, null, 900L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateTinyIntVector() {
        try (TinyIntVector vector1 = new TinyIntVector("vector", this.allocator);
             TinyIntVector vector2 = new TinyIntVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, (byte)1, null, (byte)3, null, (byte)5, null, (byte)7, null, (byte)9);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateUInt1Vector() {
        try (UInt1Vector vector1 = new UInt1Vector("vector", this.allocator);
             UInt1Vector vector2 = new UInt1Vector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, (byte)1, null, (byte)3, null, (byte)5, null, (byte)7, null, (byte)9);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateUInt2Vector() {
        try (UInt2Vector vector1 = new UInt2Vector("vector", this.allocator);
             UInt2Vector vector2 = new UInt2Vector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, Character.valueOf('\u0001'), null, Character.valueOf('\u0003'), null, Character.valueOf('\u0005'), null, Character.valueOf('\u0007'), null, Character.valueOf('\t'));
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateUInt4Vector() {
        try (UInt4Vector vector1 = new UInt4Vector("vector", this.allocator);
             UInt4Vector vector2 = new UInt4Vector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1, null, 3, null, 5, null, 7, null, 9);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateUInt8Vector() {
        try (UInt8Vector vector1 = new UInt8Vector("vector", this.allocator);
             UInt8Vector vector2 = new UInt8Vector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, (long)i);
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, 1L, null, 3L, null, 5L, null, 7L, null, 9L);
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateVarBinaryVector() {
        try (VarBinaryVector vector1 = new VarBinaryVector("vector", this.allocator);
             VarBinaryVector vector2 = new VarBinaryVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, ("test" + i).getBytes());
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{null, "test1".getBytes(), null, "test3".getBytes(), null, "test5".getBytes(), null, "test7".getBytes(), null, "test9".getBytes()});
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testPopulateVarCharVector() {
        try (VarCharVector vector1 = new VarCharVector("vector", this.allocator);
             VarCharVector vector2 = new VarCharVector("vector", this.allocator);){
            vector1.allocateNew(10);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    vector1.setNull(i);
                    continue;
                }
                vector1.set(i, ("test" + i).getBytes());
            }
            vector1.setValueCount(10);
            ValueVectorDataPopulator.setVector(vector2, null, "test1", null, "test3", null, "test5", null, "test7", null, "test9");
            TestCase.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }
}

