/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.table;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.table.Row;
import org.apache.arrow.vector.table.Table;
import org.apache.arrow.vector.table.TestUtils;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TableTest {
    private final ArrowType intArrowType = new ArrowType.Int(32, true);
    private final FieldType intFieldType = new FieldType(true, this.intArrowType, null);
    private BufferAllocator allocator;

    TableTest() {
    }

    @BeforeEach
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @Test
    void of() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = Table.of((FieldVector[])vectorList.toArray(new FieldVector[2]));){
            Row c = t.immutableRow();
            Assertions.assertEquals((long)2L, (long)t.getRowCount());
            Assertions.assertEquals((int)2, (int)t.getVectorCount());
            IntVector intVector1 = (IntVector)vectorList.get(0);
            Assertions.assertEquals((Object)"intCol1", (Object)intVector1.getName());
            c.setPosition(0);
            Assertions.assertEquals((int)1, (int)c.getInt("intCol1"));
            intVector1.setSafe(0, 44);
            Assertions.assertEquals((int)44, (int)intVector1.get(0));
            Assertions.assertEquals((int)1, (int)c.getInt(0));
        }
    }

    @Test
    void constructor() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList, 2);){
            Assertions.assertEquals((long)2L, (long)t.getRowCount());
            Assertions.assertEquals((int)2, (int)t.getVectorCount());
            Row c = t.immutableRow();
            IntVector intVector1 = (IntVector)vectorList.get(0);
            c.setPosition(0);
            Assertions.assertEquals((int)1, (int)c.getInt("intCol1"));
            intVector1.setSafe(0, 44);
            Assertions.assertEquals((int)44, (int)intVector1.get(0));
            Assertions.assertEquals((int)44, (int)((IntVector)vectorList.get(0)).get(0));
            Assertions.assertEquals((int)1, (int)c.getInt("intCol1"));
        }
    }

    @Test
    void constructor2() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        HashSet<FieldVector> iterable = new HashSet<FieldVector>(vectorList);
        try (Table t = new Table(iterable);){
            Assertions.assertEquals((long)2L, (long)t.getRowCount());
            Assertions.assertEquals((int)2, (int)t.getVectorCount());
            Row c = t.immutableRow();
            IntVector intVector1 = (IntVector)vectorList.get(0);
            c.setPosition(0);
            Assertions.assertEquals((int)1, (int)c.getInt("intCol1"));
            intVector1.setSafe(0, 44);
            Assertions.assertEquals((int)44, (int)intVector1.get(0));
            Assertions.assertEquals((int)44, (int)((IntVector)vectorList.get(0)).get(0));
            Assertions.assertEquals((int)1, (int)c.getInt("intCol1"));
        }
    }

    @Test
    void copy() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertEquals((int)2, (int)t.getVectorCount());
            try (Table copy = t.copy();){
                for (FieldVector v : t.fieldVectors) {
                    FieldVector vCopy = copy.getVector(v.getName());
                    Assertions.assertNotNull((Object)vCopy);
                    Assertions.assertEquals((int)v.getValueCount(), (int)vCopy.getValueCount());
                    for (int i = 0; i < v.getValueCount(); ++i) {
                        Integer vValue = ((IntVector)v).getObject(i);
                        Integer vCopyValue = ((IntVector)vCopy).getObject(i);
                        Assertions.assertEquals((Integer)vValue, (Integer)vCopyValue);
                    }
                }
            }
        }
    }

    @Test
    void addVector() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            IntVector v3 = new IntVector("3", this.intFieldType, this.allocator);
            Table t2 = t.addVector(2, (FieldVector)v3);
            Assertions.assertEquals((int)3, (int)t2.fieldVectors.size());
            Assertions.assertTrue((boolean)t2.getVector("3").isNull(0));
            Assertions.assertTrue((boolean)t2.getVector("3").isNull(1));
            t2.close();
        }
    }

    @Test
    void removeVector() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        IntVector v2 = (IntVector)vectorList.get(1);
        int val1 = v2.get(0);
        int val2 = v2.get(1);
        try (Table t = new Table(vectorList);){
            Table t2 = t.removeVector(0);
            Assertions.assertEquals((int)1, (int)t2.fieldVectors.size());
            Assertions.assertEquals((int)val1, (int)((IntVector)t2.getVector(0)).get(0));
            Assertions.assertEquals((int)val2, (int)((IntVector)t2.getVector(0)).get(1));
        }
    }

    @Test
    void iterator1() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Iterator iterator = t.iterator();
            Assertions.assertNotNull((Object)iterator);
            Assertions.assertTrue((boolean)iterator.hasNext());
            int sum = 0;
            for (Row row : t) {
                sum += row.getInt(0);
            }
            Assertions.assertEquals((int)3, (int)sum);
        }
    }

    @Test
    void iterator2() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Iterator iterator = t.iterator();
            Assertions.assertNotNull((Object)iterator);
            Assertions.assertTrue((boolean)iterator.hasNext());
            int sum = 0;
            for (Row row : t) {
                sum += row.getInt(0);
            }
            Assertions.assertEquals((int)3, (int)sum);
        }
    }

    @Test
    void sliceToEnd() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Table slice = t.slice(1);
            Assertions.assertEquals((int)1, (int)slice.rowCount);
            Assertions.assertEquals((int)2, (int)t.rowCount);
            slice.close();
        }
    }

    @Test
    void sliceRange() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Table slice = t.slice(1, 1);
            Assertions.assertEquals((int)1, (int)slice.rowCount);
            Assertions.assertEquals((int)2, (int)t.rowCount);
            slice.close();
        }
    }

    @Test
    void constructFromVsr() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (VectorSchemaRoot vsr = new VectorSchemaRoot(vectorList);){
            Table t = new Table(vsr);
            Row c = t.immutableRow();
            Assertions.assertEquals((int)2, (int)t.rowCount);
            Assertions.assertEquals((int)0, (int)vsr.getRowCount());
            IntVector intVector1 = (IntVector)vectorList.get(0);
            c.setPosition(0);
            Assertions.assertEquals((int)1, (int)c.getInt("intCol1"));
            intVector1.setSafe(0, 44);
            Assertions.assertEquals((int)44, (int)intVector1.get(0));
            Assertions.assertEquals((int)44, (int)((IntVector)vsr.getVector(0)).get(0));
            Assertions.assertEquals((int)1, (int)c.getInt("intCol1"));
            Schema schema = t.schema;
            Field f1 = t.getField("intCol1");
            FieldVector fv1 = vectorList.get(0);
            Assertions.assertEquals((Object)f1, (Object)fv1.getField());
            Assertions.assertEquals((Object)f1, (Object)schema.findField("intCol1"));
            t.close();
        }
    }
}

