/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.table.Row;
import org.apache.arrow.vector.table.Table;
import org.apache.arrow.vector.table.TestUtils;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BaseTableTest {
    private BufferAllocator allocator;

    BaseTableTest() {
    }

    @BeforeEach
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @Test
    void getReaderByName() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertNotNull((Object)t.getReader("intCol1"));
        }
    }

    @Test
    void getReaderByIndex() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertNotNull((Object)t.getReader(0));
        }
    }

    @Test
    void getReaderByField() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertNotNull((Object)t.getReader(t.getField("intCol1")));
        }
    }

    @Test
    void getSchema() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertNotNull((Object)t.getSchema());
            Assertions.assertEquals((int)2, (int)t.getSchema().getFields().size());
        }
    }

    @Test
    void insertVector() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            ArrowType.Int intArrowType = new ArrowType.Int(32, true);
            FieldType intFieldType = new FieldType(true, (ArrowType)intArrowType, null);
            IntVector v3 = new IntVector("3", intFieldType, this.allocator);
            List revisedVectors = t.insertVector(2, (FieldVector)v3);
            Assertions.assertEquals((int)3, (int)revisedVectors.size());
            Assertions.assertEquals((Object)v3, revisedVectors.get(2));
        }
    }

    @Test
    void insertVectorFirstPosition() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            ArrowType.Int intArrowType = new ArrowType.Int(32, true);
            FieldType intFieldType = new FieldType(true, (ArrowType)intArrowType, null);
            IntVector v3 = new IntVector("3", intFieldType, this.allocator);
            List revisedVectors = t.insertVector(0, (FieldVector)v3);
            Assertions.assertEquals((int)3, (int)revisedVectors.size());
            Assertions.assertEquals((Object)v3, revisedVectors.get(0));
        }
    }

    @Test
    void extractVector() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            List revisedVectors = t.extractVector(0);
            Assertions.assertEquals((int)2, (int)t.getVectorCount());
            Assertions.assertEquals((int)1, (int)revisedVectors.size());
        }
    }

    @Test
    void close() {
        IntVector v = new IntVector("intCol", this.allocator);
        v.setSafe(0, 132);
        ArrayList<IntVector> vectors = new ArrayList<IntVector>();
        vectors.add(v);
        v.setValueCount(1);
        try (Table t = new Table(vectors);){
            t.close();
            for (FieldVector fieldVector : t.fieldVectors) {
                Assertions.assertEquals((int)0, (int)fieldVector.getValueCount());
            }
        }
    }

    @Test
    void getRowCount() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertEquals((long)2L, (long)t.getRowCount());
        }
    }

    @Test
    void toVectorSchemaRoot() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertNotNull((Object)t.getVector("intCol1"));
            Assertions.assertNotNull((Object)t.getVector("intCol2"));
            VectorSchemaRoot vsr = t.toVectorSchemaRoot();
            Assertions.assertNotNull((Object)vsr.getVector("intCol1"));
            Assertions.assertNotNull((Object)vsr.getVector("intCol2"));
            Assertions.assertEquals((Object)t.getSchema().findField("intCol1"), (Object)vsr.getSchema().findField("intCol1"));
        }
    }

    @Test
    void getVector() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertNotNull((Object)t.getVector(0));
        }
    }

    @Test
    void testGetVector() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertNotNull((Object)t.getVector("intCol1"));
            Assertions.assertThrows(IllegalArgumentException.class, () -> t.getVector("wrong name"));
        }
    }

    @Test
    void getVectorCopyByIndex() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        List<FieldVector> vectorList2 = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            for (int vIdx = 0; vIdx < vectorList.size(); ++vIdx) {
                IntVector original = (IntVector)vectorList2.get(vIdx);
                IntVector copy = (IntVector)t.getVectorCopy(vIdx);
                Assertions.assertNotNull((Object)copy);
                Assertions.assertEquals((int)2, (int)copy.getValueCount());
                Assertions.assertEquals((int)0, (int)copy.getNullCount());
                int i = 0;
                while ((long)i < t.getRowCount()) {
                    Assertions.assertEquals((Integer)original.getObject(i), (Integer)copy.getObject(i));
                    ++i;
                }
            }
            Assertions.assertThrows(IllegalArgumentException.class, () -> t.getVector("wrong name"));
        }
    }

    @Test
    void getVectorCopyByName() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        List<FieldVector> vectorList2 = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertNotNull((Object)t.getVectorCopy("intCol1"));
            for (int vIdx = 0; vIdx < vectorList.size(); ++vIdx) {
                IntVector original = (IntVector)vectorList2.get(vIdx);
                IntVector copy = (IntVector)t.getVectorCopy(original.getName());
                Assertions.assertEquals((int)2, (int)copy.getValueCount());
                Assertions.assertEquals((int)0, (int)copy.getNullCount());
                int i = 0;
                while ((long)i < t.getRowCount()) {
                    Assertions.assertEquals((Integer)original.getObject(i), (Integer)copy.getObject(i));
                    ++i;
                }
            }
            Assertions.assertThrows(IllegalArgumentException.class, () -> t.getVector("wrong name"));
        }
    }

    @Test
    void immutableCursor() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertNotNull((Object)t.immutableRow());
        }
    }

    @Test
    void contentToTsvString() {
        IntVector v = new IntVector("intCol", this.allocator);
        v.setSafe(0, 1);
        v.setSafe(1, 2);
        v.setSafe(2, 3);
        v.setValueCount(3);
        try (Table t = Table.of((FieldVector[])new FieldVector[]{v});){
            Assertions.assertEquals((int)3, (int)t.rowCount);
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (Row r : t) {
                values.add(r.getInt("intCol"));
            }
            Assertions.assertEquals((int)3, (int)values.size());
            ArrayList<Integer> intList = new ArrayList<Integer>();
            intList.add(1);
            intList.add(2);
            intList.add(3);
            Assertions.assertTrue((boolean)values.containsAll(intList));
            String printed = "intCol\n1\n2\n3\n";
            Assertions.assertEquals((Object)printed, (Object)t.contentToTSVString());
        }
    }

    @Test
    void isDeletedRow() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Assertions.assertFalse((boolean)t.isRowDeleted(0));
            Assertions.assertFalse((boolean)t.isRowDeleted(1));
        }
    }

    @Test
    void testEncode() {
        List<FieldVector> vectorList = TestUtils.intPlusVarcharColumns(this.allocator);
        VarCharVector original = (VarCharVector)vectorList.get(1);
        DictionaryProvider provider = this.getDictionary();
        try (Table t = new Table(vectorList, vectorList.get(0).getValueCount(), provider);){
            IntVector v = (IntVector)t.encode(original.getName(), 1L);
            Assertions.assertNotNull((Object)v);
            Assertions.assertEquals((int)0, (int)v.get(0));
            Assertions.assertEquals((int)1, (int)v.get(1));
        }
    }

    @Test
    void testDecode() {
        List<FieldVector> vectorList = TestUtils.intPlusVarcharColumns(this.allocator);
        VarCharVector original = (VarCharVector)vectorList.get(1);
        VarCharVector dictionaryVector = new VarCharVector("dictionary", this.allocator);
        dictionaryVector.allocateNew(2);
        dictionaryVector.set(0, "one".getBytes());
        dictionaryVector.set(1, "two".getBytes());
        dictionaryVector.setValueCount(2);
        Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
        DictionaryEncoder encoder = new DictionaryEncoder(dictionary, this.allocator);
        IntVector encoded = (IntVector)encoder.encode((ValueVector)original);
        vectorList.remove(original);
        vectorList.add((FieldVector)encoded);
        DictionaryProvider provider = this.getDictionary();
        try (Table t = new Table(vectorList, vectorList.get(0).getValueCount(), provider);){
            VarCharVector v = (VarCharVector)t.decode(encoded.getName(), 1L);
            Assertions.assertNotNull((Object)v);
            Assertions.assertEquals((Object)"one", (Object)new String(v.get(0)));
            Assertions.assertEquals((Object)"two", (Object)new String(v.get(1)));
        }
    }

    @Test
    void getProvider() {
        List<FieldVector> vectorList = TestUtils.intPlusVarcharColumns(this.allocator);
        DictionaryProvider provider = this.getDictionary();
        try (Table t = new Table(vectorList, vectorList.get(0).getValueCount(), provider);){
            Assertions.assertEquals((Object)provider, (Object)t.getDictionaryProvider());
        }
    }

    private DictionaryProvider getDictionary() {
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        DictionaryEncoding encoding = new DictionaryEncoding(1L, false, null);
        VarCharVector dictionaryVector = new VarCharVector("dictionary", this.allocator);
        dictionaryVector.allocateNew(2);
        dictionaryVector.set(0, "one".getBytes());
        dictionaryVector.set(1, "two".getBytes());
        dictionaryVector.setValueCount(2);
        Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, encoding);
        provider.put(dictionary);
        return provider;
    }
}

