/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Collections2;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.ArrowWriter;
import org.apache.arrow.vector.ipc.BaseFileTest;
import org.apache.arrow.vector.ipc.MessageSerializerTest;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowBlock;
import org.apache.arrow.vector.ipc.message.ArrowBuffer;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageMetadataResult;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestRoundTrip
extends BaseFileTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestRoundTrip.class);
    private static BufferAllocator allocator;
    private final String name;
    private final IpcOption writeOption;

    public TestRoundTrip(String name, IpcOption writeOption) {
        this.name = name;
        this.writeOption = writeOption;
    }

    @Parameterized.Parameters(name="options = {0}")
    public static Collection<Object[]> getWriteOption() {
        IpcOption legacy = new IpcOption(true, MetadataVersion.V4);
        IpcOption version4 = new IpcOption(false, MetadataVersion.V4);
        return Arrays.asList({"V4Legacy", legacy}, {"V4", version4}, {"V5", IpcOption.DEFAULT});
    }

    @BeforeClass
    public static void setUpClass() {
        allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @AfterClass
    public static void tearDownClass() {
        allocator.close();
    }

    @Test
    public void testStruct() throws Exception {
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
            this.writeData(10, parent);
            this.roundTrip(new VectorSchemaRoot(parent.getChild("root")), null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{10}, this::validateContent), this.validateStreamBatches(new int[]{10}, this::validateContent));
        }
    }

    @Test
    public void testComplex() throws Exception {
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
            this.writeComplexData(10, parent);
            this.roundTrip(new VectorSchemaRoot(parent.getChild("root")), null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{10}, this::validateComplexContent), this.validateStreamBatches(new int[]{10}, this::validateComplexContent));
        }
    }

    @Test
    public void testMultipleRecordBatches() throws Exception {
        int[] counts = new int[]{10, 5};
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
            this.writeData(counts[0], parent);
            this.roundTrip(new VectorSchemaRoot(parent.getChild("root")), null, (root, writer) -> {
                writer.start();
                parent.allocateNew();
                this.writeData(counts[0], parent);
                root.setRowCount(counts[0]);
                writer.writeBatch();
                parent.allocateNew();
                this.writeData(counts[1], parent);
                root.setRowCount(counts[1]);
                writer.writeBatch();
                writer.end();
            }, this.validateFileBatches(counts, this::validateContent), this.validateStreamBatches(counts, this::validateContent));
        }
    }

    @Test
    public void testUnionV4() throws Exception {
        Assume.assumeTrue((this.writeOption.metadataVersion == MetadataVersion.V4 ? 1 : 0) != 0);
        File temp = File.createTempFile("arrow-test-" + this.name + "-", ".arrow");
        temp.deleteOnExit();
        ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
            this.writeUnionData(10, parent);
            VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
                FileOutputStream fileStream = new FileOutputStream(temp);
                Throwable throwable = null;
                try {
                    new ArrowFileWriter(root, null, (WritableByteChannel)fileStream.getChannel(), this.writeOption);
                    new ArrowStreamWriter(root, null, Channels.newChannel(memoryStream), this.writeOption);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    TestRoundTrip.$closeResource(throwable, fileStream);
                }
            });
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Cannot write union with V4 metadata"));
            e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new ArrowStreamWriter(root, null, Channels.newChannel(memoryStream), this.writeOption));
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Cannot write union with V4 metadata"));
        }
    }

    @Test
    public void testUnionV5() throws Exception {
        Assume.assumeTrue((this.writeOption.metadataVersion == MetadataVersion.V5 ? 1 : 0) != 0);
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
            this.writeUnionData(10, parent);
            VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
            this.validateUnionData(10, root);
            this.roundTrip(root, null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{10}, this::validateUnionData), this.validateStreamBatches(new int[]{10}, this::validateUnionData));
        }
    }

    @Test
    public void testTiny() throws Exception {
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)MessageSerializerTest.testSchema(), (BufferAllocator)allocator);){
            ((FieldVector)root.getFieldVectors().get(0)).allocateNew();
            int count = 16;
            TinyIntVector vector = (TinyIntVector)root.getFieldVectors().get(0);
            for (int i = 0; i < count; ++i) {
                vector.set(i, i < 8 ? 1 : 0, (byte)(i + 1));
            }
            vector.setValueCount(count);
            root.setRowCount(count);
            this.roundTrip(root, null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{count}, this::validateTinyData), this.validateStreamBatches(new int[]{count}, this::validateTinyData));
        }
    }

    private void validateTinyData(int count, VectorSchemaRoot root) {
        Assert.assertEquals((long)count, (long)root.getRowCount());
        TinyIntVector vector = (TinyIntVector)root.getFieldVectors().get(0);
        for (int i = 0; i < count; ++i) {
            if (i < 8) {
                Assert.assertEquals((long)((byte)(i + 1)), (long)vector.get(i));
                continue;
            }
            Assert.assertTrue((boolean)vector.isNull(i));
        }
    }

    @Test
    public void testMetadata() throws Exception {
        ArrayList<Field> childFields = new ArrayList<Field>();
        childFields.add(new Field("varchar-child", new FieldType(true, (ArrowType)ArrowType.Utf8.INSTANCE, null, this.metadata(1)), null));
        childFields.add(new Field("float-child", new FieldType(true, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null, this.metadata(2)), null));
        childFields.add(new Field("int-child", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null, this.metadata(3)), null));
        childFields.add(new Field("list-child", new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null, this.metadata(4)), Collections2.asImmutableList((Object[])new Field[]{new Field("l1", FieldType.nullable((ArrowType)new ArrowType.Int(16, true)), null)})));
        Field field = new Field("meta", new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, this.metadata(0)), childFields);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("s1", "v1");
        metadata.put("s2", "v2");
        Schema originalSchema = new Schema((Iterable)Collections2.asImmutableList((Object[])new Field[]{field}), metadata);
        Assert.assertEquals(metadata, (Object)originalSchema.getCustomMetadata());
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             StructVector vector = (StructVector)field.createVector(originalVectorAllocator);){
            vector.allocateNewSafe();
            vector.setValueCount(0);
            List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{vector});
            VectorSchemaRoot root = new VectorSchemaRoot(originalSchema, vectors, 0);
            BiConsumer<Integer, VectorSchemaRoot> validate = (count, readRoot) -> {
                Schema schema = readRoot.getSchema();
                Assert.assertEquals((Object)originalSchema, (Object)schema);
                Assert.assertEquals((Object)originalSchema.getCustomMetadata(), (Object)schema.getCustomMetadata());
                Field top = (Field)schema.getFields().get(0);
                Assert.assertEquals(this.metadata(0), (Object)top.getMetadata());
                for (int i = 0; i < 4; ++i) {
                    Assert.assertEquals(this.metadata(i + 1), (Object)((Field)top.getChildren().get(i)).getMetadata());
                }
            };
            this.roundTrip(root, null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{0}, validate), this.validateStreamBatches(new int[]{0}, validate));
        }
    }

    private Map<String, String> metadata(int i) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k_" + i, "v_" + i);
        map.put("k2_" + i, "v2_" + i);
        return Collections.unmodifiableMap(map);
    }

    @Test
    public void testFlatDictionary() throws Exception {
        AtomicInteger numDictionaryBlocksWritten = new AtomicInteger();
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             VectorSchemaRoot root = this.writeFlatDictionaryData(originalVectorAllocator, provider);){
            this.roundTrip(root, (DictionaryProvider)provider, (ignored, writer) -> {
                writer.start();
                writer.writeBatch();
                writer.end();
                if (writer instanceof ArrowFileWriter) {
                    numDictionaryBlocksWritten.set(((ArrowFileWriter)writer).getDictionaryBlocks().size());
                }
            }, fileReader -> {
                VectorSchemaRoot readRoot = fileReader.getVectorSchemaRoot();
                Schema schema = readRoot.getSchema();
                LOGGER.debug("reading schema: " + schema);
                Assert.assertTrue((boolean)fileReader.loadNextBatch());
                this.validateFlatDictionary(readRoot, (DictionaryProvider)fileReader);
                Assert.assertEquals((long)numDictionaryBlocksWritten.get(), (long)fileReader.getDictionaryBlocks().size());
            }, streamReader -> {
                VectorSchemaRoot readRoot = streamReader.getVectorSchemaRoot();
                Schema schema = readRoot.getSchema();
                LOGGER.debug("reading schema: " + schema);
                Assert.assertTrue((boolean)streamReader.loadNextBatch());
                this.validateFlatDictionary(readRoot, (DictionaryProvider)streamReader);
            });
            Iterator iterator = provider.getDictionaryIds().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                provider.lookup(id).getVector().close();
            }
        }
    }

    @Test
    public void testNestedDictionary() throws Exception {
        AtomicInteger numDictionaryBlocksWritten = new AtomicInteger();
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             VectorSchemaRoot root = this.writeNestedDictionaryData(originalVectorAllocator, provider);){
            CheckedConsumer<ArrowReader> validateDictionary = streamReader -> {
                VectorSchemaRoot readRoot = streamReader.getVectorSchemaRoot();
                Schema schema = readRoot.getSchema();
                LOGGER.debug("reading schema: " + schema);
                Assert.assertTrue((boolean)streamReader.loadNextBatch());
                this.validateNestedDictionary(readRoot, (DictionaryProvider)streamReader);
            };
            this.roundTrip(root, (DictionaryProvider)provider, (ignored, writer) -> {
                writer.start();
                writer.writeBatch();
                writer.end();
                if (writer instanceof ArrowFileWriter) {
                    numDictionaryBlocksWritten.set(((ArrowFileWriter)writer).getDictionaryBlocks().size());
                }
            }, validateDictionary, validateDictionary);
            Iterator iterator = provider.getDictionaryIds().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                provider.lookup(id).getVector().close();
            }
        }
    }

    @Test
    public void testFixedSizeBinary() throws Exception {
        int count = 10;
        int typeWidth = 11;
        byte[][] byteValues = new byte[10][11];
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 11; ++j) {
                byteValues[i][j] = (byte)i;
            }
        }
        BiConsumer<Integer, VectorSchemaRoot> validator = (expectedCount, root) -> {
            for (int i = 0; i < expectedCount; ++i) {
                Assert.assertArrayEquals((byte[])byteValues[i], (byte[])((byte[])root.getVector("fixed-binary").getObject(i)));
            }
        };
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
            FixedSizeBinaryVector fixedSizeBinaryVector = (FixedSizeBinaryVector)parent.addOrGet("fixed-binary", FieldType.nullable((ArrowType)new ArrowType.FixedSizeBinary(11)), FixedSizeBinaryVector.class);
            parent.allocateNew();
            for (int i = 0; i < 10; ++i) {
                fixedSizeBinaryVector.set(i, byteValues[i]);
            }
            parent.setValueCount(10);
            this.roundTrip(new VectorSchemaRoot((FieldVector)parent), null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{10}, validator), this.validateStreamBatches(new int[]{10}, validator));
        }
    }

    @Test
    public void testFixedSizeList() throws Exception {
        BiConsumer<Integer, VectorSchemaRoot> validator = (expectedCount, root) -> {
            for (int i = 0; i < expectedCount; ++i) {
                Assert.assertEquals((Object)Collections2.asImmutableList((Object[])new Float[]{Float.valueOf((float)i + 0.1f), Float.valueOf((float)i + 10.1f)}), (Object)root.getVector("float-pairs").getObject(i));
                Assert.assertEquals((Object)i, (Object)root.getVector("ints").getObject(i));
            }
        };
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
            FixedSizeListVector tuples = (FixedSizeListVector)parent.addOrGet("float-pairs", FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2)), FixedSizeListVector.class);
            Float4Vector floats = (Float4Vector)tuples.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.FLOAT4.getType())).getVector();
            IntVector ints = (IntVector)parent.addOrGet("ints", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            parent.allocateNew();
            for (int i = 0; i < 10; ++i) {
                tuples.setNotNull(i);
                floats.set(i * 2, (float)i + 0.1f);
                floats.set(i * 2 + 1, (float)i + 10.1f);
                ints.set(i, i);
            }
            parent.setValueCount(10);
            this.roundTrip(new VectorSchemaRoot((FieldVector)parent), null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{10}, validator), this.validateStreamBatches(new int[]{10}, validator));
        }
    }

    @Test
    public void testVarBinary() throws Exception {
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
            this.writeVarBinaryData(10, parent);
            VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
            this.validateVarBinary(10, root);
            this.roundTrip(root, null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{10}, this::validateVarBinary), this.validateStreamBatches(new int[]{10}, this::validateVarBinary));
        }
    }

    @Test
    public void testReadWriteMultipleBatches() throws IOException {
        File file = new File("target/mytest_nulls_multibatch.arrow");
        int numBlocksWritten = 0;
        try (IntVector vector = new IntVector("foo", allocator);){
            Schema schema = new Schema(Collections.singletonList(vector.getField()));
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                 VectorSchemaRoot root = new VectorSchemaRoot(schema, Collections.singletonList(vector), vector.getValueCount());
                 ArrowFileWriter writer = new ArrowFileWriter(root, null, (WritableByteChannel)fileOutputStream.getChannel(), this.writeOption);){
                this.writeBatchData((ArrowWriter)writer, vector, root);
                numBlocksWritten = writer.getRecordBlocks().size();
            }
        }
        var4_4 = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);
             ArrowFileReader reader = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), allocator);){
            IntVector vector = (IntVector)reader.getVectorSchemaRoot().getFieldVectors().get(0);
            this.validateBatchData((ArrowReader)reader, vector);
            Assert.assertEquals((long)numBlocksWritten, (long)reader.getRecordBlocks().size());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testMap() throws Exception {
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             VectorSchemaRoot root = this.writeMapData(originalVectorAllocator);){
            this.roundTrip(root, null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{root.getRowCount()}, (count, readRoot) -> this.validateMapData((VectorSchemaRoot)readRoot)), this.validateStreamBatches(new int[]{root.getRowCount()}, (count, readRoot) -> this.validateMapData((VectorSchemaRoot)readRoot)));
        }
    }

    @Test
    public void testListAsMap() throws Exception {
        try (BufferAllocator originalVectorAllocator = allocator.newChildAllocator("original vectors", 0L, allocator.getLimit());
             VectorSchemaRoot root = this.writeListAsMapData(originalVectorAllocator);){
            this.roundTrip(root, null, TestRoundTrip::writeSingleBatch, this.validateFileBatches(new int[]{root.getRowCount()}, (count, readRoot) -> this.validateListAsMapData((VectorSchemaRoot)readRoot)), this.validateStreamBatches(new int[]{root.getRowCount()}, (count, readRoot) -> this.validateListAsMapData((VectorSchemaRoot)readRoot)));
        }
    }

    private static void writeSingleBatch(VectorSchemaRoot root, ArrowWriter writer) throws IOException {
        writer.start();
        writer.writeBatch();
        writer.end();
    }

    private CheckedConsumer<ArrowFileReader> validateFileBatches(int[] counts, BiConsumer<Integer, VectorSchemaRoot> validator) {
        return arrowReader -> {
            VectorSchemaRoot root = arrowReader.getVectorSchemaRoot();
            VectorUnloader unloader = new VectorUnloader(root);
            Schema schema = root.getSchema();
            LOGGER.debug("reading schema: " + schema);
            int i = 0;
            List recordBatches = arrowReader.getRecordBlocks();
            Assert.assertEquals((long)counts.length, (long)recordBatches.size());
            long previousOffset = 0L;
            for (ArrowBlock rbBlock : recordBatches) {
                Assert.assertTrue((String)(rbBlock.getOffset() + " > " + previousOffset), (rbBlock.getOffset() > previousOffset ? 1 : 0) != 0);
                previousOffset = rbBlock.getOffset();
                arrowReader.loadRecordBatch(rbBlock);
                Assert.assertEquals((String)("RB #" + i), (long)counts[i], (long)root.getRowCount());
                validator.accept(counts[i], root);
                ArrowRecordBatch batch = unloader.getRecordBatch();
                Throwable throwable = null;
                try {
                    List buffersLayout = batch.getBuffersLayout();
                    for (ArrowBuffer arrowBuffer : buffersLayout) {
                        Assert.assertEquals((long)0L, (long)(arrowBuffer.getOffset() % 8L));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (batch != null) {
                        TestRoundTrip.$closeResource(throwable, (AutoCloseable)batch);
                    }
                }
                ++i;
            }
        };
    }

    private CheckedConsumer<ArrowStreamReader> validateStreamBatches(int[] counts, BiConsumer<Integer, VectorSchemaRoot> validator) {
        return arrowReader -> {
            VectorSchemaRoot root = arrowReader.getVectorSchemaRoot();
            VectorUnloader unloader = new VectorUnloader(root);
            Schema schema = root.getSchema();
            LOGGER.debug("reading schema: " + schema);
            int i = 0;
            for (int n = 0; n < counts.length; ++n) {
                Assert.assertTrue((boolean)arrowReader.loadNextBatch());
                Assert.assertEquals((String)("RB #" + i), (long)counts[i], (long)root.getRowCount());
                validator.accept(counts[i], root);
                ArrowRecordBatch batch = unloader.getRecordBatch();
                Throwable throwable = null;
                try {
                    List buffersLayout = batch.getBuffersLayout();
                    for (ArrowBuffer arrowBuffer : buffersLayout) {
                        Assert.assertEquals((long)0L, (long)(arrowBuffer.getOffset() % 8L));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (batch != null) {
                        TestRoundTrip.$closeResource(throwable, (AutoCloseable)batch);
                    }
                }
                ++i;
            }
            Assert.assertFalse((boolean)arrowReader.loadNextBatch());
        };
    }

    private void roundTrip(VectorSchemaRoot root, DictionaryProvider provider, CheckedBiConsumer<VectorSchemaRoot, ArrowWriter> writer, CheckedConsumer<? super ArrowFileReader> fileValidator, CheckedConsumer<? super ArrowStreamReader> streamValidator) throws Exception {
        File temp = File.createTempFile("arrow-test-" + this.name + "-", ".arrow");
        temp.deleteOnExit();
        ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("foo", "bar");
        try (FileOutputStream fileStream = new FileOutputStream(temp);
             ArrowFileWriter fileWriter = new ArrowFileWriter(root, provider, (WritableByteChannel)fileStream.getChannel(), metadata, this.writeOption);
             ArrowStreamWriter streamWriter = new ArrowStreamWriter(root, provider, Channels.newChannel(memoryStream), this.writeOption);){
            writer.accept(root, (ArrowWriter)fileWriter);
            writer.accept(root, (ArrowWriter)streamWriter);
        }
        MessageMetadataResult metadataResult = MessageSerializer.readMessage((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(memoryStream.toByteArray()))));
        Assert.assertNotNull((Object)metadataResult);
        Assert.assertEquals((long)this.writeOption.metadataVersion.toFlatbufID(), (long)metadataResult.getMessage().version());
        try (BufferAllocator readerAllocator = allocator.newChildAllocator("reader", 0L, allocator.getLimit());
             FileInputStream fileInputStream = new FileInputStream(temp);
             ByteArrayInputStream inputStream = new ByteArrayInputStream(memoryStream.toByteArray());
             ArrowFileReader fileReader = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), readerAllocator);
             ArrowStreamReader streamReader = new ArrowStreamReader((InputStream)inputStream, readerAllocator);){
            fileValidator.accept((ArrowFileReader)fileReader);
            streamValidator.accept((ArrowStreamReader)streamReader);
            Assert.assertEquals((Object)this.writeOption.metadataVersion, (Object)fileReader.getFooter().getMetadataVersion());
            Assert.assertEquals(metadata, (Object)fileReader.getMetaData());
        }
    }

    @FunctionalInterface
    static interface CheckedBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Exception;
    }

    @FunctionalInterface
    static interface CheckedConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

