/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.impl;

import java.math.BigDecimal;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.compare.VectorEqualsVisitor;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.ComplexCopier;
import org.apache.arrow.vector.complex.impl.NullableStructReaderImpl;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.UnionFixedSizeListReader;
import org.apache.arrow.vector.complex.impl.UnionFixedSizeListWriter;
import org.apache.arrow.vector.complex.impl.UnionListReader;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.impl.UnionMapReader;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.FieldWriter;
import org.apache.arrow.vector.holders.DecimalHolder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.DecimalUtility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestComplexCopier {
    private BufferAllocator allocator;
    private static final int COUNT = 100;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testCopyFixedSizeListVector() {
        try (FixedSizeListVector from = FixedSizeListVector.empty((String)"v", (int)3, (BufferAllocator)this.allocator);
             FixedSizeListVector to = FixedSizeListVector.empty((String)"v", (int)3, (BufferAllocator)this.allocator);){
            from.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            to.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            UnionFixedSizeListWriter writer = from.getWriter();
            for (int i = 0; i < 100; ++i) {
                writer.startList();
                writer.integer().writeInt(i);
                writer.integer().writeInt(i * 2);
                writer.integer().writeInt(i * 3);
                writer.endList();
            }
            from.setValueCount(100);
            to.setValueCount(100);
            UnionFixedSizeListReader in = from.getReader();
            UnionFixedSizeListWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testInvalidCopyFixedSizeListVector() {
        try (FixedSizeListVector from = FixedSizeListVector.empty((String)"v", (int)3, (BufferAllocator)this.allocator);
             FixedSizeListVector to = FixedSizeListVector.empty((String)"v", (int)2, (BufferAllocator)this.allocator);){
            from.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            to.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            UnionFixedSizeListWriter writer = from.getWriter();
            for (int i = 0; i < 100; ++i) {
                writer.startList();
                writer.integer().writeInt(i);
                writer.integer().writeInt(i * 2);
                writer.integer().writeInt(i * 3);
                writer.endList();
            }
            from.setValueCount(100);
            to.setValueCount(100);
            UnionFixedSizeListReader in = from.getReader();
            UnionFixedSizeListWriter out = to.getWriter();
            IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> TestComplexCopier.lambda$testInvalidCopyFixedSizeListVector$0((FieldReader)in, (FieldWriter)out));
            Assert.assertTrue((boolean)e.getMessage().contains("greater than listSize"));
        }
    }

    @Test
    public void testCopyMapVector() {
        try (MapVector from = MapVector.empty((String)"v", (BufferAllocator)this.allocator, (boolean)false);
             MapVector to = MapVector.empty((String)"v", (BufferAllocator)this.allocator, (boolean)false);){
            from.allocateNew();
            UnionMapWriter mapWriter = from.getWriter();
            for (int i = 0; i < 100; ++i) {
                mapWriter.setPosition(i);
                mapWriter.startMap();
                mapWriter.startEntry();
                mapWriter.key().integer().writeInt(i);
                mapWriter.value().integer().writeInt(i);
                mapWriter.endEntry();
                mapWriter.startEntry();
                mapWriter.key().decimal().writeDecimal(BigDecimal.valueOf(i * 2));
                mapWriter.value().decimal().writeDecimal(BigDecimal.valueOf(i * 2));
                mapWriter.endEntry();
                mapWriter.endMap();
            }
            from.setValueCount(100);
            UnionMapReader in = from.getReader();
            UnionMapWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyListVector() {
        try (ListVector from = ListVector.empty((String)"v", (BufferAllocator)this.allocator);
             ListVector to = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            UnionListWriter listWriter = from.getWriter();
            listWriter.allocate();
            for (int i = 0; i < 100; ++i) {
                listWriter.setPosition(i);
                listWriter.startList();
                listWriter.integer().writeInt(i);
                listWriter.integer().writeInt(i * 2);
                listWriter.list().startList();
                listWriter.list().bigInt().writeBigInt((long)i);
                listWriter.list().bigInt().writeBigInt((long)(i * 2));
                listWriter.list().bigInt().writeBigInt((long)(i * 3));
                listWriter.list().endList();
                listWriter.list().startList();
                listWriter.list().decimal().writeDecimal(BigDecimal.valueOf(i * 4));
                listWriter.list().decimal().writeDecimal(BigDecimal.valueOf(i * 5));
                listWriter.list().endList();
                listWriter.endList();
            }
            from.setValueCount(100);
            UnionListReader in = from.getReader();
            UnionListWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyListVectorToANonEmptyList() {
        try (ListVector from = ListVector.empty((String)"v", (BufferAllocator)this.allocator);
             ListVector to = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            int i;
            UnionListWriter listWriter = from.getWriter();
            listWriter.allocate();
            for (int i2 = 0; i2 < 100; ++i2) {
                listWriter.setPosition(i2);
                listWriter.startList();
                listWriter.integer().writeInt(i2);
                listWriter.integer().writeInt(i2 * 2);
                listWriter.endList();
            }
            from.setValueCount(100);
            UnionListReader in = from.getReader();
            UnionListWriter out = to.getWriter();
            for (i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
            for (i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
            for (i = 0; i < 100; ++i) {
                to.copyFromSafe(i, i, (ValueVector)from);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyListVectorWithNulls() {
        try (ListVector from = ListVector.empty((String)"v", (BufferAllocator)this.allocator);
             ListVector to = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            UnionListWriter listWriter = from.getWriter();
            listWriter.allocate();
            for (int i = 0; i < 100; ++i) {
                listWriter.setPosition(i);
                if (i % 2 == 0) {
                    listWriter.writeNull();
                    continue;
                }
                listWriter.startList();
                listWriter.integer().writeNull();
                listWriter.integer().writeInt(i);
                listWriter.integer().writeNull();
                listWriter.integer().writeInt(i * 2);
                listWriter.integer().writeNull();
                listWriter.endList();
            }
            from.setValueCount(100);
            UnionListReader in = from.getReader();
            UnionListWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyListOfListVectorWithNulls() {
        try (ListVector from = ListVector.empty((String)"v", (BufferAllocator)this.allocator);
             ListVector to = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            UnionListWriter listWriter = from.getWriter();
            listWriter.allocate();
            for (int i = 0; i < 100; ++i) {
                listWriter.setPosition(i);
                if (i % 2 == 0) {
                    listWriter.writeNull();
                    continue;
                }
                listWriter.startList();
                listWriter.list().writeNull();
                listWriter.list().startList();
                listWriter.list().bigInt().writeBigInt(50L);
                listWriter.list().bigInt().writeBigInt(100L);
                listWriter.list().bigInt().writeNull();
                listWriter.list().bigInt().writeBigInt(200L);
                listWriter.list().endList();
                listWriter.list().writeNull();
                listWriter.list().startList();
                listWriter.list().bigInt().writeNull();
                listWriter.list().bigInt().writeBigInt(50L);
                listWriter.list().bigInt().writeNull();
                listWriter.list().bigInt().writeBigInt(100L);
                listWriter.list().bigInt().writeNull();
                listWriter.list().bigInt().writeBigInt(200L);
                listWriter.list().bigInt().writeNull();
                listWriter.list().endList();
                listWriter.list().writeNull();
                listWriter.endList();
            }
            from.setValueCount(100);
            UnionListReader in = from.getReader();
            UnionListWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyListOStructVectorWithNulls() {
        try (ListVector from = ListVector.empty((String)"v", (BufferAllocator)this.allocator);
             ListVector to = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            UnionListWriter listWriter = from.getWriter();
            listWriter.allocate();
            for (int i = 0; i < 100; ++i) {
                listWriter.setPosition(i);
                if (i % 2 == 0) {
                    listWriter.writeNull();
                    continue;
                }
                listWriter.startList();
                listWriter.struct().writeNull();
                listWriter.struct().start();
                listWriter.struct().integer("f1").writeInt(1);
                listWriter.struct().integer("f2").writeInt(2);
                listWriter.struct().integer("f3").writeNull();
                listWriter.struct().end();
                listWriter.struct().writeNull();
                listWriter.struct().start();
                listWriter.struct().integer("f1").writeInt(1);
                listWriter.struct().integer("f2").writeInt(2);
                listWriter.struct().integer("f3").writeNull();
                listWriter.struct().end();
                listWriter.struct().writeNull();
                listWriter.endList();
            }
            from.setValueCount(100);
            UnionListReader in = from.getReader();
            UnionListWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyListOfListOfStructVectorWithNulls() {
        try (ListVector from = ListVector.empty((String)"v", (BufferAllocator)this.allocator);
             ListVector to = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            UnionListWriter listWriter = from.getWriter();
            listWriter.allocate();
            for (int i = 0; i < 100; ++i) {
                listWriter.setPosition(i);
                if (i % 2 == 0) {
                    listWriter.writeNull();
                    continue;
                }
                listWriter.startList();
                listWriter.list().writeNull();
                listWriter.list().startList();
                listWriter.list().struct().start();
                listWriter.list().struct().bigInt("f1").writeBigInt(50L);
                listWriter.list().struct().end();
                listWriter.list().struct().writeNull();
                listWriter.list().struct().start();
                listWriter.list().struct().bigInt("f1").writeBigInt(100L);
                listWriter.list().struct().end();
                listWriter.list().struct().writeNull();
                listWriter.list().struct().start();
                listWriter.list().struct().bigInt("f1").writeBigInt(200L);
                listWriter.list().struct().end();
                listWriter.list().endList();
                listWriter.list().writeNull();
                listWriter.list().startList();
                listWriter.list().struct().writeNull();
                listWriter.list().struct().start();
                listWriter.list().struct().bigInt("f1").writeBigInt(50L);
                listWriter.list().struct().end();
                listWriter.list().struct().writeNull();
                listWriter.list().struct().start();
                listWriter.list().struct().bigInt("f1").writeBigInt(100L);
                listWriter.list().struct().end();
                listWriter.list().struct().writeNull();
                listWriter.list().struct().start();
                listWriter.list().struct().bigInt("f1").writeBigInt(200L);
                listWriter.list().struct().end();
                listWriter.list().struct().writeNull();
                listWriter.list().endList();
                listWriter.list().writeNull();
                listWriter.endList();
            }
            from.setValueCount(100);
            UnionListReader in = from.getReader();
            UnionListWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testMapWithListValue() throws Exception {
        try (MapVector from = MapVector.empty((String)"map", (BufferAllocator)this.allocator, (boolean)false);
             MapVector to = MapVector.empty((String)"map", (BufferAllocator)this.allocator, (boolean)false);){
            UnionMapWriter mapWriter = from.getWriter();
            mapWriter.allocate();
            for (int i = 0; i < 100; ++i) {
                mapWriter.setPosition(i);
                if (i % 2 == 0) {
                    mapWriter.writeNull();
                    continue;
                }
                mapWriter.startMap();
                mapWriter.startEntry();
                mapWriter.key().bigInt().writeNull();
                mapWriter.value().list().writeNull();
                mapWriter.endEntry();
                mapWriter.startEntry();
                mapWriter.key().bigInt().writeNull();
                BaseWriter.ListWriter valueWriter = mapWriter.value().list();
                valueWriter.startList();
                valueWriter.endList();
                mapWriter.endEntry();
                mapWriter.startEntry();
                mapWriter.key().bigInt().writeBigInt(1L);
                valueWriter = mapWriter.value().list();
                valueWriter.startList();
                valueWriter.bigInt().writeNull();
                valueWriter.bigInt().writeBigInt(50L);
                valueWriter.bigInt().writeNull();
                valueWriter.bigInt().writeBigInt(100L);
                valueWriter.bigInt().writeNull();
                valueWriter.bigInt().writeBigInt(200L);
                valueWriter.bigInt().writeNull();
                valueWriter.endList();
                mapWriter.endEntry();
                mapWriter.writeNull();
                mapWriter.startEntry();
                mapWriter.key().bigInt().writeBigInt(2L);
                valueWriter = mapWriter.value().list();
                valueWriter.startList();
                valueWriter.bigInt().writeNull();
                valueWriter.bigInt().writeBigInt(75L);
                valueWriter.bigInt().writeNull();
                valueWriter.bigInt().writeBigInt(125L);
                valueWriter.bigInt().writeNull();
                valueWriter.bigInt().writeBigInt(150L);
                valueWriter.bigInt().writeNull();
                valueWriter.bigInt().writeBigInt(175L);
                valueWriter.bigInt().writeNull();
                valueWriter.endList();
                mapWriter.endEntry();
                mapWriter.endMap();
            }
            mapWriter.setValueCount(100);
            UnionMapReader in = from.getReader();
            UnionMapWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyFixedSizedListOfDecimalsVector() {
        try (FixedSizeListVector from = FixedSizeListVector.empty((String)"v", (int)4, (BufferAllocator)this.allocator);
             FixedSizeListVector to = FixedSizeListVector.empty((String)"v", (int)4, (BufferAllocator)this.allocator);){
            from.addOrGetVector(FieldType.nullable((ArrowType)new ArrowType.Decimal(3, 0, 128)));
            to.addOrGetVector(FieldType.nullable((ArrowType)new ArrowType.Decimal(3, 0, 128)));
            DecimalHolder holder = new DecimalHolder();
            holder.buffer = this.allocator.buffer(16L);
            ArrowType.Decimal arrowType = new ArrowType.Decimal(3, 0, 128);
            UnionFixedSizeListWriter writer = from.getWriter();
            for (int i = 0; i < 100; ++i) {
                writer.startList();
                writer.decimal().writeDecimal(BigDecimal.valueOf(i));
                DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)new BigDecimal(i * 2), (ArrowBuf)holder.buffer, (int)0, (int)16);
                holder.start = 0L;
                holder.scale = 0;
                holder.precision = 3;
                writer.decimal().write(holder);
                DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)new BigDecimal(i * 3), (ArrowBuf)holder.buffer, (int)0, (int)16);
                writer.decimal().writeDecimal(0L, holder.buffer, (ArrowType)arrowType);
                writer.decimal().writeBigEndianBytesToDecimal(BigDecimal.valueOf(i * 4).unscaledValue().toByteArray(), (ArrowType)arrowType);
                writer.endList();
            }
            from.setValueCount(100);
            to.setValueCount(100);
            UnionFixedSizeListReader in = from.getReader();
            UnionFixedSizeListWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
            holder.buffer.close();
        }
    }

    @Test
    public void testCopyUnionListWithDecimal() {
        try (ListVector from = ListVector.empty((String)"v", (BufferAllocator)this.allocator);
             ListVector to = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            UnionListWriter listWriter = from.getWriter();
            listWriter.allocate();
            for (int i = 0; i < 100; ++i) {
                listWriter.setPosition(i);
                listWriter.startList();
                listWriter.decimal().writeDecimal(BigDecimal.valueOf(i * 2));
                listWriter.integer().writeInt(i);
                listWriter.decimal().writeBigEndianBytesToDecimal(BigDecimal.valueOf(i * 3).unscaledValue().toByteArray(), (ArrowType)new ArrowType.Decimal(3, 0, 128));
                listWriter.endList();
            }
            from.setValueCount(100);
            UnionListReader in = from.getReader();
            UnionListWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyStructVector() {
        try (StructVector from = StructVector.empty((String)"v", (BufferAllocator)this.allocator);
             StructVector to = StructVector.empty((String)"v", (BufferAllocator)this.allocator);){
            from.allocateNewSafe();
            NullableStructWriter structWriter = from.getWriter();
            for (int i = 0; i < 100; ++i) {
                structWriter.setPosition(i);
                structWriter.start();
                structWriter.integer("int").writeInt(i);
                structWriter.decimal("dec", 0, 38).writeDecimal(BigDecimal.valueOf(i * 2));
                BaseWriter.StructWriter innerStructWriter = structWriter.struct("struc");
                innerStructWriter.start();
                innerStructWriter.integer("innerint").writeInt(i * 3);
                innerStructWriter.decimal("innerdec", 0, 38).writeDecimal(BigDecimal.valueOf(i * 4));
                innerStructWriter.decimal("innerdec", 0, 38).writeBigEndianBytesToDecimal(BigDecimal.valueOf(i * 4).unscaledValue().toByteArray(), (ArrowType)new ArrowType.Decimal(3, 0, 128));
                innerStructWriter.end();
                structWriter.end();
            }
            from.setValueCount(100);
            NullableStructReaderImpl in = from.getReader();
            NullableStructWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyDecimalVectorWrongScale() {
        try (FixedSizeListVector from = FixedSizeListVector.empty((String)"v", (int)3, (BufferAllocator)this.allocator);
             FixedSizeListVector to = FixedSizeListVector.empty((String)"v", (int)3, (BufferAllocator)this.allocator);){
            from.addOrGetVector(FieldType.nullable((ArrowType)new ArrowType.Decimal(3, 2, 128)));
            to.addOrGetVector(FieldType.nullable((ArrowType)new ArrowType.Decimal(3, 1, 128)));
            UnionFixedSizeListWriter writer = from.getWriter();
            for (int i = 0; i < 100; ++i) {
                writer.startList();
                writer.decimal().writeDecimal(BigDecimal.valueOf(1.23));
                writer.decimal().writeDecimal(BigDecimal.valueOf(2.45));
                writer.endList();
            }
            from.setValueCount(100);
            to.setValueCount(100);
            UnionFixedSizeListReader in = from.getReader();
            UnionFixedSizeListWriter out = to.getWriter();
            UnsupportedOperationException e = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> TestComplexCopier.lambda$testCopyDecimalVectorWrongScale$1((FieldReader)in, (FieldWriter)out));
            Assert.assertTrue((boolean)e.getMessage().contains("BigDecimal scale must equal that in the Arrow vector: 2 != 1"));
        }
    }

    @Test
    public void testCopyStructVectorWithNulls() {
        try (StructVector from = StructVector.empty((String)"v", (BufferAllocator)this.allocator);
             StructVector to = StructVector.empty((String)"v", (BufferAllocator)this.allocator);){
            NullableStructWriter writer = from.getWriter();
            for (int i = 0; i < 100; ++i) {
                writer.setPosition(i);
                writer.start();
                writer.integer("int").writeInt(i);
                if (i % 3 == 0) {
                    writer.float4("child").writeFloat4(12.3f);
                } else if (i % 3 == 1) {
                    writer.integer("child").writeInt(123);
                } else {
                    writer.integer("child").writeNull();
                }
                writer.end();
            }
            from.setValueCount(100);
            NullableStructReaderImpl in = from.getReader();
            NullableStructWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyStructOfMap() {
        try (StructVector from = StructVector.empty((String)"v", (BufferAllocator)this.allocator);
             StructVector to = StructVector.empty((String)"v", (BufferAllocator)this.allocator);){
            from.allocateNew();
            NullableStructWriter structWriter = from.getWriter();
            for (int i = 0; i < 100; ++i) {
                structWriter.setPosition(i);
                structWriter.start();
                BaseWriter.MapWriter innerMapWriter = structWriter.map("f1");
                innerMapWriter.startMap();
                innerMapWriter.startEntry();
                innerMapWriter.key().integer().writeInt(i);
                innerMapWriter.value().integer().writeInt(i);
                innerMapWriter.endEntry();
                innerMapWriter.endMap();
                structWriter.end();
            }
            from.setValueCount(100);
            NullableStructReaderImpl in = from.getReader();
            NullableStructWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    @Test
    public void testCopyMapVectorWithMapValue() {
        try (MapVector from = MapVector.empty((String)"v", (BufferAllocator)this.allocator, (boolean)false);
             MapVector to = MapVector.empty((String)"v", (BufferAllocator)this.allocator, (boolean)false);){
            from.allocateNew();
            UnionMapWriter mapWriter = from.getWriter();
            for (int i = 0; i < 100; ++i) {
                mapWriter.setPosition(i);
                mapWriter.startMap();
                mapWriter.startEntry();
                mapWriter.key().integer().writeInt(i);
                BaseWriter.MapWriter innerMapWriter = mapWriter.value().map(false);
                innerMapWriter.startMap();
                innerMapWriter.startEntry();
                innerMapWriter.key().integer().writeInt(i);
                innerMapWriter.value().integer().writeInt(i);
                innerMapWriter.endEntry();
                innerMapWriter.endMap();
                mapWriter.endEntry();
                mapWriter.endMap();
            }
            from.setValueCount(100);
            UnionMapReader in = from.getReader();
            UnionMapWriter out = to.getWriter();
            for (int i = 0; i < 100; ++i) {
                in.setPosition(i);
                out.setPosition(i);
                ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
            }
            to.setValueCount(100);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)from, (ValueVector)to));
        }
    }

    private static /* synthetic */ void lambda$testCopyDecimalVectorWrongScale$1(FieldReader in, FieldWriter out) throws Throwable {
        ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
    }

    private static /* synthetic */ void lambda$testInvalidCopyFixedSizeListVector$0(FieldReader in, FieldWriter out) throws Throwable {
        ComplexCopier.copy((FieldReader)in, (FieldWriter)out);
    }
}

