/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.complex.NonNullableStructVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorUnloadLoad {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testNullCodec() {
        Schema schema = new Schema(Collections.emptyList());
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            root.setRowCount(1);
            VectorUnloader unloader = new VectorUnloader(root, true, null, true);
            unloader.getRecordBatch().close();
        }
    }

    @Test
    public void testUnloadLoad() throws IOException {
        int count = 10000;
        try (BufferAllocator originalVectorsAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)originalVectorsAllocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            IntWriter intWriter = rootWriter.integer("int");
            BigIntWriter bigIntWriter = rootWriter.bigInt("bigInt");
            for (int i = 0; i < count; ++i) {
                intWriter.setPosition(i);
                intWriter.writeInt(i);
                bigIntWriter.setPosition(i);
                bigIntWriter.writeBigInt((long)i);
            }
            writer.setValueCount(count);
            FieldVector root = parent.getChild("root");
            Schema schema = new Schema((Iterable)root.getField().getChildren());
            VectorUnloader vectorUnloader = TestVectorUnloadLoad.newVectorUnloader(root);
            try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                 BufferAllocator finalVectorsAllocator = this.allocator.newChildAllocator("final vectors", 0L, Integer.MAX_VALUE);
                 VectorSchemaRoot newRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
                VectorLoader vectorLoader = new VectorLoader(newRoot);
                vectorLoader.load(recordBatch);
                FieldReader intReader = newRoot.getVector("int").getReader();
                FieldReader bigIntReader = newRoot.getVector("bigInt").getReader();
                for (int i = 0; i < count; ++i) {
                    intReader.setPosition(i);
                    Assert.assertEquals((long)i, (long)intReader.readInteger().intValue());
                    bigIntReader.setPosition(i);
                    Assert.assertEquals((long)i, (long)bigIntReader.readLong());
                }
            }
        }
    }

    @Test
    public void testUnloadLoadAddPadding() throws IOException {
        int count = 10000;
        try (BufferAllocator originalVectorsAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)originalVectorsAllocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            BaseWriter.ListWriter list = rootWriter.list("list");
            IntWriter intWriter = list.integer();
            for (int i = 0; i < count; ++i) {
                list.setPosition(i);
                list.startList();
                for (int j = 0; j < i % 4 + 1; ++j) {
                    intWriter.writeInt(i);
                }
                list.endList();
            }
            writer.setValueCount(count);
            FieldVector root = parent.getChild("root");
            Schema schema = new Schema((Iterable)root.getField().getChildren());
            VectorUnloader vectorUnloader = TestVectorUnloadLoad.newVectorUnloader(root);
            try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                 BufferAllocator finalVectorsAllocator = this.allocator.newChildAllocator("final vectors", 0L, Integer.MAX_VALUE);
                 VectorSchemaRoot newRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
                Object oldBuffer2;
                List oldBuffers = recordBatch.getBuffers();
                ArrayList<ArrowBuf> newBuffers = new ArrayList<ArrowBuf>();
                for (Object oldBuffer2 : oldBuffers) {
                    long l = oldBuffer2.readableBytes();
                    if (l % 64L != 0L) {
                        l = l + 64L - l % 64L;
                    }
                    ArrowBuf newBuffer = this.allocator.buffer(l);
                    for (long i = oldBuffer2.readerIndex(); i < oldBuffer2.writerIndex(); ++i) {
                        newBuffer.setByte(i - oldBuffer2.readerIndex(), oldBuffer2.getByte(i));
                    }
                    newBuffer.readerIndex(0L);
                    newBuffer.writerIndex(l);
                    newBuffers.add(newBuffer);
                }
                oldBuffer2 = null;
                try (ArrowRecordBatch newBatch = new ArrowRecordBatch(recordBatch.getLength(), recordBatch.getNodes(), newBuffers);){
                    VectorLoader vectorLoader = new VectorLoader(newRoot);
                    vectorLoader.load(newBatch);
                    FieldReader reader = newRoot.getVector("list").getReader();
                    for (int i = 0; i < count; ++i) {
                        reader.setPosition(i);
                        ArrayList<Integer> expected = new ArrayList<Integer>();
                        for (int j = 0; j < i % 4 + 1; ++j) {
                            expected.add(i);
                        }
                        Assert.assertEquals(expected, (Object)reader.readObject());
                    }
                }
                catch (Throwable throwable) {
                    oldBuffer2 = throwable;
                    throw throwable;
                }
                for (ArrowBuf newBuf : newBuffers) {
                    newBuf.getReferenceManager().release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadValidityBuffer() throws IOException {
        Schema schema = new Schema(Arrays.asList(new Field("intDefined", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), Collections.emptyList()), new Field("intNull", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), Collections.emptyList())));
        int count = 10;
        ArrowBuf[] values = new ArrowBuf[4];
        for (int i = 0; i < 4; i += 2) {
            ArrowBuf buf1 = this.allocator.buffer((long)BitVectorHelper.getValidityBufferSize((int)count));
            ArrowBuf buf2 = this.allocator.buffer((long)(count * 4));
            buf1.setZero(0L, buf1.capacity());
            buf2.setZero(0L, buf2.capacity());
            values[i] = buf1;
            values[i + 1] = buf2;
            for (int j = 0; j < count; ++j) {
                if (i == 2) {
                    BitVectorHelper.unsetBit((ArrowBuf)buf1, (int)j);
                } else {
                    BitVectorHelper.setBit((ArrowBuf)buf1, (long)j);
                }
                buf2.setInt((long)(j * 4), j);
            }
            buf1.writerIndex((long)((int)Math.ceil(count / 8)));
            buf2.writerIndex((long)(count * 4));
        }
        try (ArrowRecordBatch recordBatch = new ArrowRecordBatch(count, Arrays.asList(new ArrowFieldNode((long)count, 0L), new ArrowFieldNode((long)count, (long)count)), Arrays.asList(values[0], values[1], values[2], values[3]));
             BufferAllocator finalVectorsAllocator = this.allocator.newChildAllocator("final vectors", 0L, Integer.MAX_VALUE);
             VectorSchemaRoot newRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
            VectorLoader vectorLoader = new VectorLoader(newRoot);
            vectorLoader.load(recordBatch);
            IntVector intDefinedVector = (IntVector)newRoot.getVector("intDefined");
            IntVector intNullVector = (IntVector)newRoot.getVector("intNull");
            for (int i = 0; i < count; ++i) {
                Assert.assertFalse((String)("#" + i), (boolean)intDefinedVector.isNull(i));
                Assert.assertEquals((String)("#" + i), (long)i, (long)intDefinedVector.get(i));
                Assert.assertTrue((String)("#" + i), (boolean)intNullVector.isNull(i));
            }
            intDefinedVector.setSafe(count + 10, 1234);
            Assert.assertTrue((boolean)intDefinedVector.isNull(count + 1));
            intDefinedVector.setSafe(count + 1, 789);
            Assert.assertFalse((boolean)intDefinedVector.isNull(count + 1));
            Assert.assertEquals((long)789L, (long)intDefinedVector.get(count + 1));
            Assert.assertTrue((boolean)intDefinedVector.isNull(count));
            Assert.assertTrue((boolean)intDefinedVector.isNull(count + 2));
            Assert.assertTrue((boolean)intDefinedVector.isNull(count + 3));
            Assert.assertTrue((boolean)intDefinedVector.isNull(count + 4));
            Assert.assertTrue((boolean)intDefinedVector.isNull(count + 5));
            Assert.assertTrue((boolean)intDefinedVector.isNull(count + 6));
            Assert.assertTrue((boolean)intDefinedVector.isNull(count + 7));
            Assert.assertTrue((boolean)intDefinedVector.isNull(count + 8));
            Assert.assertTrue((boolean)intDefinedVector.isNull(count + 9));
            Assert.assertFalse((boolean)intDefinedVector.isNull(count + 10));
            Assert.assertEquals((long)1234L, (long)intDefinedVector.get(count + 10));
        }
        finally {
            for (ArrowBuf arrowBuf : values) {
                arrowBuf.getReferenceManager().release();
            }
        }
    }

    @Test
    public void testUnloadLoadDuplicates() throws IOException {
        int count = 10;
        Schema schema = new Schema(Arrays.asList(new Field("duplicate", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), Collections.emptyList()), new Field("duplicate", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), Collections.emptyList())));
        try (BufferAllocator originalVectorsAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            ArrayList<FieldVector> sources = new ArrayList<FieldVector>();
            for (Field field : schema.getFields()) {
                FieldVector vector = field.createVector(originalVectorsAllocator);
                vector.allocateNew();
                sources.add(vector);
                IntVector intVector = (IntVector)vector;
                for (int i = 0; i < count; ++i) {
                    intVector.set(i, i);
                }
                intVector.setValueCount(count);
            }
            try (VectorSchemaRoot root = new VectorSchemaRoot(schema.getFields(), sources, count);){
                VectorUnloader vectorUnloader = new VectorUnloader(root);
                try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                     BufferAllocator finalVectorsAllocator = this.allocator.newChildAllocator("final vectors", 0L, Integer.MAX_VALUE);
                     VectorSchemaRoot newRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
                    VectorLoader vectorLoader = new VectorLoader(newRoot);
                    vectorLoader.load(recordBatch);
                    List targets = newRoot.getFieldVectors();
                    Assert.assertEquals((long)sources.size(), (long)targets.size());
                    for (int k = 0; k < sources.size(); ++k) {
                        IntVector src = (IntVector)sources.get(k);
                        IntVector tgt = (IntVector)targets.get(k);
                        Assert.assertEquals((long)src.getValueCount(), (long)tgt.getValueCount());
                        for (int i = 0; i < count; ++i) {
                            Assert.assertEquals((long)src.get(i), (long)tgt.get(i));
                        }
                    }
                }
            }
        }
    }

    public static VectorUnloader newVectorUnloader(FieldVector root) {
        Schema schema = new Schema((Iterable)root.getField().getChildren());
        int valueCount = root.getValueCount();
        List fields = root.getChildrenFromFields();
        VectorSchemaRoot vsr = new VectorSchemaRoot(schema.getFields(), fields, valueCount);
        return new VectorUnloader(vsr);
    }
}

