/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestVectorSchemaRoot {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() {
        this.allocator.close();
    }

    @Test
    public void testResetRowCount() {
        int size = 20;
        try (BitVector vec1 = new BitVector("bit", this.allocator);
             IntVector vec2 = new IntVector("int", this.allocator);){
            int i;
            VectorSchemaRoot vsr = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{vec1, vec2});
            vsr.allocateNew();
            Assert.assertEquals((long)vsr.getRowCount(), (long)0L);
            for (i = 0; i < 20; ++i) {
                vec1.setSafe(i, i % 2);
                vec2.setSafe(i, i);
            }
            vsr.setRowCount(20);
            this.checkCount(vec1, vec2, vsr, 20);
            vsr.allocateNew();
            this.checkCount(vec1, vec2, vsr, 0);
            for (i = 0; i < 20; ++i) {
                vec1.setSafe(i, i % 2);
                vec2.setSafe(i, i);
            }
            vsr.setRowCount(20);
            this.checkCount(vec1, vec2, vsr, 20);
            vsr.clear();
            this.checkCount(vec1, vec2, vsr, 0);
        }
    }

    private void checkCount(BitVector vec1, IntVector vec2, VectorSchemaRoot vsr, int count) {
        Assert.assertEquals((long)vec1.getValueCount(), (long)count);
        Assert.assertEquals((long)vec2.getValueCount(), (long)count);
        Assert.assertEquals((long)vsr.getRowCount(), (long)count);
    }

    private VectorSchemaRoot createBatch() {
        FieldType varCharType = new FieldType(true, (ArrowType)new ArrowType.Utf8(), null);
        FieldType listType = new FieldType(true, (ArrowType)new ArrowType.List(), null);
        ArrayList<Field> schemaFields = new ArrayList<Field>();
        Field childField = new Field("varCharCol", varCharType, null);
        ArrayList<Field> childFields = new ArrayList<Field>();
        childFields.add(childField);
        schemaFields.add(new Field("listCol", listType, childFields));
        Schema schema = new Schema(schemaFields);
        VectorSchemaRoot schemaRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
        ListVector vector = (ListVector)schemaRoot.getVector("listCol");
        vector.allocateNew();
        UnionListWriter writer = vector.getWriter();
        writer.setPosition(0);
        writer.startList();
        writer.list().startList();
        writer.list().bigInt().writeBigInt(0L);
        writer.list().bigInt().writeBigInt(1L);
        writer.list().endList();
        writer.list().startList();
        writer.list().float8().writeFloat8(3.0);
        writer.list().float8().writeFloat8(7.0);
        writer.list().endList();
        writer.endList();
        writer.setPosition(1);
        writer.startList();
        writer.list().startList();
        writer.list().integer().writeInt(3);
        writer.list().integer().writeInt(2);
        writer.list().endList();
        writer.endList();
        vector.setValueCount(2);
        return schemaRoot;
    }

    @Test
    public void testAddVector() {
        try (IntVector intVector1 = new IntVector("intVector1", this.allocator);
             IntVector intVector2 = new IntVector("intVector2", this.allocator);
             IntVector intVector3 = new IntVector("intVector3", this.allocator);){
            VectorSchemaRoot original = new VectorSchemaRoot(Arrays.asList(intVector1, intVector2));
            Assert.assertEquals((long)2L, (long)original.getFieldVectors().size());
            VectorSchemaRoot newRecordBatch = original.addVector(1, (FieldVector)intVector3);
            Assert.assertEquals((long)3L, (long)newRecordBatch.getFieldVectors().size());
            Assert.assertEquals((Object)intVector3, newRecordBatch.getFieldVectors().get(1));
            original.close();
            newRecordBatch.close();
        }
    }

    @Test
    public void testRemoveVector() {
        try (IntVector intVector1 = new IntVector("intVector1", this.allocator);
             IntVector intVector2 = new IntVector("intVector2", this.allocator);
             IntVector intVector3 = new IntVector("intVector3", this.allocator);){
            VectorSchemaRoot original = new VectorSchemaRoot(Arrays.asList(intVector1, intVector2, intVector3));
            Assert.assertEquals((long)3L, (long)original.getFieldVectors().size());
            VectorSchemaRoot newRecordBatch = original.removeVector(0);
            Assert.assertEquals((long)2L, (long)newRecordBatch.getFieldVectors().size());
            Assert.assertEquals((Object)intVector2, newRecordBatch.getFieldVectors().get(0));
            Assert.assertEquals((Object)intVector3, newRecordBatch.getFieldVectors().get(1));
            original.close();
            newRecordBatch.close();
        }
    }

    @Test
    public void testSlice() {
        try (IntVector intVector = new IntVector("intVector", this.allocator);
             Float4Vector float4Vector = new Float4Vector("float4Vector", this.allocator);){
            int numRows = 10;
            intVector.setValueCount(10);
            float4Vector.setValueCount(10);
            for (int i = 0; i < 10; ++i) {
                intVector.setSafe(i, i);
                float4Vector.setSafe(i, (float)i + 0.1f);
            }
            VectorSchemaRoot original = new VectorSchemaRoot(Arrays.asList(intVector, float4Vector));
            for (int sliceIndex = 0; sliceIndex < 10; ++sliceIndex) {
                int sliceLength = 0;
                while (sliceIndex + sliceLength <= 10) {
                    try (VectorSchemaRoot slice = original.slice(sliceIndex, sliceLength);){
                        Assert.assertEquals((long)sliceLength, (long)slice.getRowCount());
                        IntVector childIntVector = (IntVector)slice.getFieldVectors().get(0);
                        Float4Vector childFloatVector = (Float4Vector)slice.getFieldVectors().get(1);
                        for (int i = 0; i < sliceLength; ++i) {
                            int originalIndex = i + sliceIndex;
                            Assert.assertEquals((long)originalIndex, (long)childIntVector.get(i));
                            Assert.assertEquals((float)((float)originalIndex + 0.1f), (float)childFloatVector.get(i), (float)0.0f);
                        }
                    }
                    ++sliceLength;
                }
            }
            original.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSliceWithInvalidParam() {
        try (IntVector intVector = new IntVector("intVector", this.allocator);
             Float4Vector float4Vector = new Float4Vector("float4Vector", this.allocator);){
            intVector.setValueCount(10);
            float4Vector.setValueCount(10);
            for (int i = 0; i < 10; ++i) {
                intVector.setSafe(i, i);
                float4Vector.setSafe(i, (float)i + 0.1f);
            }
            VectorSchemaRoot original = new VectorSchemaRoot(Arrays.asList(intVector, float4Vector));
            original.slice(0, 20);
        }
    }

    @Test
    public void testEquals() {
        try (IntVector intVector1 = new IntVector("intVector1", this.allocator);
             IntVector intVector2 = new IntVector("intVector2", this.allocator);
             IntVector intVector3 = new IntVector("intVector3", this.allocator);){
            intVector1.setValueCount(5);
            for (int i = 0; i < 5; ++i) {
                intVector1.set(i, i);
            }
            VectorSchemaRoot root1 = new VectorSchemaRoot(Arrays.asList(intVector1, intVector2, intVector3));
            VectorSchemaRoot root2 = new VectorSchemaRoot(Arrays.asList(intVector1, intVector2));
            VectorSchemaRoot root3 = new VectorSchemaRoot(Arrays.asList(intVector1, intVector2, intVector3));
            Assertions.assertFalse((boolean)root1.equals(root2));
            TestCase.assertTrue((boolean)root1.equals(root3));
            root1.close();
            root2.close();
            root3.close();
        }
    }

    @Test
    public void testApproxEquals() {
        try (Float4Vector float4Vector1 = new Float4Vector("floatVector", this.allocator);
             Float4Vector float4Vector2 = new Float4Vector("floatVector", this.allocator);
             Float4Vector float4Vector3 = new Float4Vector("floatVector", this.allocator);){
            float4Vector1.setValueCount(5);
            float4Vector2.setValueCount(5);
            float4Vector3.setValueCount(5);
            float epsilon = 1.0E-6f;
            for (int i = 0; i < 5; ++i) {
                float4Vector1.set(i, (float)i);
                float4Vector2.set(i, (float)i + 2.0E-6f);
                float4Vector3.set(i, (float)i + 5.0E-7f);
            }
            VectorSchemaRoot root1 = new VectorSchemaRoot(Arrays.asList(float4Vector1));
            VectorSchemaRoot root2 = new VectorSchemaRoot(Arrays.asList(float4Vector2));
            VectorSchemaRoot root3 = new VectorSchemaRoot(Arrays.asList(float4Vector3));
            Assertions.assertFalse((boolean)root1.approxEquals(root2));
            TestCase.assertTrue((boolean)root1.approxEquals(root3));
            root1.close();
            root2.close();
            root3.close();
        }
    }

    @Test
    public void testSchemaSync() {
        try (VectorSchemaRoot schemaRoot = this.createBatch();){
            Schema newSchema = new Schema((Iterable)schemaRoot.getFieldVectors().stream().map(vec -> vec.getField()).collect(Collectors.toList()));
            Assert.assertNotEquals((Object)newSchema, (Object)schemaRoot.getSchema());
            TestCase.assertTrue((boolean)schemaRoot.syncSchema());
            Assert.assertEquals((Object)newSchema, (Object)schemaRoot.getSchema());
            Assertions.assertFalse((boolean)schemaRoot.syncSchema());
        }
    }
}

