/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVarCharListVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testVarCharListWithNulls() {
        byte[] bytes = "a".getBytes();
        try (ListVector vector = new ListVector("VarList", this.allocator, FieldType.nullable((ArrowType)Types.MinorType.VARCHAR.getType()), null);
             ArrowBuf tempBuf = this.allocator.buffer((long)bytes.length);){
            UnionListWriter writer = vector.getWriter();
            writer.allocate();
            writer.setPosition(0);
            writer.startList();
            tempBuf.setBytes(0L, bytes);
            writer.writeVarChar(0, bytes.length, tempBuf);
            writer.endList();
            writer.setPosition(2);
            writer.startList();
            bytes = "b".getBytes();
            tempBuf.setBytes(0L, bytes);
            writer.writeVarChar(0, bytes.length, tempBuf);
            writer.endList();
            writer.setValueCount(2);
            Assert.assertTrue((vector.getValueCount() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((vector.getDataVector().getValueCount() == 2 ? 1 : 0) != 0);
        }
    }
}

