/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionLargeListReader;
import org.apache.arrow.vector.complex.impl.UnionLargeListWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLargeListVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testCopyFrom() throws Exception {
        try (LargeListVector inVector = LargeListVector.empty((String)"input", (BufferAllocator)this.allocator);
             LargeListVector outVector = LargeListVector.empty((String)"output", (BufferAllocator)this.allocator);){
            UnionLargeListWriter writer = inVector.getWriter();
            writer.allocate();
            writer.setPosition(0);
            writer.startList();
            writer.bigInt().writeBigInt(1L);
            writer.bigInt().writeBigInt(2L);
            writer.bigInt().writeBigInt(3L);
            writer.endList();
            writer.setPosition(2);
            writer.startList();
            writer.endList();
            writer.setValueCount(3);
            outVector.allocateNew();
            for (int i = 0; i < 3; ++i) {
                outVector.copyFrom(i, i, (ValueVector)inVector);
            }
            outVector.setValueCount(3);
            UnionLargeListReader reader = outVector.getReader();
            Assert.assertTrue((String)"shouldn't be null", (boolean)reader.isSet());
            reader.setPosition(1);
            Assert.assertFalse((String)"should be null", (boolean)reader.isSet());
            reader.setPosition(2);
            Assert.assertTrue((String)"shouldn't be null", (boolean)reader.isSet());
            List result = outVector.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)3L, (long)resultSet.size());
            Assert.assertEquals((Object)new Long(1L), resultSet.get(0));
            Assert.assertEquals((Object)new Long(2L), resultSet.get(1));
            Assert.assertEquals((Object)new Long(3L), resultSet.get(2));
            result = outVector.getObject(1);
            Assert.assertNull((Object)result);
            result = outVector.getObject(2);
            resultSet = (ArrayList)result;
            Assert.assertEquals((long)0L, (long)resultSet.size());
            Assert.assertEquals((double)1.0, (double)inVector.getDensity(), (double)0.0);
        }
    }

    @Test
    public void testSetLastSetUsage() throws Exception {
        try (LargeListVector listVector = LargeListVector.empty((String)"input", (BufferAllocator)this.allocator);){
            Types.MinorType type = Types.MinorType.BIGINT;
            listVector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
            listVector.allocateNew();
            ArrowBuf validityBuffer = listVector.getValidityBuffer();
            ArrowBuf offsetBuffer = listVector.getOffsetBuffer();
            BigIntVector dataVector = (BigIntVector)listVector.getDataVector();
            Assert.assertEquals((long)-1L, (long)listVector.getLastSet());
            int index = 0;
            int offset = 0;
            BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)index);
            dataVector.setSafe(0, 1, 10L);
            dataVector.setSafe(1, 1, 11L);
            dataVector.setSafe(2, 1, 12L);
            offsetBuffer.setLong((long)((index + 1) * 8), 3L);
            BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)(++index));
            dataVector.setSafe(3, 1, 13L);
            dataVector.setSafe(4, 1, 14L);
            offsetBuffer.setLong((long)((index + 1) * 8), 5L);
            BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)(++index));
            dataVector.setSafe(5, 1, 15L);
            dataVector.setSafe(6, 1, 16L);
            dataVector.setSafe(7, 1, 17L);
            offsetBuffer.setLong((long)((index + 1) * 8), 8L);
            Assert.assertEquals((long)-1L, (long)listVector.getLastSet());
            listVector.setLastSet(2);
            listVector.setValueCount(10);
            Assert.assertEquals((double)0.8, (double)listVector.getDensity(), (double)0.0);
            index = 0;
            offset = (int)offsetBuffer.getLong((long)(index * 8));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(offset));
            Long actual = dataVector.getObject(offset);
            Assert.assertEquals((Object)new Long(10L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(11L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(12L), (Object)actual);
            offset = (int)offsetBuffer.getLong((long)(++index * 8));
            Assert.assertEquals((Object)Integer.toString(3), (Object)Integer.toString(offset));
            actual = dataVector.getObject(offset);
            Assert.assertEquals((Object)new Long(13L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(14L), (Object)actual);
            offset = (int)offsetBuffer.getLong((long)(++index * 8));
            Assert.assertEquals((Object)Integer.toString(5), (Object)Integer.toString(offset));
            actual = dataVector.getObject(offset);
            Assert.assertEquals((Object)new Long(15L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(16L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(17L), (Object)actual);
            offset = (int)offsetBuffer.getLong((long)(++index * 8));
            Assert.assertEquals((Object)Integer.toString(8), (Object)Integer.toString(offset));
            actual = dataVector.getObject(offset);
            Assert.assertNull((Object)actual);
        }
    }

    @Test
    public void testSplitAndTransfer() throws Exception {
        try (LargeListVector listVector = LargeListVector.empty((String)"sourceVector", (BufferAllocator)this.allocator);){
            Types.MinorType type = Types.MinorType.BIGINT;
            listVector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
            UnionLargeListWriter listWriter = listVector.getWriter();
            listWriter.allocate();
            listWriter.setPosition(0);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(10L);
            listWriter.bigInt().writeBigInt(11L);
            listWriter.bigInt().writeBigInt(12L);
            listWriter.endList();
            listWriter.setPosition(1);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(13L);
            listWriter.bigInt().writeBigInt(14L);
            listWriter.endList();
            listWriter.setPosition(2);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(15L);
            listWriter.bigInt().writeBigInt(16L);
            listWriter.bigInt().writeBigInt(17L);
            listWriter.bigInt().writeBigInt(18L);
            listWriter.endList();
            listWriter.setPosition(3);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(19L);
            listWriter.endList();
            listWriter.setPosition(4);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(20L);
            listWriter.bigInt().writeBigInt(21L);
            listWriter.bigInt().writeBigInt(22L);
            listWriter.bigInt().writeBigInt(23L);
            listWriter.endList();
            listVector.setValueCount(5);
            Assert.assertEquals((long)4L, (long)listVector.getLastSet());
            ArrowBuf offsetBuffer = listVector.getOffsetBuffer();
            BigIntVector dataVector = (BigIntVector)listVector.getDataVector();
            int index = 0;
            int offset = 0;
            Long actual = null;
            Assert.assertFalse((boolean)listVector.isNull(index));
            offset = (int)offsetBuffer.getLong((long)(index * 8));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(offset));
            actual = dataVector.getObject(offset);
            Assert.assertEquals((Object)new Long(10L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(11L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(12L), (Object)actual);
            Assert.assertFalse((boolean)listVector.isNull(++index));
            offset = (int)offsetBuffer.getLong((long)(index * 8));
            Assert.assertEquals((Object)Integer.toString(3), (Object)Integer.toString(offset));
            actual = dataVector.getObject(offset);
            Assert.assertEquals((Object)new Long(13L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(14L), (Object)actual);
            Assert.assertFalse((boolean)listVector.isNull(++index));
            offset = (int)offsetBuffer.getLong((long)(index * 8));
            Assert.assertEquals((Object)Integer.toString(5), (Object)Integer.toString(offset));
            actual = dataVector.getObject(offset);
            Assert.assertEquals((Object)new Long(15L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(16L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(17L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(18L), (Object)actual);
            Assert.assertFalse((boolean)listVector.isNull(++index));
            offset = (int)offsetBuffer.getLong((long)(index * 8));
            Assert.assertEquals((Object)Integer.toString(9), (Object)Integer.toString(offset));
            actual = dataVector.getObject(offset);
            Assert.assertEquals((Object)new Long(19L), (Object)actual);
            Assert.assertFalse((boolean)listVector.isNull(++index));
            offset = (int)offsetBuffer.getLong((long)(index * 8));
            Assert.assertEquals((Object)Integer.toString(10), (Object)Integer.toString(offset));
            actual = dataVector.getObject(offset);
            Assert.assertEquals((Object)new Long(20L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(21L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(22L), (Object)actual);
            actual = dataVector.getObject(++offset);
            Assert.assertEquals((Object)new Long(23L), (Object)actual);
            Assert.assertTrue((boolean)listVector.isNull(++index));
            offset = (int)offsetBuffer.getLong((long)(index * 8));
            Assert.assertEquals((Object)Integer.toString(14), (Object)Integer.toString(offset));
            try (LargeListVector toVector = LargeListVector.empty((String)"toVector", (BufferAllocator)this.allocator);){
                int[][] transferLengths;
                TransferPair transferPair = listVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{0, 2}, {3, 1}, {4, 1}}) {
                    int start = transferLength[0];
                    int splitLength = transferLength[1];
                    int dataLength1 = 0;
                    int dataLength2 = 0;
                    int offset1 = 0;
                    int offset2 = 0;
                    transferPair.splitAndTransfer(start, splitLength);
                    ArrowBuf toOffsetBuffer = toVector.getOffsetBuffer();
                    BigIntVector dataVector1 = (BigIntVector)toVector.getDataVector();
                    for (int i = 0; i < splitLength; ++i) {
                        dataLength1 = (int)offsetBuffer.getLong((long)((start + i + 1) * 8)) - (int)offsetBuffer.getLong((long)((start + i) * 8));
                        dataLength2 = (int)toOffsetBuffer.getLong((long)((i + 1) * 8)) - (int)toOffsetBuffer.getLong((long)(i * 8));
                        Assert.assertEquals((String)("Different data lengths at index: " + i + " and start: " + start), (long)dataLength1, (long)dataLength2);
                        offset1 = (int)offsetBuffer.getLong((long)((start + i) * 8));
                        offset2 = (int)toOffsetBuffer.getLong((long)(i * 8));
                        for (int j = 0; j < dataLength1; ++j) {
                            Assert.assertEquals((String)("Different data at indexes: " + offset1 + " and " + offset2), (Object)dataVector.getObject(offset1), (Object)dataVector1.getObject(offset2));
                            ++offset1;
                            ++offset2;
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testNestedLargeListVector() throws Exception {
        try (LargeListVector listVector = LargeListVector.empty((String)"sourceVector", (BufferAllocator)this.allocator);){
            UnionLargeListWriter listWriter = listVector.getWriter();
            listWriter.allocate();
            listWriter.setPosition(0);
            listWriter.startList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(50L);
            listWriter.list().bigInt().writeBigInt(100L);
            listWriter.list().bigInt().writeBigInt(200L);
            listWriter.list().endList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(75L);
            listWriter.list().bigInt().writeBigInt(125L);
            listWriter.list().bigInt().writeBigInt(150L);
            listWriter.list().bigInt().writeBigInt(175L);
            listWriter.list().endList();
            listWriter.endList();
            listWriter.setPosition(1);
            listWriter.startList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(10L);
            listWriter.list().endList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(15L);
            listWriter.list().bigInt().writeBigInt(20L);
            listWriter.list().endList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(25L);
            listWriter.list().bigInt().writeBigInt(30L);
            listWriter.list().bigInt().writeBigInt(35L);
            listWriter.list().endList();
            listWriter.endList();
            Assert.assertEquals((long)1L, (long)listVector.getLastSet());
            listVector.setValueCount(2);
            Assert.assertEquals((long)2L, (long)listVector.getValueCount());
            List result = listVector.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)2L, (long)resultSet.size());
            Assert.assertEquals((long)3L, (long)((ArrayList)resultSet.get(0)).size());
            Assert.assertEquals((long)4L, (long)((ArrayList)resultSet.get(1)).size());
            ArrayList list = (ArrayList)resultSet.get(0);
            Assert.assertEquals((Object)new Long(50L), list.get(0));
            Assert.assertEquals((Object)new Long(100L), list.get(1));
            Assert.assertEquals((Object)new Long(200L), list.get(2));
            list = (ArrayList)resultSet.get(1);
            Assert.assertEquals((Object)new Long(75L), list.get(0));
            Assert.assertEquals((Object)new Long(125L), list.get(1));
            Assert.assertEquals((Object)new Long(150L), list.get(2));
            Assert.assertEquals((Object)new Long(175L), list.get(3));
            result = listVector.getObject(1);
            resultSet = (ArrayList)result;
            Assert.assertEquals((long)3L, (long)resultSet.size());
            Assert.assertEquals((long)1L, (long)((ArrayList)resultSet.get(0)).size());
            Assert.assertEquals((long)2L, (long)((ArrayList)resultSet.get(1)).size());
            Assert.assertEquals((long)3L, (long)((ArrayList)resultSet.get(2)).size());
            list = (ArrayList)resultSet.get(0);
            Assert.assertEquals((Object)new Long(10L), list.get(0));
            list = (ArrayList)resultSet.get(1);
            Assert.assertEquals((Object)new Long(15L), list.get(0));
            Assert.assertEquals((Object)new Long(20L), list.get(1));
            list = (ArrayList)resultSet.get(2);
            Assert.assertEquals((Object)new Long(25L), list.get(0));
            Assert.assertEquals((Object)new Long(30L), list.get(1));
            Assert.assertEquals((Object)new Long(35L), list.get(2));
            Assert.assertFalse((boolean)listVector.isNull(0));
            Assert.assertFalse((boolean)listVector.isNull(1));
            ArrowBuf offsetBuffer = listVector.getOffsetBuffer();
            Assert.assertEquals((long)0L, (long)offsetBuffer.getLong(0L));
            Assert.assertEquals((long)2L, (long)offsetBuffer.getLong(8L));
            Assert.assertEquals((long)5L, (long)offsetBuffer.getLong(16L));
        }
    }

    @Test
    public void testNestedLargeListVector1() throws Exception {
        try (LargeListVector listVector = LargeListVector.empty((String)"sourceVector", (BufferAllocator)this.allocator);){
            Types.MinorType listType = Types.MinorType.LIST;
            Types.MinorType scalarType = Types.MinorType.BIGINT;
            listVector.addOrGetVector(FieldType.nullable((ArrowType)listType.getType()));
            ListVector innerList1 = (ListVector)listVector.getDataVector();
            innerList1.addOrGetVector(FieldType.nullable((ArrowType)listType.getType()));
            ListVector innerList2 = (ListVector)innerList1.getDataVector();
            innerList2.addOrGetVector(FieldType.nullable((ArrowType)listType.getType()));
            ListVector innerList3 = (ListVector)innerList2.getDataVector();
            innerList3.addOrGetVector(FieldType.nullable((ArrowType)listType.getType()));
            ListVector innerList4 = (ListVector)innerList3.getDataVector();
            innerList4.addOrGetVector(FieldType.nullable((ArrowType)listType.getType()));
            ListVector innerList5 = (ListVector)innerList4.getDataVector();
            innerList5.addOrGetVector(FieldType.nullable((ArrowType)listType.getType()));
            ListVector innerList6 = (ListVector)innerList5.getDataVector();
            innerList6.addOrGetVector(FieldType.nullable((ArrowType)scalarType.getType()));
            listVector.setInitialCapacity(128);
        }
    }

    @Test
    public void testNestedLargeListVector2() throws Exception {
        try (LargeListVector listVector = LargeListVector.empty((String)"sourceVector", (BufferAllocator)this.allocator);){
            listVector.setInitialCapacity(1);
            UnionLargeListWriter listWriter = listVector.getWriter();
            listWriter.allocate();
            listWriter.setPosition(0);
            listWriter.startList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(50L);
            listWriter.list().bigInt().writeBigInt(100L);
            listWriter.list().bigInt().writeBigInt(200L);
            listWriter.list().endList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(75L);
            listWriter.list().bigInt().writeBigInt(125L);
            listWriter.list().endList();
            listWriter.endList();
            listWriter.setPosition(1);
            listWriter.startList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(15L);
            listWriter.list().bigInt().writeBigInt(20L);
            listWriter.list().endList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(25L);
            listWriter.list().bigInt().writeBigInt(30L);
            listWriter.list().bigInt().writeBigInt(35L);
            listWriter.list().endList();
            listWriter.endList();
            Assert.assertEquals((long)1L, (long)listVector.getLastSet());
            listVector.setValueCount(2);
            Assert.assertEquals((long)2L, (long)listVector.getValueCount());
            List result = listVector.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)2L, (long)resultSet.size());
            Assert.assertEquals((long)3L, (long)((ArrayList)resultSet.get(0)).size());
            Assert.assertEquals((long)2L, (long)((ArrayList)resultSet.get(1)).size());
            ArrayList list = (ArrayList)resultSet.get(0);
            Assert.assertEquals((Object)new Long(50L), list.get(0));
            Assert.assertEquals((Object)new Long(100L), list.get(1));
            Assert.assertEquals((Object)new Long(200L), list.get(2));
            list = (ArrayList)resultSet.get(1);
            Assert.assertEquals((Object)new Long(75L), list.get(0));
            Assert.assertEquals((Object)new Long(125L), list.get(1));
            result = listVector.getObject(1);
            resultSet = (ArrayList)result;
            Assert.assertEquals((long)2L, (long)resultSet.size());
            Assert.assertEquals((long)2L, (long)((ArrayList)resultSet.get(0)).size());
            Assert.assertEquals((long)3L, (long)((ArrayList)resultSet.get(1)).size());
            list = (ArrayList)resultSet.get(0);
            Assert.assertEquals((Object)new Long(15L), list.get(0));
            Assert.assertEquals((Object)new Long(20L), list.get(1));
            list = (ArrayList)resultSet.get(1);
            Assert.assertEquals((Object)new Long(25L), list.get(0));
            Assert.assertEquals((Object)new Long(30L), list.get(1));
            Assert.assertEquals((Object)new Long(35L), list.get(2));
            Assert.assertFalse((boolean)listVector.isNull(0));
            Assert.assertFalse((boolean)listVector.isNull(1));
            ArrowBuf offsetBuffer = listVector.getOffsetBuffer();
            Assert.assertEquals((long)0L, (long)offsetBuffer.getLong(0L));
            Assert.assertEquals((long)2L, (long)offsetBuffer.getLong(8L));
            Assert.assertEquals((long)4L, (long)offsetBuffer.getLong(16L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBufferAddress() throws Exception {
        try (LargeListVector listVector = LargeListVector.empty((String)"vector", (BufferAllocator)this.allocator);){
            UnionLargeListWriter listWriter = listVector.getWriter();
            boolean error = false;
            listWriter.allocate();
            listWriter.setPosition(0);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(50L);
            listWriter.bigInt().writeBigInt(100L);
            listWriter.bigInt().writeBigInt(200L);
            listWriter.endList();
            listWriter.setPosition(1);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(250L);
            listWriter.bigInt().writeBigInt(300L);
            listWriter.endList();
            listVector.setValueCount(2);
            List result = listVector.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)3L, (long)resultSet.size());
            Assert.assertEquals((Object)new Long(50L), resultSet.get(0));
            Assert.assertEquals((Object)new Long(100L), resultSet.get(1));
            Assert.assertEquals((Object)new Long(200L), resultSet.get(2));
            result = listVector.getObject(1);
            resultSet = (ArrayList)result;
            Assert.assertEquals((long)2L, (long)resultSet.size());
            Assert.assertEquals((Object)new Long(250L), resultSet.get(0));
            Assert.assertEquals((Object)new Long(300L), resultSet.get(1));
            List buffers = listVector.getFieldBuffers();
            long bitAddress = listVector.getValidityBufferAddress();
            long offsetAddress = listVector.getOffsetBufferAddress();
            try {
                long l = listVector.getDataBufferAddress();
            }
            catch (UnsupportedOperationException ue) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
            }
            Assert.assertEquals((long)2L, (long)buffers.size());
            Assert.assertEquals((long)bitAddress, (long)((ArrowBuf)buffers.get(0)).memoryAddress());
            Assert.assertEquals((long)offsetAddress, (long)((ArrowBuf)buffers.get(1)).memoryAddress());
            Assert.assertEquals((double)2.5, (double)listVector.getDensity(), (double)0.0);
        }
    }

    @Test
    public void testConsistentChildName() throws Exception {
        try (LargeListVector listVector = LargeListVector.empty((String)"sourceVector", (BufferAllocator)this.allocator);){
            String emptyListStr = listVector.getField().toString();
            Assert.assertTrue((boolean)emptyListStr.contains("$data$"));
            listVector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            String emptyVectorStr = listVector.getField().toString();
            Assert.assertTrue((boolean)emptyVectorStr.contains("$data$"));
        }
    }

    @Test
    public void testSetInitialCapacity() {
        try (LargeListVector vector = LargeListVector.empty((String)"", (BufferAllocator)this.allocator);){
            vector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertEquals((long)512L, (long)vector.getValueCapacity());
            Assert.assertTrue((vector.getDataVector().getValueCapacity() >= 2560 ? 1 : 0) != 0);
            vector.setInitialCapacity(512, 4.0);
            vector.allocateNew();
            Assert.assertEquals((long)512L, (long)vector.getValueCapacity());
            Assert.assertTrue((vector.getDataVector().getValueCapacity() >= 2048 ? 1 : 0) != 0);
            vector.setInitialCapacity(512, 0.1);
            vector.allocateNew();
            Assert.assertEquals((long)512L, (long)vector.getValueCapacity());
            Assert.assertTrue((vector.getDataVector().getValueCapacity() >= 51 ? 1 : 0) != 0);
            vector.setInitialCapacity(512, 0.01);
            vector.allocateNew();
            Assert.assertEquals((long)512L, (long)vector.getValueCapacity());
            Assert.assertTrue((vector.getDataVector().getValueCapacity() >= 5 ? 1 : 0) != 0);
            vector.setInitialCapacity(5, 0.1);
            vector.allocateNew();
            Assert.assertEquals((long)7L, (long)vector.getValueCapacity());
            Assert.assertTrue((vector.getDataVector().getValueCapacity() >= 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testClearAndReuse() {
        try (LargeListVector vector = LargeListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            BigIntVector bigIntVector = (BigIntVector)vector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType())).getVector();
            vector.setInitialCapacity(10);
            vector.allocateNew();
            vector.startNewValue(0L);
            bigIntVector.setSafe(0, 7L);
            vector.endValue(0, 1L);
            vector.startNewValue(1L);
            bigIntVector.setSafe(1, 8L);
            vector.endValue(1, 1L);
            vector.setValueCount(2);
            List result = vector.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((Object)new Long(7L), resultSet.get(0));
            result = vector.getObject(1);
            resultSet = (ArrayList)result;
            Assert.assertEquals((Object)new Long(8L), resultSet.get(0));
            vector.clear();
            vector.startNewValue(0L);
            bigIntVector.setSafe(0, 7L);
            vector.endValue(0, 1L);
            vector.startNewValue(1L);
            bigIntVector.setSafe(1, 8L);
            vector.endValue(1, 1L);
            vector.setValueCount(2);
            result = vector.getObject(0);
            resultSet = (ArrayList)result;
            Assert.assertEquals((Object)new Long(7L), resultSet.get(0));
            result = vector.getObject(1);
            resultSet = (ArrayList)result;
            Assert.assertEquals((Object)new Long(8L), resultSet.get(0));
        }
    }

    @Test
    public void testWriterGetField() {
        try (LargeListVector vector = LargeListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            UnionLargeListWriter writer = vector.getWriter();
            writer.allocate();
            writer.startList();
            writer.integer().writeInt(1);
            writer.integer().writeInt(2);
            writer.endList();
            vector.setValueCount(2);
            Field expectedDataField = new Field("$data$", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
            Field expectedField = new Field(vector.getName(), FieldType.nullable((ArrowType)ArrowType.LargeList.INSTANCE), Arrays.asList(expectedDataField));
            Assert.assertEquals((Object)expectedField, (Object)writer.getField());
        }
    }

    @Test
    public void testClose() throws Exception {
        try (LargeListVector vector = LargeListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            UnionLargeListWriter writer = vector.getWriter();
            writer.allocate();
            writer.startList();
            writer.integer().writeInt(1);
            writer.integer().writeInt(2);
            writer.endList();
            vector.setValueCount(2);
            Assert.assertTrue((vector.getBufferSize() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((vector.getDataVector().getBufferSize() > 0 ? 1 : 0) != 0);
            writer.close();
            Assert.assertEquals((long)0L, (long)vector.getBufferSize());
            Assert.assertEquals((long)0L, (long)vector.getDataVector().getBufferSize());
        }
    }

    @Test
    public void testGetBufferSizeFor() {
        try (LargeListVector vector = LargeListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            UnionLargeListWriter writer = vector.getWriter();
            writer.allocate();
            this.writeIntValues(writer, new int[]{1, 2});
            this.writeIntValues(writer, new int[]{3, 4});
            this.writeIntValues(writer, new int[]{5, 6});
            this.writeIntValues(writer, new int[]{7, 8, 9, 10});
            this.writeIntValues(writer, new int[]{11, 12, 13, 14});
            writer.setValueCount(5);
            IntVector dataVector = (IntVector)vector.getDataVector();
            int[] indices = new int[]{0, 2, 4, 6, 10, 14};
            for (int valueCount = 1; valueCount <= 5; ++valueCount) {
                int validityBufferSize = BitVectorHelper.getValidityBufferSize((int)valueCount);
                int offsetBufferSize = (valueCount + 1) * 8;
                int expectedSize = validityBufferSize + offsetBufferSize + dataVector.getBufferSizeFor(indices[valueCount]);
                Assert.assertEquals((long)expectedSize, (long)vector.getBufferSizeFor(valueCount));
            }
        }
    }

    @Test
    public void testIsEmpty() {
        try (LargeListVector vector = LargeListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            UnionLargeListWriter writer = vector.getWriter();
            writer.allocate();
            this.writeIntValues(writer, new int[]{1, 2});
            writer.setPosition(2);
            this.writeIntValues(writer, new int[0]);
            this.writeIntValues(writer, new int[]{5, 6});
            writer.setValueCount(4);
            Assert.assertFalse((boolean)vector.isEmpty(0));
            Assert.assertTrue((boolean)vector.isNull(1));
            Assert.assertTrue((boolean)vector.isEmpty(1));
            Assert.assertFalse((boolean)vector.isNull(2));
            Assert.assertTrue((boolean)vector.isEmpty(2));
            Assert.assertFalse((boolean)vector.isEmpty(3));
        }
    }

    private void writeIntValues(UnionLargeListWriter writer, int[] values) {
        writer.startList();
        for (int v : values) {
            writer.integer().writeInt(v);
        }
        writer.endList();
    }
}

