/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestIntervalYearVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testGetAsStringBuilder() {
        try (IntervalYearVector vector = new IntervalYearVector("", this.allocator);){
            int valueCount = 100;
            vector.setInitialCapacity(valueCount);
            vector.allocateNew();
            for (int i = 0; i < valueCount; ++i) {
                vector.set(i, i);
            }
            Assert.assertEquals((Object)"0 years 1 month ", (Object)vector.getAsStringBuilder(1).toString());
            Assert.assertEquals((Object)"0 years 10 months ", (Object)vector.getAsStringBuilder(10).toString());
            Assert.assertEquals((Object)"1 year 8 months ", (Object)vector.getAsStringBuilder(20).toString());
            Assert.assertEquals((Object)"2 years 6 months ", (Object)vector.getAsStringBuilder(30).toString());
            Assert.assertEquals((Object)Types.MinorType.INTERVALYEAR, (Object)vector.getMinorType());
            ArrowType fieldType = vector.getField().getType();
            Assert.assertEquals((Object)ArrowType.ArrowTypeID.Interval, (Object)fieldType.getTypeID());
            ArrowType.Interval intervalType = (ArrowType.Interval)fieldType;
            Assert.assertEquals((Object)IntervalUnit.YEAR_MONTH, (Object)intervalType.getUnit());
        }
    }

    @Test
    public void testGetTransferPairWithField() {
        IntervalYearVector fromVector = new IntervalYearVector("", this.allocator);
        TransferPair transferPair = fromVector.getTransferPair(fromVector.getField(), this.allocator);
        IntervalYearVector toVector = (IntervalYearVector)transferPair.getTo();
        Assert.assertSame((Object)fromVector.getField(), (Object)toVector.getField());
    }
}

