/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.time.Duration;
import java.time.Period;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.arrow.vector.PeriodDuration;
import org.apache.arrow.vector.holders.IntervalMonthDayNanoHolder;
import org.apache.arrow.vector.holders.NullableIntervalMonthDayNanoHolder;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestIntervalMonthDayNanoVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testBasics() {
        try (IntervalMonthDayNanoVector vector = new IntervalMonthDayNanoVector("", this.allocator);){
            int valueCount = 100;
            vector.setInitialCapacity(valueCount);
            vector.allocateNew();
            NullableIntervalMonthDayNanoHolder nullableHolder = new NullableIntervalMonthDayNanoHolder();
            nullableHolder.isSet = 1;
            nullableHolder.months = 2;
            nullableHolder.days = 20;
            nullableHolder.nanoseconds = 123L;
            IntervalMonthDayNanoHolder holder = new IntervalMonthDayNanoHolder();
            holder.months = Integer.MIN_VALUE;
            holder.days = Integer.MIN_VALUE;
            holder.nanoseconds = Long.MIN_VALUE;
            vector.set(0, 1, 2, -2L);
            vector.setSafe(2, 1, 2, -3L);
            vector.setSafe(4, nullableHolder);
            vector.set(3, holder);
            nullableHolder.isSet = 0;
            vector.setSafe(5, nullableHolder);
            vector.setValueCount(5);
            Assert.assertEquals((Object)"P1M2D PT-0.000000002S ", (Object)vector.getAsStringBuilder(0).toString());
            Assert.assertEquals(null, (Object)vector.getAsStringBuilder(1));
            Assert.assertEquals((Object)"P1M2D PT-0.000000003S ", (Object)vector.getAsStringBuilder(2).toString());
            Assert.assertEquals((Object)new PeriodDuration(Period.of(0, Integer.MIN_VALUE, Integer.MIN_VALUE), Duration.ofNanos(Long.MIN_VALUE)), (Object)vector.getObject(3));
            Assert.assertEquals((Object)"P2M20D PT0.000000123S ", (Object)vector.getAsStringBuilder(4).toString());
            Assert.assertEquals(null, (Object)vector.getObject(5));
            vector.get(1, nullableHolder);
            Assert.assertEquals((long)0L, (long)nullableHolder.isSet);
            vector.get(2, nullableHolder);
            Assert.assertEquals((long)1L, (long)nullableHolder.isSet);
            Assert.assertEquals((long)1L, (long)nullableHolder.months);
            Assert.assertEquals((long)2L, (long)nullableHolder.days);
            Assert.assertEquals((long)-3L, (long)nullableHolder.nanoseconds);
            IntervalMonthDayNanoVector.getDays((ArrowBuf)vector.valueBuffer, (int)2);
            Assert.assertEquals((long)1L, (long)IntervalMonthDayNanoVector.getMonths((ArrowBuf)vector.valueBuffer, (int)2));
            Assert.assertEquals((long)2L, (long)IntervalMonthDayNanoVector.getDays((ArrowBuf)vector.valueBuffer, (int)2));
            Assert.assertEquals((long)-3L, (long)IntervalMonthDayNanoVector.getNanoseconds((ArrowBuf)vector.valueBuffer, (int)2));
            Assert.assertEquals((long)0L, (long)vector.isSet(1));
            Assert.assertEquals((long)1L, (long)vector.isSet(2));
            Assert.assertEquals((Object)Types.MinorType.INTERVALMONTHDAYNANO, (Object)vector.getMinorType());
            ArrowType fieldType = vector.getField().getType();
            Assert.assertEquals((Object)ArrowType.ArrowTypeID.Interval, (Object)fieldType.getTypeID());
            ArrowType.Interval intervalType = (ArrowType.Interval)fieldType;
            Assert.assertEquals((Object)IntervalUnit.MONTH_DAY_NANO, (Object)intervalType.getUnit());
        }
    }
}

