/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntBiFunction;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.BaseListVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.dictionary.ListSubfieldEncoder;
import org.apache.arrow.vector.dictionary.StructSubfieldEncoder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDictionaryVector {
    private BufferAllocator allocator;
    byte[] zero = "foo".getBytes(StandardCharsets.UTF_8);
    byte[] one = "bar".getBytes(StandardCharsets.UTF_8);
    byte[] two = "baz".getBytes(StandardCharsets.UTF_8);
    byte[][] data = new byte[][]{this.zero, this.one, this.two};

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testEncodeStrings() {
        try (VarCharVector vector = TestUtils.newVarCharVector("foo", this.allocator);
             VarCharVector dictionaryVector = TestUtils.newVarCharVector("dict", this.allocator);){
            ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{this.zero, this.one, this.one, this.two, this.zero});
            ValueVectorDataPopulator.setVector(dictionaryVector, (byte[][])new byte[][]{this.zero, this.one, this.two});
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (ValueVector encoded = DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);){
                Assert.assertEquals(IntVector.class, encoded.getClass());
                IntVector index = (IntVector)encoded;
                Assert.assertEquals((long)5L, (long)index.getValueCount());
                Assert.assertEquals((long)0L, (long)index.get(0));
                Assert.assertEquals((long)1L, (long)index.get(1));
                Assert.assertEquals((long)1L, (long)index.get(2));
                Assert.assertEquals((long)2L, (long)index.get(3));
                Assert.assertEquals((long)0L, (long)index.get(4));
                try (ValueVector decoded = DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dictionary);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)((VarCharVector)decoded).getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)((VarCharVector)decoded).getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testEncodeLargeVector() {
        try (VarCharVector vector = TestUtils.newVarCharVector("foo", this.allocator);
             VarCharVector dictionaryVector = TestUtils.newVarCharVector("dict", this.allocator);){
            vector.allocateNew();
            int count = 10000;
            for (int i = 0; i < 10000; ++i) {
                vector.setSafe(i, this.data[i % 3], 0, this.data[i % 3].length);
            }
            vector.setValueCount(count);
            ValueVectorDataPopulator.setVector(dictionaryVector, (byte[][])new byte[][]{this.zero, this.one, this.two});
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (ValueVector encoded = DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);){
                Assert.assertEquals(IntVector.class, encoded.getClass());
                IntVector index = (IntVector)encoded;
                Assert.assertEquals((long)count, (long)index.getValueCount());
                for (int i = 0; i < count; ++i) {
                    Assert.assertEquals((long)(i % 3), (long)index.get(i));
                }
                try (ValueVector decoded = DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dictionary);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < count; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testEncodeList() {
        try (ListVector vector = ListVector.empty((String)"vector", (BufferAllocator)this.allocator);
             ListVector dictionaryVector = ListVector.empty((String)"dict", (BufferAllocator)this.allocator);){
            UnionListWriter writer = vector.getWriter();
            writer.allocate();
            this.writeListVector(writer, new int[]{10, 20});
            this.writeListVector(writer, new int[]{10, 20});
            this.writeListVector(writer, new int[]{10, 20});
            this.writeListVector(writer, new int[]{30, 40, 50});
            this.writeListVector(writer, new int[]{30, 40, 50});
            this.writeListVector(writer, new int[]{10, 20});
            writer.setValueCount(6);
            UnionListWriter dictWriter = dictionaryVector.getWriter();
            dictWriter.allocate();
            this.writeListVector(dictWriter, new int[]{10, 20});
            this.writeListVector(dictWriter, new int[]{30, 40, 50});
            dictWriter.setValueCount(2);
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (ValueVector encoded = DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);){
                Assert.assertEquals(IntVector.class, encoded.getClass());
                IntVector index = (IntVector)encoded;
                Assert.assertEquals((long)6L, (long)index.getValueCount());
                Assert.assertEquals((long)0L, (long)index.get(0));
                Assert.assertEquals((long)0L, (long)index.get(1));
                Assert.assertEquals((long)0L, (long)index.get(2));
                Assert.assertEquals((long)1L, (long)index.get(3));
                Assert.assertEquals((long)1L, (long)index.get(4));
                Assert.assertEquals((long)0L, (long)index.get(5));
                try (ValueVector decoded = DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dictionary);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testEncodeStruct() {
        try (StructVector vector = StructVector.empty((String)"vector", (BufferAllocator)this.allocator);
             StructVector dictionaryVector = StructVector.empty((String)"dict", (BufferAllocator)this.allocator);){
            vector.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            dictionaryVector.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            dictionaryVector.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            NullableStructWriter writer = vector.getWriter();
            writer.allocate();
            this.writeStructVector(writer, 1, 10L);
            this.writeStructVector(writer, 1, 10L);
            this.writeStructVector(writer, 1, 10L);
            this.writeStructVector(writer, 2, 20L);
            this.writeStructVector(writer, 2, 20L);
            this.writeStructVector(writer, 2, 20L);
            this.writeStructVector(writer, 1, 10L);
            writer.setValueCount(7);
            NullableStructWriter dictWriter = dictionaryVector.getWriter();
            dictWriter.allocate();
            this.writeStructVector(dictWriter, 1, 10L);
            this.writeStructVector(dictWriter, 2, 20L);
            dictionaryVector.setValueCount(2);
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (ValueVector encoded = DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);){
                Assert.assertEquals(IntVector.class, encoded.getClass());
                IntVector index = (IntVector)encoded;
                Assert.assertEquals((long)7L, (long)index.getValueCount());
                Assert.assertEquals((long)0L, (long)index.get(0));
                Assert.assertEquals((long)0L, (long)index.get(1));
                Assert.assertEquals((long)0L, (long)index.get(2));
                Assert.assertEquals((long)1L, (long)index.get(3));
                Assert.assertEquals((long)1L, (long)index.get(4));
                Assert.assertEquals((long)1L, (long)index.get(5));
                Assert.assertEquals((long)0L, (long)index.get(6));
                try (ValueVector decoded = DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dictionary);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testEncodeBinaryVector() {
        try (VarBinaryVector vector = TestUtils.newVarBinaryVector("foo", this.allocator);
             VarBinaryVector dictionaryVector = TestUtils.newVarBinaryVector("dict", this.allocator);){
            ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{this.zero, this.one, this.one, this.two, this.zero});
            ValueVectorDataPopulator.setVector(dictionaryVector, (byte[][])new byte[][]{this.zero, this.one, this.two});
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (ValueVector encoded = DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);){
                Assert.assertEquals(IntVector.class, encoded.getClass());
                IntVector index = (IntVector)encoded;
                Assert.assertEquals((long)5L, (long)index.getValueCount());
                Assert.assertEquals((long)0L, (long)index.get(0));
                Assert.assertEquals((long)1L, (long)index.get(1));
                Assert.assertEquals((long)1L, (long)index.get(2));
                Assert.assertEquals((long)2L, (long)index.get(3));
                Assert.assertEquals((long)0L, (long)index.get(4));
                try (VarBinaryVector decoded = (VarBinaryVector)DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dictionary);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertTrue((boolean)Arrays.equals(vector.getObject(i), decoded.getObject(i)));
                    }
                }
            }
        }
    }

    @Test
    public void testEncodeUnion() {
        try (UnionVector vector = new UnionVector("vector", this.allocator, null, null);
             UnionVector dictionaryVector = new UnionVector("dict", this.allocator, null, null);){
            NullableUInt4Holder uintHolder1 = new NullableUInt4Holder();
            uintHolder1.value = 10;
            uintHolder1.isSet = 1;
            NullableIntHolder intHolder1 = new NullableIntHolder();
            intHolder1.value = 10;
            intHolder1.isSet = 1;
            NullableIntHolder intHolder2 = new NullableIntHolder();
            intHolder2.value = 20;
            intHolder2.isSet = 1;
            vector.setType(0, Types.MinorType.UINT4);
            vector.setSafe(0, uintHolder1);
            vector.setType(1, Types.MinorType.INT);
            vector.setSafe(1, intHolder1);
            vector.setType(2, Types.MinorType.INT);
            vector.setSafe(2, intHolder1);
            vector.setType(3, Types.MinorType.INT);
            vector.setSafe(3, intHolder2);
            vector.setType(4, Types.MinorType.INT);
            vector.setSafe(4, intHolder2);
            vector.setValueCount(5);
            dictionaryVector.setType(0, Types.MinorType.UINT4);
            dictionaryVector.setSafe(0, uintHolder1);
            dictionaryVector.setType(1, Types.MinorType.INT);
            dictionaryVector.setSafe(1, intHolder1);
            dictionaryVector.setType(2, Types.MinorType.INT);
            dictionaryVector.setSafe(2, intHolder2);
            dictionaryVector.setValueCount(3);
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (ValueVector encoded = DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);){
                Assert.assertEquals(IntVector.class, encoded.getClass());
                IntVector index = (IntVector)encoded;
                Assert.assertEquals((long)5L, (long)index.getValueCount());
                Assert.assertEquals((long)0L, (long)index.get(0));
                Assert.assertEquals((long)1L, (long)index.get(1));
                Assert.assertEquals((long)1L, (long)index.get(2));
                Assert.assertEquals((long)2L, (long)index.get(3));
                Assert.assertEquals((long)2L, (long)index.get(4));
                try (ValueVector decoded = DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dictionary);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testIntEquals() {
        try (IntVector vector1 = new IntVector("int", this.allocator);
             IntVector vector2 = new IntVector("int", this.allocator);){
            Dictionary dict1 = new Dictionary((FieldVector)vector1, new DictionaryEncoding(1L, false, null));
            Dictionary dict2 = new Dictionary((FieldVector)vector2, new DictionaryEncoding(1L, false, null));
            ValueVectorDataPopulator.setVector(vector1, 1, 2, 3);
            ValueVectorDataPopulator.setVector(vector2, 1, 2, 0);
            Assert.assertFalse((boolean)dict1.equals((Object)dict2));
            vector2.setSafe(2, 3);
            Assert.assertTrue((boolean)dict1.equals((Object)dict2));
        }
    }

    @Test
    public void testVarcharEquals() {
        try (VarCharVector vector1 = new VarCharVector("varchar", this.allocator);
             VarCharVector vector2 = new VarCharVector("varchar", this.allocator);){
            Dictionary dict1 = new Dictionary((FieldVector)vector1, new DictionaryEncoding(1L, false, null));
            Dictionary dict2 = new Dictionary((FieldVector)vector2, new DictionaryEncoding(1L, false, null));
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{this.zero, this.one, this.two});
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{this.zero, this.one, this.one});
            Assert.assertFalse((boolean)dict1.equals((Object)dict2));
            vector2.setSafe(2, this.two, 0, this.two.length);
            Assert.assertTrue((boolean)dict1.equals((Object)dict2));
        }
    }

    @Test
    public void testVarBinaryEquals() {
        try (VarBinaryVector vector1 = new VarBinaryVector("binary", this.allocator);
             VarBinaryVector vector2 = new VarBinaryVector("binary", this.allocator);){
            Dictionary dict1 = new Dictionary((FieldVector)vector1, new DictionaryEncoding(1L, false, null));
            Dictionary dict2 = new Dictionary((FieldVector)vector2, new DictionaryEncoding(1L, false, null));
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{this.zero, this.one, this.two});
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{this.zero, this.one, this.one});
            Assert.assertFalse((boolean)dict1.equals((Object)dict2));
            vector2.setSafe(2, this.two, 0, this.two.length);
            Assert.assertTrue((boolean)dict1.equals((Object)dict2));
        }
    }

    @Test
    public void testListEquals() {
        try (ListVector vector1 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector vector2 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            Dictionary dict1 = new Dictionary((FieldVector)vector1, new DictionaryEncoding(1L, false, null));
            Dictionary dict2 = new Dictionary((FieldVector)vector2, new DictionaryEncoding(1L, false, null));
            UnionListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeListVector(writer1, new int[]{1, 2});
            this.writeListVector(writer1, new int[]{3, 4});
            this.writeListVector(writer1, new int[]{5, 6});
            writer1.setValueCount(3);
            UnionListWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeListVector(writer2, new int[]{1, 2});
            this.writeListVector(writer2, new int[]{3, 4});
            this.writeListVector(writer2, new int[]{5, 6});
            writer2.setValueCount(3);
            Assert.assertTrue((boolean)dict1.equals((Object)dict2));
        }
    }

    @Test
    public void testStructEquals() {
        try (StructVector vector1 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);
             StructVector vector2 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            vector1.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector1.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            vector2.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector2.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            Dictionary dict1 = new Dictionary((FieldVector)vector1, new DictionaryEncoding(1L, false, null));
            Dictionary dict2 = new Dictionary((FieldVector)vector2, new DictionaryEncoding(1L, false, null));
            NullableStructWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeStructVector(writer1, 1, 10L);
            this.writeStructVector(writer1, 2, 20L);
            writer1.setValueCount(2);
            NullableStructWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeStructVector(writer2, 1, 10L);
            this.writeStructVector(writer2, 2, 20L);
            writer2.setValueCount(2);
            Assert.assertTrue((boolean)dict1.equals((Object)dict2));
        }
    }

    @Test
    public void testUnionEquals() {
        try (UnionVector vector1 = new UnionVector("union", this.allocator, null, null);
             UnionVector vector2 = new UnionVector("union", this.allocator, null, null);){
            NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
            uInt4Holder.value = 10;
            uInt4Holder.isSet = 1;
            NullableIntHolder intHolder = new NullableIntHolder();
            uInt4Holder.value = 20;
            uInt4Holder.isSet = 1;
            vector1.setType(0, Types.MinorType.UINT4);
            vector1.setSafe(0, uInt4Holder);
            vector1.setType(2, Types.MinorType.INT);
            vector1.setSafe(2, intHolder);
            vector1.setValueCount(3);
            vector2.setType(0, Types.MinorType.UINT4);
            vector2.setSafe(0, uInt4Holder);
            vector2.setType(2, Types.MinorType.INT);
            vector2.setSafe(2, intHolder);
            vector2.setValueCount(3);
            Dictionary dict1 = new Dictionary((FieldVector)vector1, new DictionaryEncoding(1L, false, null));
            Dictionary dict2 = new Dictionary((FieldVector)vector2, new DictionaryEncoding(1L, false, null));
            Assert.assertTrue((boolean)dict1.equals((Object)dict2));
        }
    }

    @Test
    public void testEncodeWithEncoderInstance() {
        try (VarCharVector vector = TestUtils.newVarCharVector("vector", this.allocator);
             VarCharVector dictionaryVector = TestUtils.newVarCharVector("dict", this.allocator);){
            ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{this.zero, this.one, this.one, this.two, this.zero});
            ValueVectorDataPopulator.setVector(dictionaryVector, (byte[][])new byte[][]{this.zero, this.one, this.two});
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            DictionaryEncoder encoder = new DictionaryEncoder(dictionary, this.allocator);
            try (ValueVector encoded = encoder.encode((ValueVector)vector);){
                Assert.assertEquals(IntVector.class, encoded.getClass());
                IntVector index = (IntVector)encoded;
                Assert.assertEquals((long)5L, (long)index.getValueCount());
                Assert.assertEquals((long)0L, (long)index.get(0));
                Assert.assertEquals((long)1L, (long)index.get(1));
                Assert.assertEquals((long)1L, (long)index.get(2));
                Assert.assertEquals((long)2L, (long)index.get(3));
                Assert.assertEquals((long)0L, (long)index.get(4));
                try (ValueVector decoded = encoder.decode(encoded);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)((VarCharVector)decoded).getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testEncodeMultiVectors() {
        try (VarCharVector vector1 = TestUtils.newVarCharVector("vector1", this.allocator);
             VarCharVector vector2 = TestUtils.newVarCharVector("vector2", this.allocator);
             VarCharVector dictionaryVector = TestUtils.newVarCharVector("dict", this.allocator);){
            int i2;
            Throwable throwable;
            ValueVector decoded;
            IntVector index;
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{this.zero, this.one, this.one, this.two, this.zero});
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{this.zero, this.one, this.one});
            ValueVectorDataPopulator.setVector(dictionaryVector, (byte[][])new byte[][]{this.zero, this.one, this.two});
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            DictionaryEncoder encoder = new DictionaryEncoder(dictionary, this.allocator);
            try (ValueVector encoded = encoder.encode((ValueVector)vector1);){
                Assert.assertEquals(IntVector.class, encoded.getClass());
                index = (IntVector)encoded;
                Assert.assertEquals((long)5L, (long)index.getValueCount());
                Assert.assertEquals((long)0L, (long)index.get(0));
                Assert.assertEquals((long)1L, (long)index.get(1));
                Assert.assertEquals((long)1L, (long)index.get(2));
                Assert.assertEquals((long)2L, (long)index.get(3));
                Assert.assertEquals((long)0L, (long)index.get(4));
                decoded = encoder.decode(encoded);
                throwable = null;
                try {
                    Assert.assertEquals(vector1.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector1.getValueCount(), (long)decoded.getValueCount());
                    for (i2 = 0; i2 < 5; ++i2) {
                        Assert.assertEquals((Object)vector1.getObject(i2), (Object)((VarCharVector)decoded).getObject(i2));
                    }
                }
                catch (Throwable i2) {
                    throwable = i2;
                    throw i2;
                }
                finally {
                    if (decoded != null) {
                        TestDictionaryVector.$closeResource(throwable, (AutoCloseable)decoded);
                    }
                }
            }
            encoded = encoder.encode((ValueVector)vector2);
            var10_13 = null;
            try {
                Assert.assertEquals(IntVector.class, encoded.getClass());
                index = (IntVector)encoded;
                Assert.assertEquals((long)3L, (long)index.getValueCount());
                Assert.assertEquals((long)0L, (long)index.get(0));
                Assert.assertEquals((long)1L, (long)index.get(1));
                Assert.assertEquals((long)1L, (long)index.get(2));
                decoded = encoder.decode(encoded);
                throwable = null;
                try {
                    Assert.assertEquals(vector2.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector2.getValueCount(), (long)decoded.getValueCount());
                    for (i2 = 0; i2 < 3; ++i2) {
                        Assert.assertEquals((Object)vector2.getObject(i2), (Object)((VarCharVector)decoded).getObject(i2));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (decoded != null) {
                        TestDictionaryVector.$closeResource(throwable, (AutoCloseable)decoded);
                    }
                }
            }
            catch (Throwable throwable3) {
                var10_13 = throwable3;
                throw throwable3;
            }
            finally {
                if (encoded != null) {
                    TestDictionaryVector.$closeResource(var10_13, (AutoCloseable)encoded);
                }
            }
        }
    }

    @Test
    public void testEncodeListSubField() {
        try (ListVector vector = ListVector.empty((String)"vector", (BufferAllocator)this.allocator);
             ListVector dictionaryVector = ListVector.empty((String)"dict", (BufferAllocator)this.allocator);){
            UnionListWriter writer = vector.getWriter();
            writer.allocate();
            this.writeListVector(writer, new int[]{10, 20});
            this.writeListVector(writer, new int[]{10, 20});
            this.writeListVector(writer, new int[]{10, 20});
            this.writeListVector(writer, new int[]{30, 40, 50});
            this.writeListVector(writer, new int[]{30, 40, 50});
            this.writeListVector(writer, new int[]{10, 20});
            writer.setValueCount(6);
            UnionListWriter dictWriter = dictionaryVector.getWriter();
            dictWriter.allocate();
            this.writeListVector(dictWriter, new int[]{10, 20, 30, 40, 50});
            dictionaryVector.setValueCount(1);
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            ListSubfieldEncoder encoder = new ListSubfieldEncoder(dictionary, this.allocator);
            try (ListVector encoded = (ListVector)encoder.encodeListSubField((BaseListVector)vector);){
                Assert.assertEquals(ListVector.class, encoded.getClass());
                Assert.assertEquals((long)6L, (long)encoded.getValueCount());
                int[] realValue1 = this.convertListToIntArray(encoded.getObject(0));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{0, 1}, realValue1));
                int[] realValue2 = this.convertListToIntArray(encoded.getObject(1));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{0, 1}, realValue2));
                int[] realValue3 = this.convertListToIntArray(encoded.getObject(2));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{0, 1}, realValue3));
                int[] realValue4 = this.convertListToIntArray(encoded.getObject(3));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 3, 4}, realValue4));
                int[] realValue5 = this.convertListToIntArray(encoded.getObject(4));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 3, 4}, realValue5));
                int[] realValue6 = this.convertListToIntArray(encoded.getObject(5));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{0, 1}, realValue6));
                try (BaseListVector decoded = encoder.decodeListSubField((BaseListVector)encoded);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testEncodeFixedSizeListSubField() {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"vector", (int)2, (BufferAllocator)this.allocator);
             FixedSizeListVector dictionaryVector = FixedSizeListVector.empty((String)"dict", (int)2, (BufferAllocator)this.allocator);){
            vector.allocateNew();
            vector.setValueCount(4);
            IntVector dataVector = (IntVector)vector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType())).getVector();
            dataVector.allocateNew(8);
            dataVector.setValueCount(8);
            vector.setNotNull(0);
            dataVector.set(0, 10);
            dataVector.set(1, 20);
            vector.setNotNull(1);
            dataVector.set(2, 10);
            dataVector.set(3, 20);
            vector.setNotNull(2);
            dataVector.set(4, 30);
            dataVector.set(5, 40);
            vector.setNotNull(3);
            dataVector.set(6, 10);
            dataVector.set(7, 20);
            dictionaryVector.allocateNew();
            dictionaryVector.setValueCount(2);
            IntVector dictDataVector = (IntVector)dictionaryVector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType())).getVector();
            dictDataVector.allocateNew(4);
            dictDataVector.setValueCount(4);
            dictionaryVector.setNotNull(0);
            dictDataVector.set(0, 10);
            dictDataVector.set(1, 20);
            dictionaryVector.setNotNull(1);
            dictDataVector.set(2, 30);
            dictDataVector.set(3, 40);
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            ListSubfieldEncoder encoder = new ListSubfieldEncoder(dictionary, this.allocator);
            try (FixedSizeListVector encoded = (FixedSizeListVector)encoder.encodeListSubField((BaseListVector)vector);){
                Assert.assertEquals(FixedSizeListVector.class, encoded.getClass());
                Assert.assertEquals((long)4L, (long)encoded.getValueCount());
                int[] realValue1 = this.convertListToIntArray(encoded.getObject(0));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{0, 1}, realValue1));
                int[] realValue2 = this.convertListToIntArray(encoded.getObject(1));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{0, 1}, realValue2));
                int[] realValue3 = this.convertListToIntArray(encoded.getObject(2));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 3}, realValue3));
                int[] realValue4 = this.convertListToIntArray(encoded.getObject(3));
                Assert.assertTrue((boolean)Arrays.equals(new int[]{0, 1}, realValue4));
                try (BaseListVector decoded = encoder.decodeListSubField((BaseListVector)encoded);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testEncodeStructSubField() {
        try (StructVector vector = StructVector.empty((String)"vector", (BufferAllocator)this.allocator);
             VarCharVector dictVector1 = new VarCharVector("f0", this.allocator);
             VarCharVector dictVector2 = new VarCharVector("f1", this.allocator);){
            vector.addOrGet("f0", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), VarCharVector.class);
            vector.addOrGet("f1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), VarCharVector.class);
            NullableStructWriter writer = vector.getWriter();
            writer.allocate();
            this.writeStructVector(writer, "aa", "baz");
            this.writeStructVector(writer, "bb", "bar");
            this.writeStructVector(writer, "cc", "foo");
            this.writeStructVector(writer, "aa", "foo");
            this.writeStructVector(writer, "dd", "foo");
            writer.setValueCount(5);
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            ValueVectorDataPopulator.setVector(dictVector1, (byte[][])new byte[][]{"aa".getBytes(StandardCharsets.UTF_8), "bb".getBytes(StandardCharsets.UTF_8), "cc".getBytes(StandardCharsets.UTF_8), "dd".getBytes(StandardCharsets.UTF_8)});
            ValueVectorDataPopulator.setVector(dictVector2, (byte[][])new byte[][]{"foo".getBytes(StandardCharsets.UTF_8), "baz".getBytes(StandardCharsets.UTF_8), "bar".getBytes(StandardCharsets.UTF_8)});
            provider.put(new Dictionary((FieldVector)dictVector1, new DictionaryEncoding(1L, false, null)));
            provider.put(new Dictionary((FieldVector)dictVector2, new DictionaryEncoding(2L, false, null)));
            StructSubfieldEncoder encoder = new StructSubfieldEncoder(this.allocator, provider);
            HashMap<Integer, Long> columnToDictionaryId = new HashMap<Integer, Long>();
            columnToDictionaryId.put(0, 1L);
            columnToDictionaryId.put(1, 2L);
            try (StructVector encoded = encoder.encode(vector, columnToDictionaryId);){
                Assert.assertEquals(StructVector.class, encoded.getClass());
                Assert.assertEquals((long)5L, (long)encoded.getValueCount());
                Object[] realValue1 = this.convertMapValuesToArray(encoded.getObject(0));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{0, 1}, realValue1));
                Object[] realValue2 = this.convertMapValuesToArray(encoded.getObject(1));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{1, 2}, realValue2));
                Object[] realValue3 = this.convertMapValuesToArray(encoded.getObject(2));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{2, 0}, realValue3));
                Object[] realValue4 = this.convertMapValuesToArray(encoded.getObject(3));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{0, 0}, realValue4));
                Object[] realValue5 = this.convertMapValuesToArray(encoded.getObject(4));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{3, 0}, realValue5));
                try (StructVector decoded = encoder.decode(encoded);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testEncodeStructSubFieldWithCertainColumns() {
        try (StructVector vector = StructVector.empty((String)"vector", (BufferAllocator)this.allocator);
             VarCharVector dictVector1 = new VarCharVector("f0", this.allocator);){
            vector.addOrGet("f0", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), VarCharVector.class);
            vector.addOrGet("f1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), VarCharVector.class);
            NullableStructWriter writer = vector.getWriter();
            writer.allocate();
            this.writeStructVector(writer, "aa", "baz");
            this.writeStructVector(writer, "bb", "bar");
            this.writeStructVector(writer, "cc", "foo");
            this.writeStructVector(writer, "aa", "foo");
            this.writeStructVector(writer, "dd", "foo");
            writer.setValueCount(5);
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            ValueVectorDataPopulator.setVector(dictVector1, (byte[][])new byte[][]{"aa".getBytes(), "bb".getBytes(), "cc".getBytes(), "dd".getBytes()});
            provider.put(new Dictionary((FieldVector)dictVector1, new DictionaryEncoding(1L, false, null)));
            StructSubfieldEncoder encoder = new StructSubfieldEncoder(this.allocator, provider);
            HashMap<Integer, Long> columnToDictionaryId = new HashMap<Integer, Long>();
            columnToDictionaryId.put(0, 1L);
            try (StructVector encoded = encoder.encode(vector, columnToDictionaryId);){
                Assert.assertEquals(StructVector.class, encoded.getClass());
                Assert.assertEquals((long)5L, (long)encoded.getValueCount());
                Object[] realValue1 = this.convertMapValuesToArray(encoded.getObject(0));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{0, new Text("baz")}, realValue1));
                Object[] realValue2 = this.convertMapValuesToArray(encoded.getObject(1));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{1, new Text("bar")}, realValue2));
                Object[] realValue3 = this.convertMapValuesToArray(encoded.getObject(2));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{2, new Text("foo")}, realValue3));
                Object[] realValue4 = this.convertMapValuesToArray(encoded.getObject(3));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{0, new Text("foo")}, realValue4));
                Object[] realValue5 = this.convertMapValuesToArray(encoded.getObject(4));
                Assert.assertTrue((boolean)Arrays.equals(new Object[]{3, new Text("foo")}, realValue5));
                try (StructVector decoded = encoder.decode(encoded);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getValueCount(), (long)decoded.getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testNoMemoryLeak() {
        Throwable throwable;
        Dictionary dictionary2;
        Throwable throwable2;
        VarCharVector dictionaryVector;
        try (VarCharVector vector = TestUtils.newVarCharVector("foo", this.allocator);){
            dictionaryVector = TestUtils.newVarCharVector("dict", this.allocator);
            throwable2 = null;
            try {
                ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{this.zero, this.one, this.two});
                ValueVectorDataPopulator.setVector(dictionaryVector, (byte[][])new byte[][]{this.zero, this.one});
                dictionary2 = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
                try {
                    throwable = null;
                    try (ValueVector encoded = DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary2);){
                        Assert.fail((String)"There should be an exception when encoding");
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)("Dictionary encoding not defined for value:" + new Text(this.two)), (Object)e.getMessage());
                }
            }
            catch (Throwable dictionary2) {
                throwable2 = dictionary2;
                throw dictionary2;
            }
            finally {
                if (dictionaryVector != null) {
                    TestDictionaryVector.$closeResource(throwable2, (AutoCloseable)dictionaryVector);
                }
            }
        }
        Assert.assertEquals((String)"encode memory leak", (long)0L, (long)this.allocator.getAllocatedMemory());
        var2_2 = null;
        try (IntVector indices = TestUtils.newVector(IntVector.class, "", Types.MinorType.INT, this.allocator);){
            dictionaryVector = TestUtils.newVarCharVector("dict", this.allocator);
            throwable2 = null;
            try {
                ValueVectorDataPopulator.setVector(indices, 3);
                ValueVectorDataPopulator.setVector(dictionaryVector, (byte[][])new byte[][]{this.zero, this.one});
                dictionary2 = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
                try {
                    throwable = null;
                    try (ValueVector decoded = DictionaryEncoder.decode((ValueVector)indices, (Dictionary)dictionary2, (BufferAllocator)this.allocator);){
                        Assert.fail((String)"There should be an exception when decoding");
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)"Provided dictionary does not contain value for index 3", (Object)e.getMessage());
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (dictionaryVector != null) {
                    TestDictionaryVector.$closeResource(throwable2, (AutoCloseable)dictionaryVector);
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        Assert.assertEquals((String)"decode memory leak", (long)0L, (long)this.allocator.getAllocatedMemory());
    }

    @Test
    public void testListNoMemoryLeak() {
        Dictionary dictionary;
        UnionListWriter dictWriter;
        UnionListWriter writer2;
        Throwable throwable;
        ListVector dictionaryVector;
        try (ListVector vector = ListVector.empty((String)"vector", (BufferAllocator)this.allocator);){
            dictionaryVector = ListVector.empty((String)"dict", (BufferAllocator)this.allocator);
            throwable = null;
            try {
                writer2 = vector.getWriter();
                writer2.allocate();
                this.writeListVector(writer2, new int[]{10, 20});
                writer2.setValueCount(1);
                dictWriter = dictionaryVector.getWriter();
                dictWriter.allocate();
                this.writeListVector(dictWriter, new int[]{10});
                dictionaryVector.setValueCount(1);
                dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
                ListSubfieldEncoder encoder = new ListSubfieldEncoder(dictionary, this.allocator);
                try (ListVector encoded = (ListVector)encoder.encodeListSubField((BaseListVector)vector);){
                    Assert.fail((String)"There should be an exception when encoding");
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)"Dictionary encoding not defined for value:20", (Object)e.getMessage());
                }
            }
            catch (Throwable writer2) {
                throwable = writer2;
                throw writer2;
            }
            finally {
                if (dictionaryVector != null) {
                    TestDictionaryVector.$closeResource(throwable, (AutoCloseable)dictionaryVector);
                }
            }
        }
        Assert.assertEquals((String)"list encode memory leak", (long)0L, (long)this.allocator.getAllocatedMemory());
        var2_2 = null;
        try (ListVector indices = ListVector.empty((String)"indices", (BufferAllocator)this.allocator);){
            dictionaryVector = ListVector.empty((String)"dict", (BufferAllocator)this.allocator);
            throwable = null;
            try {
                writer2 = indices.getWriter();
                writer2.allocate();
                this.writeListVector(writer2, new int[]{3});
                writer2.setValueCount(1);
                dictWriter = dictionaryVector.getWriter();
                dictWriter.allocate();
                this.writeListVector(dictWriter, new int[]{10, 20});
                dictionaryVector.setValueCount(1);
                dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
                try (BaseListVector decoded = ListSubfieldEncoder.decodeListSubField((BaseListVector)indices, (Dictionary)dictionary, (BufferAllocator)this.allocator);){
                    Assert.fail((String)"There should be an exception when decoding");
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)"Provided dictionary does not contain value for index 3", (Object)e.getMessage());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dictionaryVector != null) {
                    TestDictionaryVector.$closeResource(throwable, (AutoCloseable)dictionaryVector);
                }
            }
        }
        catch (Throwable throwable3) {
            var2_2 = throwable3;
            throw throwable3;
        }
        Assert.assertEquals((String)"list decode memory leak", (long)0L, (long)this.allocator.getAllocatedMemory());
    }

    @Test
    public void testStructNoMemoryLeak() {
        Throwable throwable;
        VarCharVector dictVector22;
        Throwable throwable2;
        VarCharVector dictVector1;
        try (StructVector vector = StructVector.empty((String)"vector", (BufferAllocator)this.allocator);){
            dictVector1 = new VarCharVector("f0", this.allocator);
            throwable2 = null;
            try {
                dictVector22 = new VarCharVector("f1", this.allocator);
                throwable = null;
                try {
                    vector.addOrGet("f0", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), VarCharVector.class);
                    vector.addOrGet("f1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), VarCharVector.class);
                    NullableStructWriter writer = vector.getWriter();
                    writer.allocate();
                    this.writeStructVector(writer, "aa", "baz");
                    writer.setValueCount(1);
                    DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
                    ValueVectorDataPopulator.setVector(dictVector1, (byte[][])new byte[][]{"aa".getBytes(StandardCharsets.UTF_8)});
                    ValueVectorDataPopulator.setVector(dictVector22, (byte[][])new byte[][]{"foo".getBytes(StandardCharsets.UTF_8)});
                    provider.put(new Dictionary((FieldVector)dictVector1, new DictionaryEncoding(1L, false, null)));
                    provider.put(new Dictionary((FieldVector)dictVector22, new DictionaryEncoding(2L, false, null)));
                    StructSubfieldEncoder encoder = new StructSubfieldEncoder(this.allocator, provider);
                    HashMap<Integer, Long> columnToDictionaryId = new HashMap<Integer, Long>();
                    columnToDictionaryId.put(0, 1L);
                    columnToDictionaryId.put(1, 2L);
                    try (StructVector encoded = encoder.encode(vector, columnToDictionaryId);){
                        Assert.fail((String)"There should be an exception when encoding");
                    }
                    catch (Exception e) {
                        Assert.assertEquals((Object)"Dictionary encoding not defined for value:baz", (Object)e.getMessage());
                    }
                }
                catch (Throwable writer) {
                    throwable = writer;
                    throw writer;
                }
                finally {
                    TestDictionaryVector.$closeResource(throwable, (AutoCloseable)dictVector22);
                }
            }
            catch (Throwable dictVector22) {
                throwable2 = dictVector22;
                throw dictVector22;
            }
            finally {
                TestDictionaryVector.$closeResource(throwable2, (AutoCloseable)dictVector1);
            }
        }
        Assert.assertEquals((String)"struct encode memory leak", (long)0L, (long)this.allocator.getAllocatedMemory());
        var2_2 = null;
        try (StructVector indices = StructVector.empty((String)"indices", (BufferAllocator)this.allocator);){
            dictVector1 = new VarCharVector("f0", this.allocator);
            throwable2 = null;
            try {
                dictVector22 = new VarCharVector("f1", this.allocator);
                throwable = null;
                try {
                    DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
                    ValueVectorDataPopulator.setVector(dictVector1, (byte[][])new byte[][]{"aa".getBytes(StandardCharsets.UTF_8)});
                    ValueVectorDataPopulator.setVector(dictVector22, (byte[][])new byte[][]{"foo".getBytes(StandardCharsets.UTF_8)});
                    provider.put(new Dictionary((FieldVector)dictVector1, new DictionaryEncoding(1L, false, null)));
                    provider.put(new Dictionary((FieldVector)dictVector22, new DictionaryEncoding(2L, false, null)));
                    ArrowType.Int int32 = new ArrowType.Int(32, true);
                    indices.addOrGet("f0", new FieldType(true, (ArrowType)int32, provider.lookup(1L).getEncoding()), IntVector.class);
                    indices.addOrGet("f1", new FieldType(true, (ArrowType)int32, provider.lookup(2L).getEncoding()), IntVector.class);
                    NullableStructWriter writer = indices.getWriter();
                    writer.allocate();
                    writer.start();
                    writer.integer("f0").writeInt(1);
                    writer.integer("f1").writeInt(3);
                    writer.end();
                    writer.setValueCount(1);
                    try (StructVector decode = StructSubfieldEncoder.decode((StructVector)indices, (DictionaryProvider.MapDictionaryProvider)provider, (BufferAllocator)this.allocator);){
                        Assert.fail((String)"There should be an exception when decoding");
                    }
                    catch (Exception e) {
                        Assert.assertEquals((Object)"Provided dictionary does not contain value for index 3", (Object)e.getMessage());
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    TestDictionaryVector.$closeResource(throwable, (AutoCloseable)dictVector22);
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                TestDictionaryVector.$closeResource(throwable2, (AutoCloseable)dictVector1);
            }
        }
        catch (Throwable throwable5) {
            var2_2 = throwable5;
            throw throwable5;
        }
        Assert.assertEquals((String)"struct decode memory leak", (long)0L, (long)this.allocator.getAllocatedMemory());
    }

    private void testDictionary(Dictionary dictionary, ToIntBiFunction<ValueVector, Integer> valGetter) {
        try (VarCharVector vector = new VarCharVector("vector", this.allocator);){
            ValueVectorDataPopulator.setVector(vector, "1", "3", "5", "7", "9");
            try (ValueVector encodedVector = DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);){
                Assert.assertEquals((long)vector.getValueCount(), (long)encodedVector.getValueCount());
                Assert.assertEquals((long)valGetter.applyAsInt(encodedVector, 0), (long)1L);
                Assert.assertEquals((long)valGetter.applyAsInt(encodedVector, 1), (long)3L);
                Assert.assertEquals((long)valGetter.applyAsInt(encodedVector, 2), (long)5L);
                Assert.assertEquals((long)valGetter.applyAsInt(encodedVector, 3), (long)7L);
                Assert.assertEquals((long)valGetter.applyAsInt(encodedVector, 4), (long)9L);
                try (ValueVector decodedVector = DictionaryEncoder.decode((ValueVector)encodedVector, (Dictionary)dictionary);){
                    Assert.assertTrue((boolean)(decodedVector instanceof VarCharVector));
                    Assert.assertEquals((long)vector.getValueCount(), (long)decodedVector.getValueCount());
                    Assert.assertArrayEquals((byte[])"1".getBytes(), (byte[])((VarCharVector)decodedVector).get(0));
                    Assert.assertArrayEquals((byte[])"3".getBytes(), (byte[])((VarCharVector)decodedVector).get(1));
                    Assert.assertArrayEquals((byte[])"5".getBytes(), (byte[])((VarCharVector)decodedVector).get(2));
                    Assert.assertArrayEquals((byte[])"7".getBytes(), (byte[])((VarCharVector)decodedVector).get(3));
                    Assert.assertArrayEquals((byte[])"9".getBytes(), (byte[])((VarCharVector)decodedVector).get(4));
                }
            }
        }
    }

    @Test
    public void testDictionaryUInt1() {
        try (VarCharVector dictionaryVector = new VarCharVector("dict vector", this.allocator);){
            ValueVectorDataPopulator.setVector(dictionaryVector, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
            Dictionary dictionary1 = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(10L, false, new ArrowType.Int(8, false)));
            this.testDictionary(dictionary1, (vector, index) -> ((UInt1Vector)vector).get(index.intValue()));
        }
    }

    @Test
    public void testDictionaryUInt2() {
        try (VarCharVector dictionaryVector = new VarCharVector("dict vector", this.allocator);){
            ValueVectorDataPopulator.setVector(dictionaryVector, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
            Dictionary dictionary2 = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(20L, false, new ArrowType.Int(16, false)));
            this.testDictionary(dictionary2, (vector, index) -> ((UInt2Vector)vector).get(index.intValue()));
        }
    }

    @Test
    public void testDictionaryUInt4() {
        try (VarCharVector dictionaryVector = new VarCharVector("dict vector", this.allocator);){
            ValueVectorDataPopulator.setVector(dictionaryVector, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
            Dictionary dictionary4 = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(30L, false, new ArrowType.Int(32, false)));
            this.testDictionary(dictionary4, (vector, index) -> ((UInt4Vector)vector).get(index.intValue()));
        }
    }

    @Test
    public void testDictionaryUInt8() {
        try (VarCharVector dictionaryVector = new VarCharVector("dict vector", this.allocator);){
            ValueVectorDataPopulator.setVector(dictionaryVector, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
            Dictionary dictionary8 = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(40L, false, new ArrowType.Int(64, false)));
            this.testDictionary(dictionary8, (vector, index) -> (int)((UInt8Vector)vector).get(index.intValue()));
        }
    }

    @Test
    public void testDictionaryUIntOverflow() {
        int vecLength = 256;
        try (VarCharVector dictionaryVector = new VarCharVector("dict vector", this.allocator);){
            dictionaryVector.allocateNew(768L, 256);
            for (int i = 0; i < 256; ++i) {
                dictionaryVector.set(i, String.valueOf(i).getBytes());
            }
            dictionaryVector.setValueCount(256);
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(10L, false, new ArrowType.Int(8, false)));
            try (VarCharVector vector = new VarCharVector("vector", this.allocator);){
                ValueVectorDataPopulator.setVector(vector, "255");
                try (UInt1Vector encodedVector = (UInt1Vector)DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);){
                    Assert.assertEquals((long)1L, (long)encodedVector.getValueCount());
                    Assert.assertEquals((long)255L, (long)encodedVector.getValueAsLong(0));
                    try (VarCharVector decodedVector = (VarCharVector)DictionaryEncoder.decode((ValueVector)encodedVector, (Dictionary)dictionary);){
                        Assert.assertEquals((long)1L, (long)decodedVector.getValueCount());
                        Assert.assertArrayEquals((byte[])"255".getBytes(), (byte[])decodedVector.get(0));
                    }
                }
            }
        }
    }

    private int[] convertListToIntArray(List list) {
        int[] values = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            values[i] = (Integer)list.get(i);
        }
        return values;
    }

    private Object[] convertMapValuesToArray(Map map) {
        Object[] values = new Object[map.size()];
        Iterator valueIterator = map.values().iterator();
        for (int i = 0; i < map.size(); ++i) {
            values[i] = valueIterator.next();
        }
        return values;
    }

    private void writeStructVector(NullableStructWriter writer, String value1, String value2) {
        byte[] bytes2;
        byte[] bytes1 = value1.getBytes(StandardCharsets.UTF_8);
        ArrowBuf temp = this.allocator.buffer(bytes1.length > (bytes2 = value2.getBytes(StandardCharsets.UTF_8)).length ? (long)bytes1.length : (long)bytes2.length);
        writer.start();
        temp.setBytes(0L, bytes1);
        writer.varChar("f0").writeVarChar(0, bytes1.length, temp);
        temp.setBytes(0L, bytes2);
        writer.varChar("f1").writeVarChar(0, bytes2.length, temp);
        writer.end();
        temp.close();
    }

    private void writeStructVector(NullableStructWriter writer, int value1, long value2) {
        writer.start();
        writer.integer("f0").writeInt(value1);
        writer.bigInt("f1").writeBigInt(value2);
        writer.end();
    }

    private void writeListVector(UnionListWriter writer, int[] values) {
        writer.startList();
        for (int v : values) {
            writer.integer().writeInt(v);
        }
        writer.endList();
    }
}

