/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.junit.AbstractActiveMQClientDelegate;
import org.apache.activemq.artemis.junit.ActiveMQDynamicProducerDelegate;
import org.apache.activemq.artemis.junit.ActiveMQDynamicProducerOperations;
import org.apache.activemq.artemis.junit.ActiveMQProducerOperations;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ActiveMQDynamicProducerExtension
implements BeforeAllCallback,
AfterAllCallback,
ActiveMQDynamicProducerOperations,
ActiveMQProducerOperations {
    private ActiveMQDynamicProducerDelegate activeMQDynamicProducer;

    public ActiveMQDynamicProducerExtension(String url, String username, String password) {
        this.activeMQDynamicProducer = new ActiveMQDynamicProducerDelegate(url, username, password);
    }

    public ActiveMQDynamicProducerExtension(String url) {
        this.activeMQDynamicProducer = new ActiveMQDynamicProducerDelegate(url);
    }

    public ActiveMQDynamicProducerExtension(ServerLocator serverLocator, String username, String password) {
        this.activeMQDynamicProducer = new ActiveMQDynamicProducerDelegate(serverLocator, username, password);
    }

    public ActiveMQDynamicProducerExtension(ServerLocator serverLocator) {
        this.activeMQDynamicProducer = new ActiveMQDynamicProducerDelegate(serverLocator);
    }

    public ActiveMQDynamicProducerExtension(String url, SimpleString address, String username, String password) {
        this.activeMQDynamicProducer = new ActiveMQDynamicProducerDelegate(url, address, username, password);
    }

    public ActiveMQDynamicProducerExtension(String url, SimpleString address) {
        this.activeMQDynamicProducer = new ActiveMQDynamicProducerDelegate(url, address);
    }

    public ActiveMQDynamicProducerExtension(ServerLocator serverLocator, SimpleString address, String username, String password) {
        this.activeMQDynamicProducer = new ActiveMQDynamicProducerDelegate(serverLocator, address, username, password);
    }

    public ActiveMQDynamicProducerExtension(ServerLocator serverLocator, SimpleString address) {
        this.activeMQDynamicProducer = new ActiveMQDynamicProducerDelegate(serverLocator, address);
    }

    protected void createClient() {
        this.activeMQDynamicProducer.createClient();
    }

    public boolean isUseDurableMessage() {
        return this.activeMQDynamicProducer.isUseDurableMessage();
    }

    public void setUseDurableMessage(boolean useDurableMessage) {
        this.activeMQDynamicProducer.setUseDurableMessage(useDurableMessage);
    }

    public void stopClient() {
        this.activeMQDynamicProducer.stopClient();
    }

    public ClientMessage createMessage() {
        return this.activeMQDynamicProducer.createMessage();
    }

    public ClientMessage createMessage(byte[] body) {
        return this.activeMQDynamicProducer.createMessage(body);
    }

    public ClientMessage createMessage(String body) {
        return this.activeMQDynamicProducer.createMessage(body);
    }

    public ClientMessage createMessage(Map<String, Object> properties) {
        return this.activeMQDynamicProducer.createMessage(properties);
    }

    public ClientMessage createMessage(byte[] body, Map<String, Object> properties) {
        return this.activeMQDynamicProducer.createMessage(body, properties);
    }

    public ClientMessage createMessage(String body, Map<String, Object> properties) {
        return this.activeMQDynamicProducer.createMessage(body, properties);
    }

    public void sendMessage(ClientMessage message) {
        this.activeMQDynamicProducer.sendMessage(message);
    }

    public ClientMessage sendMessage(byte[] body) {
        return this.activeMQDynamicProducer.sendMessage(body);
    }

    public ClientMessage sendMessage(String body) {
        return this.activeMQDynamicProducer.sendMessage(body);
    }

    public ClientMessage sendMessage(Map<String, Object> properties) {
        return this.activeMQDynamicProducer.sendMessage(properties);
    }

    public ClientMessage sendMessage(byte[] body, Map<String, Object> properties) {
        return this.activeMQDynamicProducer.sendMessage(body, properties);
    }

    public ClientMessage sendMessage(String body, Map<String, Object> properties) {
        return this.activeMQDynamicProducer.sendMessage(body, properties);
    }

    public void sendMessage(SimpleString targetAddress, ClientMessage message) {
        this.activeMQDynamicProducer.sendMessage(targetAddress, message);
    }

    public ClientMessage sendMessage(SimpleString targetAddress, byte[] body) {
        return this.activeMQDynamicProducer.sendMessage(targetAddress, body);
    }

    public ClientMessage sendMessage(SimpleString targetAddress, String body) {
        return this.activeMQDynamicProducer.sendMessage(targetAddress, body);
    }

    public ClientMessage sendMessage(SimpleString targetAddress, Map<String, Object> properties) {
        return this.activeMQDynamicProducer.sendMessage(targetAddress, properties);
    }

    public ClientMessage sendMessage(SimpleString targetAddress, byte[] body, Map<String, Object> properties) {
        return this.activeMQDynamicProducer.sendMessage(targetAddress, body, properties);
    }

    public ClientMessage sendMessage(SimpleString targetAddress, String body, Map<String, Object> properties) {
        return this.activeMQDynamicProducer.sendMessage(targetAddress, body, properties);
    }

    public static void addMessageProperties(ClientMessage message, Map<String, Object> properties) {
        AbstractActiveMQClientDelegate.addMessageProperties((ClientMessage)message, properties);
    }

    public boolean isAutoCreateQueue() {
        return this.activeMQDynamicProducer.isAutoCreateQueue();
    }

    public void setAutoCreateQueue(boolean autoCreateQueue) {
        this.activeMQDynamicProducer.setAutoCreateQueue(autoCreateQueue);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.activeMQDynamicProducer.start();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.activeMQDynamicProducer.stop();
    }
}

