/** This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
    and it inherits whatever license is declared at org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXARecoveryLogger */

package org.apache.activemq.artemis.service.extensions.xa.recovery;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(regexID="17[0-9]{4}", projectCode="AMQ")
public class ActiveMQXARecoveryLogger_impl implements ActiveMQXARecoveryLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQXARecoveryLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=171003, value=\"JMS Server Manager Running cached command for {}\", level=INFO)
   @Override
   public void serverRunningCachedCommand(java.lang.Runnable run) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ171003: JMS Server Manager Running cached command for {}", run);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=171004, value=\"JMS Server Manager Caching command for {} since the JMS Server is not active.\", level=INFO)
   @Override
   public void serverCachingCommand(java.lang.Object runnable) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ171004: JMS Server Manager Caching command for {} since the JMS Server is not active.", runnable);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172005, value=\"Invalid \\"host\\" value \\"0.0.0.0\\" detected for \\"{}\\" connector. Switching to \\"{}\\". If this new address is incorrect please manually configure the connector to use the proper one.\", level=WARN)
   @Override
   public void invalidHostForConnector(java.lang.String name, java.lang.String newHost) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172005: Invalid \"host\" value \"0.0.0.0\" detected for \"{}\" connector. Switching to \"{}\". If this new address is incorrect please manually configure the connector to use the proper one.", name, newHost);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172007, value=\"Queue {} does not exist on the topic {}. It was deleted manually probably.\", level=WARN)
   @Override
   public void noQueueOnTopic(java.lang.String queueName, java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172007: Queue {} does not exist on the topic {}. It was deleted manually probably.", queueName, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172008, value=\"XA Recovery can not connect to any broker on recovery {}\", level=WARN)
   @Override
   public void recoveryConnectFailed(java.lang.String s) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172008: XA Recovery can not connect to any broker on recovery {}", s);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172011, value=\"error unbinding {} from JNDI\", level=WARN)
   @Override
   public void jndiUnbindError(java.lang.String key, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172011: error unbinding {} from JNDI", key, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172012, value=\"JMS Server Manager error\", level=WARN)
   @Override
   public void jmsServerError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172012: JMS Server Manager error", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172013, value=\"Error in XA Recovery recover\", level=WARN)
   @Override
   public void xaRecoverError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172013: Error in XA Recovery recover", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172014, value=\"Notified of connection failure in xa recovery connectionFactory for provider {} will attempt reconnect on next pass\", level=WARN)
   @Override
   public void xaRecoverConnectionError(org.apache.activemq.artemis.api.core.client.ClientSessionFactory csf, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172014: Notified of connection failure in xa recovery connectionFactory for provider {} will attempt reconnect on next pass", csf, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172015, value=\"Can not connect to {} on auto-generated resource recovery\", level=WARN)
   @Override
   public void xaRecoverAutoConnectionError(org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig csf, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172015: Can not connect to {} on auto-generated resource recovery", csf, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172016, value=\"Error in XA Recovery\", level=DEBUG)
   @Override
   public void xaRecoveryError(java.lang.Exception e) {
      if (logger.isDebugEnabled()) {
         logger.debug("AMQ172016: Error in XA Recovery", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172017, value=\"Tried to correct invalid \\"host\\" value \\"0.0.0.0\\" for \\"{}\\" connector, but received an exception.\", level=WARN)
   @Override
   public void failedToCorrectHost(java.lang.String name, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172017: Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{}\" connector, but received an exception.", name, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=172018, value=\"Could not start recovery discovery on {}, we will retry every recovery scan until the server is available\", level=WARN)
   @Override
   public void xaRecoveryStartError(org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172018: Could not start recovery discovery on {}, we will retry every recovery scan until the server is available", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=174000, value=\"key attribute missing for JMS configuration {}\", level=ERROR)
   @Override
   public void jmsConfigMissingKey(org.w3c.dom.Node e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ174000: key attribute missing for JMS configuration {}", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=174002, value=\"Failed to start JMS deployer\", level=ERROR)
   @Override
   public void jmsDeployerStartError(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ174002: Failed to start JMS deployer", e);
      }
   }

}
