/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws.jetty8;

import java.io.IOException;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.ws.AbstractStompSocket;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompSocket
extends AbstractStompSocket
implements WebSocket.OnTextMessage {
    private static final Logger LOG = LoggerFactory.getLogger(StompSocket.class);
    private WebSocket.Connection outbound;

    public StompSocket(String remoteAddress) {
        super(remoteAddress);
    }

    @Override
    public void handleStopped() throws IOException {
        if (this.outbound != null && this.outbound.isOpen()) {
            this.outbound.close();
        }
    }

    @Override
    public void sendToStomp(StompFrame command) throws IOException {
        this.outbound.sendMessage(command.format());
    }

    public void onOpen(WebSocket.Connection connection) {
        this.outbound = connection;
    }

    public void onClose(int closeCode, String message) {
        try {
            this.protocolConverter.onStompCommand(new StompFrame("DISCONNECT"));
        }
        catch (Exception e) {
            LOG.warn("Failed to close WebSocket", (Throwable)e);
        }
    }

    public void onMessage(String data) {
        this.processStompFrame(data);
    }
}

