/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.protocol;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.ResponseHandler;
import org.apache.activemq.transport.amqp.message.ActiveMQJMSVendor;
import org.apache.activemq.transport.amqp.message.AutoOutboundTransformer;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.OutboundTransformer;
import org.apache.activemq.transport.amqp.protocol.AmqpAbstractLink;
import org.apache.activemq.transport.amqp.protocol.AmqpSession;
import org.apache.activemq.transport.amqp.protocol.AmqpTransferTagGenerator;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.fusesource.hawtbuf.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpSender
extends AmqpAbstractLink<Sender> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpSender.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final OutboundTransformer outboundTransformer = new AutoOutboundTransformer(ActiveMQJMSVendor.INSTANCE);
    private final AmqpTransferTagGenerator tagCache = new AmqpTransferTagGenerator();
    private final LinkedList<MessageDispatch> outbound = new LinkedList();
    private final LinkedList<MessageDispatch> dispatchedInTx = new LinkedList();
    private final String MESSAGE_FORMAT_KEY = this.outboundTransformer.getPrefixVendor() + "MESSAGE_FORMAT";
    private final ConsumerInfo consumerInfo;
    private final boolean presettle;
    private int currentCredit;
    private boolean draining;
    private long lastDeliveredSequenceId;
    private Buffer currentBuffer;
    private Delivery currentDelivery;

    public AmqpSender(AmqpSession session, Sender endpoint, ConsumerInfo consumerInfo) {
        super(session, endpoint);
        this.currentCredit = endpoint.getRemoteCredit();
        this.consumerInfo = consumerInfo;
        this.presettle = ((Sender)this.getEndpoint()).getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
    }

    @Override
    public void open() {
        if (!this.isClosed()) {
            this.session.registerSender(this.getConsumerId(), this);
        }
        super.open();
    }

    @Override
    public void detach() {
        if (!this.isClosed() && this.isOpened()) {
            RemoveInfo removeCommand = new RemoveInfo(this.getConsumerId());
            removeCommand.setLastDeliveredSequenceId(this.lastDeliveredSequenceId);
            this.sendToActiveMQ(removeCommand, null);
            this.session.unregisterSender(this.getConsumerId());
        }
        super.detach();
    }

    @Override
    public void close() {
        if (!this.isClosed() && this.isOpened()) {
            RemoveInfo removeCommand = new RemoveInfo(this.getConsumerId());
            removeCommand.setLastDeliveredSequenceId(this.lastDeliveredSequenceId);
            this.sendToActiveMQ(removeCommand, null);
            if (this.consumerInfo.isDurable()) {
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.session.getConnection().getConnectionId());
                rsi.setSubscriptionName(((Sender)this.getEndpoint()).getName());
                rsi.setClientId(this.session.getConnection().getClientId());
                this.sendToActiveMQ(rsi, null);
            }
            this.session.unregisterSender(this.getConsumerId());
        }
        super.close();
    }

    @Override
    public void flow() throws Exception {
        int updatedCredit = ((Sender)this.getEndpoint()).getCredit();
        LOG.trace("Flow: drain={} credit={}, remoteCredit={}", new Object[]{((Sender)this.getEndpoint()).getDrain(), ((Sender)this.getEndpoint()).getCredit(), ((Sender)this.getEndpoint()).getRemoteCredit()});
        if (((Sender)this.getEndpoint()).getDrain() && (updatedCredit != this.currentCredit || !this.draining)) {
            this.currentCredit = updatedCredit >= 0 ? updatedCredit : 0;
            this.draining = true;
            ConsumerControl control = new ConsumerControl();
            control.setConsumerId(this.getConsumerId());
            control.setDestination(this.getDestination());
            control.setPrefetch(0);
            this.sendToActiveMQ(control, null);
            MessagePull pullRequest = new MessagePull();
            pullRequest.setConsumerId(this.getConsumerId());
            pullRequest.setDestination(this.getDestination());
            pullRequest.setTimeout(-1L);
            pullRequest.setAlwaysSignalDone(true);
            pullRequest.setQuantity(this.currentCredit);
            this.sendToActiveMQ(pullRequest, null);
        } else if (updatedCredit != this.currentCredit) {
            this.currentCredit = updatedCredit >= 0 ? updatedCredit : 0;
            ConsumerControl control = new ConsumerControl();
            control.setConsumerId(this.getConsumerId());
            control.setDestination(this.getDestination());
            control.setPrefetch(this.currentCredit);
            this.sendToActiveMQ(control, null);
        }
    }

    @Override
    public void delivery(Delivery delivery) throws Exception {
        MessageDispatch md = (MessageDispatch)delivery.getContext();
        DeliveryState state = delivery.getRemoteState();
        if (state instanceof TransactionalState) {
            Outcome outcome;
            TransactionalState txState = (TransactionalState)state;
            LOG.trace("onDelivery: TX delivery state = {}", (Object)state);
            if (txState.getOutcome() != null && (outcome = txState.getOutcome()) instanceof Accepted) {
                if (!delivery.remotelySettled()) {
                    TransactionalState txAccepted = new TransactionalState();
                    txAccepted.setOutcome(Accepted.getInstance());
                    txAccepted.setTxnId(((TransactionalState)state).getTxnId());
                    delivery.disposition(txAccepted);
                }
                this.settle(delivery, 0);
            }
        } else if (state instanceof Accepted) {
            LOG.trace("onDelivery: accepted state = {}", (Object)state);
            if (!delivery.remotelySettled()) {
                delivery.disposition(new Accepted());
            }
            this.settle(delivery, 4);
        } else if (state instanceof Rejected) {
            md.setRedeliveryCounter(md.getRedeliveryCounter() + 1);
            LOG.trace("onDelivery: Rejected state = {}, delivery count now {}", (Object)state, (Object)md.getRedeliveryCounter());
            this.settle(delivery, -1);
        } else if (state instanceof Released) {
            LOG.trace("onDelivery: Released state = {}", (Object)state);
            this.settle(delivery, -1);
        } else if (state instanceof Modified) {
            Modified modified = (Modified)state;
            if (Boolean.TRUE.equals(modified.getDeliveryFailed())) {
                md.setRedeliveryCounter(md.getRedeliveryCounter() + 1);
            }
            LOG.trace("onDelivery: Modified state = {}, delivery count now {}", (Object)state, (Object)md.getRedeliveryCounter());
            int ackType = -1;
            Boolean undeliverableHere = modified.getUndeliverableHere();
            if (undeliverableHere != null && undeliverableHere.booleanValue()) {
                ackType = 1;
            }
            this.settle(delivery, ackType);
        }
        this.pumpOutbound();
    }

    @Override
    public void commit() throws Exception {
        if (!this.dispatchedInTx.isEmpty()) {
            for (MessageDispatch md : this.dispatchedInTx) {
                MessageAck pendingTxAck = new MessageAck(md, 4, 1);
                pendingTxAck.setFirstMessageId(md.getMessage().getMessageId());
                pendingTxAck.setTransactionId(md.getMessage().getTransactionId());
                LOG.trace("Sending commit Ack to ActiveMQ: {}", (Object)pendingTxAck);
                this.sendToActiveMQ(pendingTxAck, new ResponseHandler(){

                    @Override
                    public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                        if (response.isException() && response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            exception.printStackTrace();
                            ((Sender)AmqpSender.this.getEndpoint()).close();
                        }
                        AmqpSender.this.session.pumpProtonToSocket();
                    }
                });
            }
            this.dispatchedInTx.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws Exception {
        LinkedList<MessageDispatch> linkedList = this.outbound;
        synchronized (linkedList) {
            LOG.trace("Rolling back {} messages for redelivery. ", (Object)this.dispatchedInTx.size());
            for (MessageDispatch dispatch : this.dispatchedInTx) {
                dispatch.setRedeliveryCounter(dispatch.getRedeliveryCounter() + 1);
                dispatch.getMessage().setTransactionId(null);
                this.outbound.addFirst(dispatch);
            }
            this.dispatchedInTx.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageDispatch(MessageDispatch dispatch) throws Exception {
        if (!this.isClosed()) {
            LinkedList<MessageDispatch> linkedList = this.outbound;
            synchronized (linkedList) {
                this.outbound.addLast(dispatch);
            }
            this.pumpOutbound();
            this.session.pumpProtonToSocket();
        }
    }

    public void onConsumerControl(ConsumerControl control) {
        if (control.isClose()) {
            this.close(new ErrorCondition(AmqpError.INTERNAL_ERROR, "Receiver forcably closed"));
            this.session.pumpProtonToSocket();
        }
    }

    public String toString() {
        return "AmqpSender {" + this.getConsumerId() + "}";
    }

    public ConsumerId getConsumerId() {
        return this.consumerInfo.getConsumerId();
    }

    @Override
    public ActiveMQDestination getDestination() {
        return this.consumerInfo.getDestination();
    }

    @Override
    public void setDestination(ActiveMQDestination destination) {
        this.consumerInfo.setDestination(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pumpOutbound() throws Exception {
        while (!this.isClosed()) {
            while (this.currentBuffer != null) {
                int sent = ((Sender)this.getEndpoint()).send(this.currentBuffer.data, this.currentBuffer.offset, this.currentBuffer.length);
                if (sent > 0) {
                    this.currentBuffer.moveHead(sent);
                    if (this.currentBuffer.length != 0) continue;
                    if (this.presettle) {
                        this.settle(this.currentDelivery, 4);
                    } else {
                        ((Sender)this.getEndpoint()).advance();
                    }
                    this.currentBuffer = null;
                    this.currentDelivery = null;
                    continue;
                }
                return;
            }
            if (this.outbound.isEmpty()) {
                return;
            }
            MessageDispatch md = this.outbound.removeFirst();
            try {
                ActiveMQMessage jms;
                ActiveMQMessage temp = null;
                if (md.getMessage() != null) {
                    if (md.getDestination().isTopic()) {
                        Message message = md.getMessage();
                        synchronized (message) {
                            temp = (ActiveMQMessage)md.getMessage().copy();
                        }
                    } else {
                        temp = (ActiveMQMessage)md.getMessage();
                    }
                    if (!temp.getProperties().containsKey(this.MESSAGE_FORMAT_KEY)) {
                        temp.setProperty(this.MESSAGE_FORMAT_KEY, 0);
                    }
                }
                if ((jms = temp) == null) {
                    LOG.trace("Sender:[{}] browse done.", (Object)((Sender)this.getEndpoint()).getName());
                    ((Sender)this.getEndpoint()).drained();
                    this.draining = false;
                    this.currentCredit = 0;
                    continue;
                }
                jms.setRedeliveryCounter(md.getRedeliveryCounter());
                jms.setReadOnlyBody(true);
                EncodedMessage amqp = this.outboundTransformer.transform(jms);
                if (amqp == null || amqp.getLength() <= 0) continue;
                this.currentBuffer = new Buffer(amqp.getArray(), amqp.getArrayOffset(), amqp.getLength());
                if (this.presettle) {
                    this.currentDelivery = ((Sender)this.getEndpoint()).delivery(EMPTY_BYTE_ARRAY, 0, 0);
                } else {
                    byte[] tag = this.tagCache.getNextTag();
                    this.currentDelivery = ((Sender)this.getEndpoint()).delivery(tag, 0, tag.length);
                }
                this.currentDelivery.setContext(md);
            }
            catch (Exception e) {
                LOG.warn("Error detected while flushing outbound messages: {}", (Object)e.getMessage());
            }
        }
    }

    private void settle(final Delivery delivery, int ackType) throws Exception {
        byte[] tag = delivery.getTag();
        if (tag != null && tag.length > 0 && delivery.remotelySettled()) {
            this.tagCache.returnTag(tag);
        }
        if (ackType == -1) {
            delivery.settle();
            this.onMessageDispatch((MessageDispatch)delivery.getContext());
        } else {
            MessageDispatch md = (MessageDispatch)delivery.getContext();
            this.lastDeliveredSequenceId = md.getMessage().getMessageId().getBrokerSequenceId();
            MessageAck ack = new MessageAck();
            ack.setConsumerId(this.getConsumerId());
            ack.setFirstMessageId(md.getMessage().getMessageId());
            ack.setLastMessageId(md.getMessage().getMessageId());
            ack.setMessageCount(1);
            ack.setAckType((byte)ackType);
            ack.setDestination(md.getDestination());
            DeliveryState remoteState = delivery.getRemoteState();
            if (remoteState != null && remoteState instanceof TransactionalState) {
                TransactionalState txState = (TransactionalState)remoteState;
                LocalTransactionId txId = new LocalTransactionId(this.session.getConnection().getConnectionId(), AmqpSupport.toLong(txState.getTxnId()));
                ack.setTransactionId(txId);
                this.session.enlist(txId);
                md.getMessage().setTransactionId(txId);
                this.dispatchedInTx.addFirst(md);
            }
            LOG.trace("Sending Ack to ActiveMQ: {}", (Object)ack);
            this.sendToActiveMQ(ack, new ResponseHandler(){

                @Override
                public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            exception.printStackTrace();
                            ((Sender)AmqpSender.this.getEndpoint()).close();
                        }
                    } else {
                        delivery.settle();
                    }
                    AmqpSender.this.session.pumpProtonToSocket();
                }
            });
        }
    }
}

