/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.com.github.benmanes.caffeine.cache.Cache;
import org.apache.camel.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.camel.com.github.benmanes.caffeine.cache.RemovalCause;
import org.apache.camel.com.github.benmanes.caffeine.cache.RemovalListener;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCache<K, V>
implements Map<K, V>,
RemovalListener<K, V>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(LRUCache.class);
    protected final AtomicLong hits = new AtomicLong();
    protected final AtomicLong misses = new AtomicLong();
    protected final AtomicLong evicted = new AtomicLong();
    private int maxCacheSize = 10000;
    private boolean stopOnEviction;
    private final Cache<K, V> cache;
    private final Map<K, V> map;

    public LRUCache(int maximumCacheSize) {
        this(16, maximumCacheSize);
    }

    public LRUCache(int initialCapacity, int maximumCacheSize) {
        this(initialCapacity, maximumCacheSize, maximumCacheSize > 0);
    }

    public LRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        this(initialCapacity, maximumCacheSize, stopOnEviction, false, false, false);
    }

    public LRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction, boolean soft, boolean weak, boolean syncListener) {
        Caffeine caffeine = Caffeine.newBuilder().initialCapacity(initialCapacity).maximumSize(maximumCacheSize).removalListener(this);
        if (soft) {
            caffeine.softValues();
        }
        if (weak) {
            caffeine.weakKeys();
            caffeine.weakValues();
        }
        if (syncListener) {
            caffeine.executor(Runnable::run);
        }
        this.cache = caffeine.build();
        this.map = this.cache.asMap();
        this.maxCacheSize = maximumCacheSize;
        this.stopOnEviction = stopOnEviction;
    }

    @Override
    public V get(Object o) {
        V answer = this.map.get(o);
        if (answer != null) {
            this.hits.incrementAndGet();
        } else {
            this.misses.incrementAndGet();
        }
        return answer;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(0);
    }

    @Override
    public V put(K k, V v) {
        return this.map.put(k, v);
    }

    @Override
    public V remove(Object o) {
        return this.map.remove(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.cache.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.resetStatistics();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void onRemoval(K key, V value, RemovalCause cause) {
        if (cause.wasEvicted()) {
            this.evicted.incrementAndGet();
            LOG.trace("onRemoval {} -> {}", (Object)key, (Object)value);
            if (this.stopOnEviction) {
                try {
                    ServiceHelper.stopService(value);
                }
                catch (Exception e) {
                    LOG.warn("Error stopping service: " + value + ". This exception will be ignored.", e);
                }
            }
        }
    }

    public long getHits() {
        return this.hits.get();
    }

    public long getMisses() {
        return this.misses.get();
    }

    public long getEvicted() {
        return this.evicted.get();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void resetStatistics() {
        this.hits.set(0L);
        this.misses.set(0L);
        this.evicted.set(0L);
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    public String toString() {
        return "LRUCache@" + ObjectHelper.getIdentityHashCode(this);
    }
}

