/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.concurrent.CountDownLatch;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncProcessorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncProcessorHelper.class);

    private AsyncProcessorHelper() {
    }

    @Deprecated
    public static boolean process(AsyncProcessor processor, Exchange exchange, AsyncCallback callback) {
        boolean sync;
        if (exchange.isTransacted()) {
            LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            try {
                AsyncProcessorHelper.process(processor, exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            sync = true;
        } else {
            UnitOfWork uow = exchange.getUnitOfWork();
            AsyncCallback async = callback;
            if (uow != null) {
                async = uow.beforeProcess(processor, exchange, callback);
            }
            sync = processor.process(exchange, async);
            if (uow != null) {
                uow.afterProcess(processor, exchange, callback, sync);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exchange processed and is continued routed {} for exchangeId: {} -> {}", sync ? "synchronously" : "asynchronously", exchange.getExchangeId(), exchange);
        }
        return sync;
    }

    public static void process(AsyncProcessor processor, final Exchange exchange) throws Exception {
        CountDownLatch latch;
        final AsyncProcessorAwaitManager awaitManager = exchange.getContext().getAsyncProcessorAwaitManager();
        boolean sync = processor.process(exchange, new AsyncCallback(latch = new CountDownLatch(1), processor){
            final /* synthetic */ CountDownLatch val$latch;
            final /* synthetic */ AsyncProcessor val$processor;
            {
                this.val$latch = countDownLatch;
                this.val$processor = asyncProcessor;
            }

            @Override
            public void done(boolean doneSync) {
                if (!doneSync) {
                    awaitManager.countDown(exchange, this.val$latch);
                }
            }

            public String toString() {
                return "Done " + this.val$processor;
            }
        });
        if (!sync) {
            awaitManager.await(exchange, latch);
        }
    }
}

