/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class StompHeaders
implements MultiValueMap<String, String>,
Serializable {
    private static final long serialVersionUID = 7514642206528452544L;
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_LENGTH = "content-length";
    public static final String RECEIPT = "receipt";
    public static final String HOST = "host";
    public static final String LOGIN = "login";
    public static final String PASSCODE = "passcode";
    public static final String HEARTBEAT = "heart-beat";
    public static final String SESSION = "session";
    public static final String SERVER = "server";
    public static final String DESTINATION = "destination";
    public static final String ID = "id";
    public static final String ACK = "ack";
    public static final String SUBSCRIPTION = "subscription";
    public static final String MESSAGE_ID = "message-id";
    public static final String RECEIPT_ID = "receipt-id";
    private final Map<String, List<String>> headers;

    public StompHeaders() {
        this(new LinkedMultiValueMap<String, String>(4), false);
    }

    private StompHeaders(Map<String, List<String>> headers, boolean readOnly) {
        Assert.notNull(headers, "'headers' must not be null");
        if (readOnly) {
            LinkedMultiValueMap<String, List<String>> map = new LinkedMultiValueMap<String, List<String>>(headers.size());
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                List<String> values = Collections.unmodifiableList(entry.getValue());
                map.put(entry.getKey(), values);
            }
            this.headers = Collections.unmodifiableMap(map);
        } else {
            this.headers = headers;
        }
    }

    public void setContentType(MimeType mimeType) {
        Assert.isTrue(!mimeType.isWildcardType(), "'Content-Type' cannot contain wildcard type '*'");
        Assert.isTrue(!mimeType.isWildcardSubtype(), "'Content-Type' cannot contain wildcard subtype '*'");
        this.set(CONTENT_TYPE, mimeType.toString());
    }

    public MimeType getContentType() {
        String value = this.getFirst(CONTENT_TYPE);
        return StringUtils.hasLength(value) ? MimeTypeUtils.parseMimeType(value) : null;
    }

    public void setContentLength(long contentLength) {
        this.set(CONTENT_LENGTH, Long.toString(contentLength));
    }

    public long getContentLength() {
        String value = this.getFirst(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setReceipt(String receipt) {
        this.set(RECEIPT, receipt);
    }

    public String getReceipt() {
        return this.getFirst(RECEIPT);
    }

    public void setHost(String host) {
        this.set(HOST, host);
    }

    public String getHost() {
        return this.getFirst(HOST);
    }

    public void setLogin(String login) {
        this.set(LOGIN, login);
    }

    public String getLogin() {
        return this.getFirst(LOGIN);
    }

    public void setPasscode(String passcode) {
        this.set(PASSCODE, passcode);
    }

    public String getPasscode() {
        return this.getFirst(PASSCODE);
    }

    public void setHeartbeat(long[] heartbeat) {
        if (heartbeat == null || heartbeat.length != 2) {
            throw new IllegalArgumentException("Heart-beat array must be of length 2, not " + (heartbeat != null ? Integer.valueOf(heartbeat.length) : "null"));
        }
        String value = heartbeat[0] + "," + heartbeat[1];
        if (heartbeat[0] < 0L || heartbeat[1] < 0L) {
            throw new IllegalArgumentException("Heart-beat values cannot be negative: " + value);
        }
        this.set(HEARTBEAT, value);
    }

    public long[] getHeartbeat() {
        String rawValue = this.getFirst(HEARTBEAT);
        String[] rawValues = StringUtils.split(rawValue, ",");
        if (rawValues == null) {
            return null;
        }
        return new long[]{Long.valueOf(rawValues[0]), Long.valueOf(rawValues[1])};
    }

    public boolean isHeartbeatEnabled() {
        long[] heartbeat = this.getHeartbeat();
        return heartbeat != null && heartbeat[0] != 0L && heartbeat[1] != 0L;
    }

    public void setSession(String session) {
        this.set(SESSION, session);
    }

    public String getSession() {
        return this.getFirst(SESSION);
    }

    public void setServer(String server) {
        this.set(SERVER, server);
    }

    public String getServer() {
        return this.getFirst(SERVER);
    }

    public void setDestination(String destination) {
        this.set(DESTINATION, destination);
    }

    public String getDestination() {
        return this.getFirst(DESTINATION);
    }

    public void setId(String id) {
        this.set(ID, id);
    }

    public String getId() {
        return this.getFirst(ID);
    }

    public void setAck(String ack) {
        this.set(ACK, ack);
    }

    public String getAck() {
        return this.getFirst(ACK);
    }

    public void setSubscription(String subscription) {
        this.set(SUBSCRIPTION, subscription);
    }

    public String getSubscription() {
        return this.getFirst(SUBSCRIPTION);
    }

    public void setMessageId(String messageId) {
        this.set(MESSAGE_ID, messageId);
    }

    public String getMessageId() {
        return this.getFirst(MESSAGE_ID);
    }

    public void setReceiptId(String receiptId) {
        this.set(RECEIPT_ID, receiptId);
    }

    public String getReceiptId() {
        return this.getFirst(RECEIPT_ID);
    }

    @Override
    public String getFirst(String headerName) {
        List<String> headerValues = this.headers.get(headerName);
        return headerValues != null ? headerValues.get(0) : null;
    }

    @Override
    public void add(String headerName, String headerValue) {
        List<String> headerValues = this.headers.get(headerName);
        if (headerValues == null) {
            headerValues = new LinkedList<String>();
            this.headers.put(headerName, headerValues);
        }
        headerValues.add(headerValue);
    }

    @Override
    public void set(String headerName, String headerValue) {
        LinkedList<String> headerValues = new LinkedList<String>();
        headerValues.add(headerValue);
        this.headers.put(headerName, headerValues);
    }

    @Override
    public void setAll(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = new LinkedHashMap<String, String>(this.headers.size());
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            singleValueMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    public List<String> get(Object key) {
        return this.headers.get(key);
    }

    @Override
    public List<String> put(String key, List<String> value) {
        return this.headers.put(key, value);
    }

    @Override
    public List<String> remove(Object key) {
        return this.headers.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        this.headers.putAll(map);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.headers.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof StompHeaders && this.headers.equals(((StompHeaders)other).headers);
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return this.headers.toString();
    }

    public static StompHeaders readOnlyStompHeaders(Map<String, List<String>> headers) {
        return new StompHeaders(headers, true);
    }
}

