/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.IsSingleton;
import org.apache.camel.PollingConsumerPollingStrategy;
import org.apache.camel.Processor;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDrivenPollingConsumer
extends PollingConsumerSupport
implements Processor,
IsSingleton {
    private static final Logger LOG = LoggerFactory.getLogger(EventDrivenPollingConsumer.class);
    private final BlockingQueue<Exchange> queue;
    private ExceptionHandler interruptedExceptionHandler;
    private Consumer consumer;
    private boolean blockWhenFull = true;
    private long blockTimeout;
    private final int queueCapacity;

    public EventDrivenPollingConsumer(Endpoint endpoint) {
        this(endpoint, 1000);
    }

    public EventDrivenPollingConsumer(Endpoint endpoint, int queueSize) {
        super(endpoint);
        this.queueCapacity = queueSize;
        this.queue = queueSize <= 0 ? new LinkedBlockingQueue<Exchange>() : new ArrayBlockingQueue<Exchange>(queueSize);
        this.interruptedExceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), EventDrivenPollingConsumer.class);
    }

    public EventDrivenPollingConsumer(Endpoint endpoint, BlockingQueue<Exchange> queue2) {
        super(endpoint);
        this.queue = queue2;
        this.queueCapacity = queue2.remainingCapacity();
        this.interruptedExceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), EventDrivenPollingConsumer.class);
    }

    public boolean isBlockWhenFull() {
        return this.blockWhenFull;
    }

    public void setBlockWhenFull(boolean blockWhenFull) {
        this.blockWhenFull = blockWhenFull;
    }

    public long getBlockTimeout() {
        return this.blockTimeout;
    }

    public void setBlockTimeout(long blockTimeout) {
        this.blockTimeout = blockTimeout;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public Exchange receiveNoWait() {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exchange receive() {
        if (!this.isRunAllowed() || !this.isStarted()) {
            throw new RejectedExecutionException(this + " is not started, but in state: " + this.getStatus().name());
        }
        while (this.isRunAllowed()) {
            EventDrivenPollingConsumer eventDrivenPollingConsumer = this;
            synchronized (eventDrivenPollingConsumer) {
                Exchange exchange;
                try {
                    this.beforePoll(0L);
                    exchange = this.queue.take();
                    this.afterPoll();
                }
                catch (InterruptedException e) {
                    try {
                        this.handleInterruptedException(e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.afterPoll();
                    }
                    continue;
                }
                return exchange;
            }
        }
        LOG.trace("Consumer is not running, so returning null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exchange receive(long timeout) {
        if (!this.isRunAllowed() || !this.isStarted()) {
            throw new RejectedExecutionException(this + " is not started, but in state: " + this.getStatus().name());
        }
        EventDrivenPollingConsumer eventDrivenPollingConsumer = this;
        synchronized (eventDrivenPollingConsumer) {
            Exchange exchange;
            try {
                timeout = this.beforePoll(timeout);
                exchange = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
                this.afterPoll();
            }
            catch (InterruptedException e) {
                Exchange exchange2;
                try {
                    this.handleInterruptedException(e);
                    exchange2 = null;
                    this.afterPoll();
                }
                catch (Throwable throwable) {
                    this.afterPoll();
                    throw throwable;
                }
                return exchange2;
            }
            return exchange;
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.isBlockWhenFull()) {
            try {
                if (this.getBlockTimeout() <= 0L) {
                    this.queue.put(exchange);
                } else {
                    boolean added = this.queue.offer(exchange, this.getBlockTimeout(), TimeUnit.MILLISECONDS);
                    if (!added) {
                        throw new ExchangeTimedOutException(exchange, this.getBlockTimeout());
                    }
                }
            }
            catch (InterruptedException e) {
                this.log.debug("Put interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
            }
        } else {
            this.queue.add(exchange);
        }
    }

    public ExceptionHandler getInterruptedExceptionHandler() {
        return this.interruptedExceptionHandler;
    }

    public void setInterruptedExceptionHandler(ExceptionHandler interruptedExceptionHandler) {
        this.interruptedExceptionHandler = interruptedExceptionHandler;
    }

    public Consumer getDelegateConsumer() {
        return this.consumer;
    }

    protected void handleInterruptedException(InterruptedException e) {
        this.getInterruptedExceptionHandler().handleException(e);
    }

    protected long beforePoll(long timeout) {
        if (this.consumer instanceof PollingConsumerPollingStrategy) {
            PollingConsumerPollingStrategy strategy = (PollingConsumerPollingStrategy)((Object)this.consumer);
            try {
                timeout = strategy.beforePoll(timeout);
            }
            catch (Exception e) {
                LOG.debug("Error occurred before polling " + this.consumer + ". This exception will be ignored.", e);
            }
        }
        return timeout;
    }

    protected void afterPoll() {
        if (this.consumer instanceof PollingConsumerPollingStrategy) {
            PollingConsumerPollingStrategy strategy = (PollingConsumerPollingStrategy)((Object)this.consumer);
            try {
                strategy.afterPoll();
            }
            catch (Exception e) {
                LOG.debug("Error occurred after polling " + this.consumer + ". This exception will be ignored.", e);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.consumer = this.getEndpoint().createConsumer(this);
        if (this.consumer instanceof PollingConsumerPollingStrategy) {
            PollingConsumerPollingStrategy strategy = (PollingConsumerPollingStrategy)((Object)this.consumer);
            strategy.onInit();
        } else {
            ServiceHelper.startService(this.consumer);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.consumer);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.consumer);
        this.queue.clear();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

