/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaEndpoint;

public final class QueueReference {
    private final BlockingQueue<Exchange> queue;
    private Integer size;
    private Boolean multipleConsumers;
    private List<SedaEndpoint> endpoints = new LinkedList<SedaEndpoint>();

    QueueReference(BlockingQueue<Exchange> queue2, Integer size2, Boolean multipleConsumers) {
        this.queue = queue2;
        this.size = size2;
        this.multipleConsumers = multipleConsumers;
    }

    synchronized void addReference(SedaEndpoint endpoint) {
        if (!this.endpoints.contains(endpoint)) {
            this.endpoints.add(endpoint);
            if (endpoint.isMultipleConsumers()) {
                this.multipleConsumers = true;
            }
        }
    }

    synchronized void removeReference(SedaEndpoint endpoint) {
        if (this.endpoints.contains(endpoint)) {
            this.endpoints.remove(endpoint);
        }
    }

    public synchronized int getCount() {
        return this.endpoints.size();
    }

    public Integer getSize() {
        return this.size;
    }

    public Boolean getMultipleConsumers() {
        return this.multipleConsumers;
    }

    public BlockingQueue<Exchange> getQueue() {
        return this.queue;
    }

    public synchronized boolean hasConsumers() {
        for (SedaEndpoint endpoint : this.endpoints) {
            if (endpoint.getConsumers().size() <= 0) continue;
            return true;
        }
        return false;
    }
}

