/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.component.jms.reply.CorrelationListener;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.support.DefaultTimeoutMap;

public class CorrelationTimeoutMap
extends DefaultTimeoutMap<String, ReplyHandler> {
    private CorrelationListener listener;

    public CorrelationTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
        super(executor, requestMapPollTimeMillis);
    }

    public void setListener(CorrelationListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean onEviction(String key, ReplyHandler value) {
        try {
            if (this.listener != null) {
                this.listener.onEviction(key);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            value.onTimeout(key);
        }
        catch (Throwable e) {
            this.log.warn("Error processing onTimeout for correlationID: " + key + " due: " + e.getMessage() + ". This exception is ignored.", e);
        }
        this.log.trace("Evicted correlationID: {}", (Object)key);
        return true;
    }

    @Override
    public ReplyHandler get(String key) {
        ReplyHandler answer = (ReplyHandler)super.get(key);
        this.log.trace("Get correlationID: {} -> {}", (Object)key, (Object)(answer != null ? 1 : 0));
        return answer;
    }

    @Override
    public ReplyHandler put(String key, ReplyHandler value, long timeoutMillis) {
        try {
            if (this.listener != null) {
                this.listener.onPut(key);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ReplyHandler result = timeoutMillis <= 0L ? super.put(key, value, Integer.MAX_VALUE) : super.put(key, value, timeoutMillis);
        this.log.trace("Added correlationID: {} to timeout after: {} millis", (Object)key, (Object)timeoutMillis);
        return result;
    }

    @Override
    public ReplyHandler putIfAbsent(String key, ReplyHandler value, long timeoutMillis) {
        try {
            if (this.listener != null) {
                this.listener.onPut(key);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ReplyHandler result = timeoutMillis <= 0L ? super.putIfAbsent(key, value, Integer.MAX_VALUE) : super.putIfAbsent(key, value, timeoutMillis);
        if (result == null) {
            this.log.trace("Added correlationID: {} to timeout after: {} millis", (Object)key, (Object)timeoutMillis);
        } else {
            this.log.trace("Duplicate correlationID: {} detected", (Object)key);
        }
        return result;
    }

    @Override
    public ReplyHandler remove(String key) {
        try {
            if (this.listener != null) {
                this.listener.onRemove(key);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ReplyHandler answer = (ReplyHandler)super.remove(key);
        this.log.trace("Removed correlationID: {} -> {}", (Object)key, (Object)(answer != null ? 1 : 0));
        return answer;
    }
}

