/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws.jetty9;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.activemq.transport.ws.AbstractMQTTSocket;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.fusesource.mqtt.codec.DISCONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSocket
extends AbstractMQTTSocket
implements WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTSocket.class);
    private Session session;

    public MQTTSocket(String remoteAddress) {
        super(remoteAddress);
    }

    @Override
    public void sendToMQTT(MQTTFrame command) throws IOException {
        ByteSequence bytes = this.wireFormat.marshal(command);
        this.session.getRemote().sendBytes(ByteBuffer.wrap(bytes.getData(), 0, bytes.getLength()));
    }

    @Override
    public void handleStopped() throws IOException {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
    }

    public void onWebSocketBinary(byte[] bytes, int offset, int length) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for MQTTSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for MQTTSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        this.receiveCounter += length;
        try {
            MQTTFrame frame = (MQTTFrame)this.wireFormat.unmarshal(new ByteSequence(bytes, offset, length));
            this.getProtocolConverter().onMQTTCommand(frame);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    public void onWebSocketClose(int arg0, String arg1) {
        try {
            this.getProtocolConverter().onMQTTCommand(new DISCONNECT().encode());
        }
        catch (Exception e) {
            LOG.warn("Failed to close WebSocket", e);
        }
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
    }

    public void onWebSocketError(Throwable arg0) {
    }

    public void onWebSocketText(String arg0) {
    }
}

