/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.rpc;

import alluxio.stress.BaseParameters;
import alluxio.stress.GraphGenerator;
import alluxio.stress.Summary;
import alluxio.stress.rpc.RpcBenchParameters;
import alluxio.stress.rpc.RpcTaskResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.math.Quantiles;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class RpcTaskSummary
implements Summary {
    private List<RpcTaskResult.Point> mPoints;
    private List<String> mErrors;
    private BaseParameters mBaseParameters;
    private RpcBenchParameters mParameters;
    public long mCount;
    public long mTotalDurationMs;
    public double mAvgDurationMs;
    public double mPercentile5th;
    public double mPercentile25th;
    public double mMedian;
    public double mPercentile75th;
    public double mPercentile95th;

    @JsonCreator
    public RpcTaskSummary() {
    }

    public RpcTaskSummary(RpcTaskResult r) {
        this.mParameters = r.getParameters();
        this.mBaseParameters = r.getBaseParameters();
        this.mErrors = r.getErrors();
        this.mPoints = r.getPoints();
        this.mCount = this.mPoints.size();
        this.calculate();
    }

    private void calculate() {
        if (this.mPoints.isEmpty()) {
            return;
        }
        for (RpcTaskResult.Point p : this.mPoints) {
            this.mTotalDurationMs += p.mDurationMs;
        }
        this.mAvgDurationMs = this.mCount == 0L ? 0.0 : (double)this.mTotalDurationMs / (double)this.mCount;
        Map<Integer, Double> percentiles = this.getPercentiles(5, 25, 50, 75, 95);
        this.mPercentile5th = percentiles.get(5);
        this.mPercentile25th = percentiles.get(25);
        this.mMedian = percentiles.get(50);
        this.mPercentile75th = percentiles.get(75);
        this.mPercentile95th = percentiles.get(95);
    }

    @Override
    public GraphGenerator graphGenerator() {
        return null;
    }

    public String toString() {
        if (this.mPoints.isEmpty()) {
            return String.format("RpcTaskSummary:%nNo data points%nErrors: %s%n", this.mErrors);
        }
        return String.format("RpcTaskSummary: Data points: %d, Errors: %d%nTotal: %.3e, Average: %.3e, Median: %.3e%n5 Percentile: %.3e%n25 Percentile: %.3e%n75 Percentile: %.3e%n95 Percentile: %.3e%n", this.mPoints.size(), this.mErrors.size(), (double)this.mTotalDurationMs, this.mAvgDurationMs, this.mMedian, this.mPercentile5th, this.mPercentile25th, this.mPercentile75th, this.mPercentile95th);
    }

    public Map<Integer, Double> getPercentiles(int ... indices) {
        indices = Arrays.stream(indices).map(index -> Math.max(0, Math.min(100, index))).toArray();
        return Quantiles.percentiles().indexes(indices).compute((Collection)this.mPoints.stream().map(p -> p.mDurationMs).collect(Collectors.toList()));
    }

    public List<RpcTaskResult.Point> getPoints() {
        return this.mPoints;
    }

    public void setPoints(List<RpcTaskResult.Point> points) {
        this.mPoints = points;
    }

    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    @Nullable
    public RpcBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(RpcBenchParameters parameters) {
        this.mParameters = parameters;
    }
}

