/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.rpc;

import alluxio.stress.BaseParameters;
import alluxio.stress.Summary;
import alluxio.stress.TaskResult;
import alluxio.stress.rpc.RpcBenchParameters;
import alluxio.stress.rpc.RpcTaskSummary;
import alluxio.util.JsonSerializable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class RpcTaskResult
implements TaskResult {
    private List<Point> mPoints;
    private List<String> mErrors;
    private BaseParameters mBaseParameters;
    private RpcBenchParameters mParameters;

    public RpcTaskResult() {
        this.mPoints = new ArrayList<Point>();
        this.mErrors = new ArrayList<String>();
    }

    public RpcTaskResult(BaseParameters baseParameters, RpcBenchParameters rpcBenchParameters) {
        this.mPoints = new ArrayList<Point>();
        this.mErrors = new ArrayList<String>();
        this.mBaseParameters = baseParameters;
        this.mParameters = rpcBenchParameters;
    }

    public RpcTaskResult(RpcTaskResult source) {
        this.mPoints = source.mPoints;
        this.mErrors = source.mErrors;
        this.mBaseParameters = source.mBaseParameters;
        this.mParameters = source.mParameters;
    }

    @Override
    @Nullable
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    @Nullable
    public RpcBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(RpcBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public void addError(String errorMsg) {
        this.mErrors.add(errorMsg);
    }

    @Override
    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public void addPoint(Point p) {
        this.mPoints.add(p);
    }

    public List<Point> getPoints() {
        return this.mPoints;
    }

    public void setPoints(List<Point> points) {
        this.mPoints = points;
    }

    @Override
    public Aggregator aggregator() {
        return new Aggregator();
    }

    public void merge(RpcTaskResult r) {
        this.mErrors.addAll(r.mErrors);
        this.mPoints.addAll(r.mPoints);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mPoints", this.mPoints).add("mErrors", this.mErrors).toString();
    }

    public static class Point
    implements JsonSerializable {
        @JsonProperty(value="duration")
        public long mDurationMs;

        @JsonCreator
        public Point(@JsonProperty(value="duration") long ms) {
            this.mDurationMs = ms;
        }

        public String toString() {
            return String.format("Point: {duration: %sms}", this.mDurationMs);
        }
    }

    public static final class Aggregator
    implements TaskResult.Aggregator<RpcTaskResult> {
        @Override
        public Summary aggregate(Iterable<RpcTaskResult> results) throws Exception {
            return new RpcTaskSummary(Aggregator.reduceList(results));
        }

        public static RpcTaskResult reduceList(Iterable<RpcTaskResult> results) {
            Iterator<RpcTaskResult> iterator = results.iterator();
            if (!iterator.hasNext()) {
                return new RpcTaskResult();
            }
            RpcTaskResult aggreResult = new RpcTaskResult(iterator.next());
            while (iterator.hasNext()) {
                aggreResult.merge(iterator.next());
            }
            return aggreResult;
        }
    }
}

