/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.autodeployment;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class FailOnNoProcessAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FailOnNoProcessAutoDeploymentStrategy.class);
    public static final String DEPLOYMENT_MODE = "fail-on-no-process";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, RepositoryService repositoryService) {
        DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentNameHint);
        int validProcessCount = 0;
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            if (this.validateModel(resource, repositoryService)) {
                ++validProcessCount;
                deploymentBuilder.addInputStream(resourceName, resource);
                continue;
            }
            LOGGER.error("The following resource wasn't included in the deployment since it is invalid: ", (Object)resourceName);
        }
        if (validProcessCount == 0) {
            throw new ActivitiException("No process definition was deployed.");
        }
        deploymentBuilder.deploy();
    }
}

