/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.runtime.process.ExecutionActionRequest;
import org.activiti.rest.service.api.runtime.process.ExecutionBaseResource;
import org.activiti.rest.service.api.runtime.process.ExecutionQueryRequest;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExecutionCollectionResource
extends ExecutionBaseResource {
    @RequestMapping(value={"/runtime/executions"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getProcessInstances(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        ExecutionQueryRequest queryRequest = new ExecutionQueryRequest();
        if (allRequestParams.containsKey("id")) {
            queryRequest.setId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("processInstanceId")) {
            queryRequest.setProcessInstanceId(allRequestParams.get("processInstanceId"));
        }
        if (allRequestParams.containsKey("processInstanceBusinessKey")) {
            queryRequest.setProcessBusinessKey(allRequestParams.get("processInstanceBusinessKey"));
        }
        if (allRequestParams.containsKey("processDefinitionKey")) {
            queryRequest.setProcessDefinitionKey(allRequestParams.get("processDefinitionKey"));
        }
        if (allRequestParams.containsKey("processDefinitionId")) {
            queryRequest.setProcessDefinitionId(allRequestParams.get("processDefinitionId"));
        }
        if (allRequestParams.containsKey("messageEventSubscriptionName")) {
            queryRequest.setMessageEventSubscriptionName(allRequestParams.get("messageEventSubscriptionName"));
        }
        if (allRequestParams.containsKey("signalEventSubscriptionName")) {
            queryRequest.setSignalEventSubscriptionName(allRequestParams.get("signalEventSubscriptionName"));
        }
        if (allRequestParams.containsKey("activityId")) {
            queryRequest.setActivityId(allRequestParams.get("activityId"));
        }
        if (allRequestParams.containsKey("parentId")) {
            queryRequest.setParentId(allRequestParams.get("parentId"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            queryRequest.setTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            queryRequest.setTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && Boolean.valueOf(allRequestParams.get("withoutTenantId")).booleanValue()) {
            queryRequest.setWithoutTenantId(Boolean.TRUE);
        }
        return this.getQueryResponse(queryRequest, allRequestParams, request.getRequestURL().toString().replace("/runtime/executions", ""));
    }

    @RequestMapping(value={"/runtime/executions"}, method={RequestMethod.PUT})
    public void executeExecutionAction(@RequestBody ExecutionActionRequest actionRequest, HttpServletResponse response) {
        if (!"signalEventReceived".equals(actionRequest.getAction())) {
            throw new ActivitiIllegalArgumentException("Illegal action: '" + actionRequest.getAction() + "'.");
        }
        if (actionRequest.getSignalName() == null) {
            throw new ActivitiIllegalArgumentException("Signal name is required.");
        }
        if (actionRequest.getVariables() != null) {
            this.runtimeService.signalEventReceived(actionRequest.getSignalName(), this.getVariablesToSet(actionRequest));
        } else {
            this.runtimeService.signalEventReceived(actionRequest.getSignalName());
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

