/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.IdentityLink;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.repository.BaseProcessDefinitionResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessDefinitionIdentityLinkResource
extends BaseProcessDefinitionResource {
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/identitylinks/{family}/{identityId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RestIdentityLink getIdentityLink(@PathVariable(value="processDefinitionId") String processDefinitionId, @PathVariable(value="family") String family, @PathVariable(value="identityId") String identityId, HttpServletRequest request) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        this.validateIdentityLinkArguments(family, identityId);
        IdentityLink link = this.getIdentityLink(family, identityId, processDefinition.getId());
        return this.restResponseFactory.createRestIdentityLink(link);
    }

    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/identitylinks/{family}/{identityId}"}, method={RequestMethod.DELETE})
    public void deleteIdentityLink(@PathVariable(value="processDefinitionId") String processDefinitionId, @PathVariable(value="family") String family, @PathVariable(value="identityId") String identityId, HttpServletResponse response) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        this.validateIdentityLinkArguments(family, identityId);
        IdentityLink link = this.getIdentityLink(family, identityId, processDefinition.getId());
        if (link.getUserId() != null) {
            this.repositoryService.deleteCandidateStarterUser(processDefinition.getId(), link.getUserId());
        } else {
            this.repositoryService.deleteCandidateStarterGroup(processDefinition.getId(), link.getGroupId());
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void validateIdentityLinkArguments(String family, String identityId) {
        if (family == null || !"groups".equals(family) && !"users".equals(family)) {
            throw new ActivitiIllegalArgumentException("Identity link family should be 'users' or 'groups'.");
        }
        if (identityId == null) {
            throw new ActivitiIllegalArgumentException("IdentityId is required.");
        }
    }

    protected IdentityLink getIdentityLink(String family, String identityId, String processDefinitionId) {
        boolean isUser = family.equals("users");
        List allLinks = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinitionId);
        for (IdentityLink link : allLinks) {
            boolean rightIdentity = false;
            rightIdentity = isUser ? identityId.equals(link.getUserId()) : identityId.equals(link.getGroupId());
            if (!rightIdentity || !link.getType().equals("candidate")) continue;
            return link;
        }
        throw new ActivitiObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

