/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener.logging;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.logging.DefaultQueryLogEntryCreator;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;

public class OutputParameterLogEntryCreator
extends DefaultQueryLogEntryCreator {
    @Override
    public String getLogEntry(ExecutionInfo execInfo, List<QueryInfo> queryInfoList, boolean writeDataSourceName, boolean writeConnectionId) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getLogEntry(execInfo, queryInfoList, writeDataSourceName, writeConnectionId));
        sb.append(", OutParams:[");
        for (QueryInfo queryInfo : queryInfoList) {
            for (List<ParameterSetOperation> parameters : queryInfo.getParametersList()) {
                sb.append("(");
                if (this.hasOutputParameters(parameters)) {
                    String str = this.getOutputParameters(parameters, (CallableStatement)execInfo.getStatement());
                    sb.append(str);
                }
                sb.append("),");
            }
        }
        this.chompIfEndWith(sb, ',');
        sb.append("]");
        return sb.toString();
    }

    private String getOutputParameters(List<ParameterSetOperation> params, CallableStatement st) {
        StringBuilder sb = new StringBuilder();
        for (ParameterSetOperation param : params) {
            if (!ParameterSetOperation.isRegisterOutParameterOperation(param)) continue;
            Object key = param.getArgs()[0];
            Object value = this.getOutputValueForDisplay(key, st);
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append(",");
        }
        this.chompIfEndWith(sb, ',');
        return sb.toString();
    }

    protected Object getOutputValueForDisplay(Object key, CallableStatement cs) {
        Object value;
        try {
            value = key instanceof String ? cs.getObject((String)key) : cs.getObject((Integer)key);
        }
        catch (SQLException e) {
            return "[FAILED TO RETRIEVE]";
        }
        return value;
    }

    private boolean hasOutputParameters(List<ParameterSetOperation> params) {
        for (ParameterSetOperation param : params) {
            if (!ParameterSetOperation.isRegisterOutParameterOperation(param)) continue;
            return true;
        }
        return false;
    }
}

