/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import net.sourceforge.pmd.lang.plsql.ast.ASTVariableOrConstantDeclaratorId;
import net.sourceforge.pmd.lang.plsql.symboltable.ClassScope;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableNameDeclaration
extends AbstractNameDeclaration {
    private static final Logger LOG = LoggerFactory.getLogger(VariableNameDeclaration.class);

    public VariableNameDeclaration(ASTVariableOrConstantDeclaratorId node) {
        super((ScopedNode)node);
    }

    public Scope getScope() {
        try {
            return this.node.getScope().getEnclosingScope(ClassScope.class);
        }
        catch (Exception e) {
            LOG.trace("This Node does not have an enclosing Class: {}/{} => {}", new Object[]{this.node.getBeginLine(), this.node.getBeginColumn(), this.getImage()});
            return null;
        }
    }

    public ASTVariableOrConstantDeclaratorId getDeclaratorId() {
        return (ASTVariableOrConstantDeclaratorId)this.node;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableNameDeclaration)) {
            return false;
        }
        VariableNameDeclaration n = (VariableNameDeclaration)((Object)o);
        try {
            return n.getImage().equals(this.getImage());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            LOG.debug("n.node={}", (Object)n.node);
            LOG.debug("n.getImage={}", (Object)n.getImage());
            LOG.debug("node={}", (Object)this.node);
            LOG.debug("this.getImage={}", (Object)this.getImage());
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getImage().hashCode();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            LOG.debug("VariableNameDeclaration: node={}", (Object)this.node);
            LOG.debug("VariableNameDeclaration: node,getImage={}", (Object)this.getImage());
            return 0;
        }
    }

    public String toString() {
        return "Variable: image = '" + this.node.getImage() + "', line = " + this.node.getBeginLine();
    }
}

