/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.plsql.ast.ASTName;
import net.sourceforge.pmd.lang.plsql.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.symboltable.MethodOrLocalScope;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class MethodScope
extends MethodOrLocalScope {
    private final PLSQLNode node;

    public MethodScope(PLSQLNode node) {
        this.node = node;
    }

    public MethodScope getEnclosingMethodScope() {
        return this;
    }

    public Set<NameDeclaration> addNameOccurrence(NameOccurrence occ) {
        PLSQLNameOccurrence occurrence = (PLSQLNameOccurrence)occ;
        Set declarations = this.findVariableHere(occurrence);
        if (!declarations.isEmpty() && !occurrence.isThisOrSuper()) {
            for (NameDeclaration decl : declarations) {
                ((List)this.getVariableDeclarations().get(decl)).add(occurrence);
                PLSQLNode n = occurrence.getLocation();
                if (!(n instanceof ASTName)) continue;
                InternalApiBridge.setNameDeclaration((ASTName)n, decl);
            }
        }
        return declarations;
    }

    public String getName() {
        return ((PLSQLNode)this.node.getChild(1)).getCanonicalImage();
    }

    public String toString() {
        return "MethodScope:" + this.getVariableDeclarations().keySet();
    }
}

