/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.design;

import java.util.ArrayDeque;
import java.util.Deque;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTCaseStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTCaseWhenClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTElsifClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTExceptionHandler;
import net.sourceforge.pmd.lang.plsql.ast.ASTExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTForStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTInput;
import net.sourceforge.pmd.lang.plsql.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageBody;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeMethod;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.plsql.rule.AbstractPLSQLRule;
import net.sourceforge.pmd.lang.plsql.rule.design.NPathComplexityRule;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyclomaticComplexityRule
extends AbstractPLSQLRule {
    private static final Logger LOG = LoggerFactory.getLogger(CyclomaticComplexityRule.class);
    public static final PropertyDescriptor<Integer> REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"reportLevel").desc("Cyclomatic Complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)10)).build();
    public static final PropertyDescriptor<Boolean> SHOW_CLASSES_COMPLEXITY_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"showClassesComplexity").desc("Add class average violations to the report")).defaultValue((Object)true)).build();
    public static final PropertyDescriptor<Boolean> SHOW_METHODS_COMPLEXITY_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"showMethodsComplexity").desc("Add method average violations to the report")).defaultValue((Object)true)).build();
    private int reportLevel;
    private boolean showClassesComplexity = true;
    private boolean showMethodsComplexity = true;
    private Deque<Entry> entryStack = new ArrayDeque<Entry>();

    public CyclomaticComplexityRule() {
        this.definePropertyDescriptor(REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.definePropertyDescriptor(SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTInput node, Object data) {
        this.reportLevel = (Integer)this.getProperty(REPORT_LEVEL_DESCRIPTOR);
        this.showClassesComplexity = (Boolean)this.getProperty(SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.showMethodsComplexity = (Boolean)this.getProperty(SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTElsifClause node, Object data) {
        int boolCompIf = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompIf);
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        int boolCompIf = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompIf);
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTExceptionHandler node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        int boolCompFor = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstDescendantOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompFor);
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTLoopStatement node, Object data) {
        int boolCompDo = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompDo);
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTCaseStatement node, Object data) {
        Entry entry = this.entryStack.peek();
        int boolCompSwitch = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        entry.bumpDecisionPoints(boolCompSwitch);
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTCaseWhenClause node, Object data) {
        Entry entry = this.entryStack.peek();
        entry.bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        int boolCompWhile = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompWhile);
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTConditionalOrExpression node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTPackageSpecification node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTTypeSpecification node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTPackageBody node, Object data) {
        this.entryStack.push(new Entry());
        super.visit(node, data);
        Entry classEntry = this.entryStack.pop();
        LOG.debug("ASTPackageBody: ComplexityAverage=={}, highestDecisionPoint={}", (Object)classEntry.getComplexityAverage(), (Object)classEntry.highestDecisionPoints);
        if (this.showClassesComplexity && (classEntry.getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel)) {
            this.addViolation(data, (Node)node, new String[]{"class", node.getImage(), classEntry.getComplexityAverage() + " (Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    @Override
    public Object visit(ASTTriggerUnit node, Object data) {
        this.entryStack.push(new Entry());
        super.visit(node, data);
        Entry classEntry = this.entryStack.pop();
        LOG.debug("ASTTriggerUnit: ComplexityAverage=={}, highestDecisionPoint={}", (Object)classEntry.getComplexityAverage(), (Object)classEntry.highestDecisionPoints);
        if (this.showClassesComplexity && (classEntry.getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel)) {
            this.addViolation(data, (Node)node, new String[]{"class", node.getImage(), classEntry.getComplexityAverage() + " (Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    private void updateClassEntry(int methodDecisionPoints) {
        Entry classEntry = this.entryStack.peek();
        ++classEntry.methodCount;
        classEntry.bumpDecisionPoints(methodDecisionPoints);
        if (methodDecisionPoints > classEntry.highestDecisionPoints) {
            classEntry.highestDecisionPoints = methodDecisionPoints;
        }
    }

    @Override
    public Object visit(ASTProgramUnit node, Object data) {
        this.entryStack.push(new Entry());
        super.visit(node, data);
        Entry methodEntry = this.entryStack.pop();
        LOG.debug("ASTProgramUnit: ComplexityAverage=={}, highestDecisionPoint={}", (Object)methodEntry.getComplexityAverage(), (Object)methodEntry.highestDecisionPoints);
        if (this.showMethodsComplexity) {
            int methodDecisionPoints = methodEntry.decisionPoints;
            if (null != node.getFirstParentOfType(ASTPackageBody.class) || null != node.getFirstParentOfType(ASTTriggerUnit.class)) {
                this.updateClassEntry(methodDecisionPoints);
            }
            ASTMethodDeclarator methodDeclarator = (ASTMethodDeclarator)node.getFirstChildOfType(ASTMethodDeclarator.class);
            if (methodEntry.decisionPoints >= this.reportLevel) {
                this.addViolation(data, (Node)node, new String[]{"method", methodDeclarator == null ? "" : methodDeclarator.getImage(), String.valueOf(methodEntry.decisionPoints)});
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTTypeMethod node, Object data) {
        this.entryStack.push(new Entry());
        super.visit(node, data);
        Entry methodEntry = this.entryStack.pop();
        LOG.debug("ASTProgramUnit: ComplexityAverage=={}, highestDecisionPoint={}", (Object)methodEntry.getComplexityAverage(), (Object)methodEntry.highestDecisionPoints);
        if (this.showMethodsComplexity) {
            int methodDecisionPoints = methodEntry.decisionPoints;
            if (null != node.getFirstParentOfType(ASTPackageBody.class)) {
                this.updateClassEntry(methodDecisionPoints);
            }
            ASTMethodDeclarator methodDeclarator = (ASTMethodDeclarator)node.getFirstChildOfType(ASTMethodDeclarator.class);
            if (methodEntry.decisionPoints >= this.reportLevel) {
                this.addViolation(data, (Node)node, new String[]{"method", methodDeclarator == null ? "" : methodDeclarator.getImage(), String.valueOf(methodEntry.decisionPoints)});
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTTriggerTimingPointSection node, Object data) {
        this.entryStack.push(new Entry());
        super.visit(node, data);
        Entry methodEntry = this.entryStack.pop();
        LOG.debug("ASTTriggerTimingPointSection: ComplexityAverage=={}, highestDecisionPoint={}", (Object)methodEntry.getComplexityAverage(), (Object)methodEntry.highestDecisionPoints);
        if (this.showMethodsComplexity) {
            int methodDecisionPoints = methodEntry.decisionPoints;
            Entry classEntry = this.entryStack.peek();
            ++classEntry.methodCount;
            classEntry.bumpDecisionPoints(methodDecisionPoints);
            if (methodDecisionPoints > classEntry.highestDecisionPoints) {
                classEntry.highestDecisionPoints = methodDecisionPoints;
            }
            ASTMethodDeclarator methodDeclarator = (ASTMethodDeclarator)node.getFirstChildOfType(ASTMethodDeclarator.class);
            if (methodEntry.decisionPoints >= this.reportLevel) {
                this.addViolation(data, (Node)node, new String[]{"method", methodDeclarator == null ? "" : methodDeclarator.getImage(), String.valueOf(methodEntry.decisionPoints)});
            }
        }
        return data;
    }

    private static final class Entry {
        private int decisionPoints = 1;
        public int highestDecisionPoints;
        public int methodCount;

        private Entry() {
        }

        public void bumpDecisionPoints() {
            ++this.decisionPoints;
        }

        public void bumpDecisionPoints(int size) {
            this.decisionPoints += size;
        }

        public int getComplexityAverage() {
            return (double)this.methodCount == 0.0 ? 1 : (int)Math.rint((double)this.decisionPoints / (double)this.methodCount);
        }
    }
}

