/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.design;

import java.lang.reflect.Modifier;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageBody;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeMethod;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ExecutableCode;
import net.sourceforge.pmd.lang.plsql.ast.OracleObject;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.rule.AbstractPLSQLRule;
import net.sourceforge.pmd.lang.rule.internal.CommonPropertyDescriptors;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;

abstract class AbstractCounterCheckRule<T extends PLSQLNode>
extends AbstractPLSQLRule {
    private final PropertyDescriptor<Integer> reportLevel = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)CommonPropertyDescriptors.reportLevelProperty().desc("Threshold above which a node is reported")).require(NumericConstraints.positive())).defaultValue((Object)this.defaultReportLevel())).build();

    AbstractCounterCheckRule(Class<T> nodeType) {
        this.definePropertyDescriptor(this.reportLevel);
        if (!Modifier.isAbstract(nodeType.getModifiers()) && !nodeType.isInterface()) {
            this.addRuleChainVisit(nodeType);
        } else {
            this.determineRulechainVisits(nodeType);
        }
    }

    private void determineRulechainVisits(Class<T> abstractNodeType) {
        if (abstractNodeType == OracleObject.class) {
            this.addRuleChainVisit(ASTPackageBody.class);
            this.addRuleChainVisit(ASTPackageSpecification.class);
            this.addRuleChainVisit(ASTProgramUnit.class);
            this.addRuleChainVisit(ASTTriggerUnit.class);
            this.addRuleChainVisit(ASTTypeSpecification.class);
        } else if (abstractNodeType == ExecutableCode.class) {
            this.addRuleChainVisit(ASTMethodDeclaration.class);
            this.addRuleChainVisit(ASTProgramUnit.class);
            this.addRuleChainVisit(ASTTriggerTimingPointSection.class);
            this.addRuleChainVisit(ASTTriggerUnit.class);
            this.addRuleChainVisit(ASTTypeMethod.class);
        }
    }

    protected abstract int defaultReportLevel();

    protected boolean isIgnored(T node) {
        return false;
    }

    protected Object[] getViolationParameters(T node, int metric) {
        return new Object[]{metric};
    }

    protected abstract int getMetric(T var1);

    @Override
    public Object visitPlsqlNode(PLSQLNode node, Object data) {
        int metric;
        PLSQLNode t = node;
        if (!this.isIgnored(t) && (metric = this.getMetric(t)) >= (Integer)this.getProperty(this.reportLevel)) {
            this.addViolation(data, (Node)node, this.getViolationParameters(t, metric));
        }
        return data;
    }

    static abstract class AbstractLineLengthCheckRule<T extends PLSQLNode>
    extends AbstractCounterCheckRule<T> {
        AbstractLineLengthCheckRule(Class<T> nodeType) {
            super(nodeType);
        }

        @Override
        protected int getMetric(T node) {
            return node.getEndLine() - node.getBeginLine();
        }
    }
}

