/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.java.ast.ASTImplicitClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTModuleDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.AstImplUtil;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.ast.JavadocComment;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.ast.internal.LazyTypeResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTCompilationUnit
extends AbstractJavaNode
implements RootNode {
    private LazyTypeResolver lazyTypeResolver;
    private List<JavaComment> comments;
    private AstInfo<ASTCompilationUnit> astInfo;

    ASTCompilationUnit(int id) {
        super(id);
        this.setRoot(this);
    }

    public List<JavaComment> getComments() {
        return this.comments;
    }

    void setAstInfo(AstInfo<ASTCompilationUnit> task) {
        this.astInfo = task;
    }

    public AstInfo<ASTCompilationUnit> getAstInfo() {
        return this.astInfo;
    }

    void setComments(List<JavaComment> comments) {
        ArrayList<JavaComment> result = new ArrayList<JavaComment>();
        ArrayList<JavaComment> currentMarkdownBlock = null;
        for (JavaComment comment : comments) {
            if (JavaAstUtils.isMarkdownComment(comment.getToken())) {
                if (currentMarkdownBlock == null) {
                    currentMarkdownBlock = new ArrayList<JavaComment>();
                } else {
                    JavaComment lastComment = (JavaComment)currentMarkdownBlock.get(currentMarkdownBlock.size() - 1);
                    int lastCommentLine = lastComment.getReportLocation().getStartLine();
                    if (comment.getReportLocation().getStartLine() - lastCommentLine > 1) {
                        result.add(new JavadocComment(currentMarkdownBlock));
                        currentMarkdownBlock = new ArrayList();
                    }
                }
                currentMarkdownBlock.add(comment);
                continue;
            }
            if (currentMarkdownBlock != null) {
                result.add(new JavadocComment(currentMarkdownBlock));
                currentMarkdownBlock = null;
            }
            result.add(comment);
        }
        if (currentMarkdownBlock != null) {
            result.add(new JavadocComment(currentMarkdownBlock));
        }
        this.comments = result;
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public @Nullable ASTPackageDeclaration getPackageDeclaration() {
        return AstImplUtil.getChildAs(this, 0, ASTPackageDeclaration.class);
    }

    public @NonNull String getPackageName() {
        ASTPackageDeclaration pack = this.getPackageDeclaration();
        return pack == null ? "" : pack.getName();
    }

    public NodeStream<ASTTypeDeclaration> getTypeDeclarations() {
        return this.children(ASTTypeDeclaration.class);
    }

    public @Nullable ASTModuleDeclaration getModuleDeclaration() {
        return (ASTModuleDeclaration)this.firstChild(ASTModuleDeclaration.class);
    }

    @Override
    public TypeSystem getTypeSystem() {
        assert (this.lazyTypeResolver != null) : "Type resolution not initialized";
        return this.lazyTypeResolver.getTypeSystem();
    }

    void setTypeResolver(LazyTypeResolver typeResolver) {
        this.lazyTypeResolver = typeResolver;
    }

    @NonNull LazyTypeResolver getLazyTypeResolver() {
        assert (this.lazyTypeResolver != null) : "Type resolution not initialized";
        return this.lazyTypeResolver;
    }

    public boolean isCompact() {
        return this.children(ASTImplicitClassDeclaration.class).nonEmpty();
    }
}

