/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.coreimpl;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.CoreResolvers;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface NameResolver<S> {
    public @NonNull List<S> resolveHere(String var1);

    default public @Nullable S resolveFirst(String simpleName) {
        List<S> result = this.resolveHere(simpleName);
        return result.isEmpty() ? null : (S)result.get(0);
    }

    default public @NonNull OptionalBool knows(String simpleName) {
        return OptionalBool.UNKNOWN;
    }

    default public boolean isDefinitelyEmpty() {
        return false;
    }

    public String toString();

    public static <T> NameResolver<T> composite(final List<? extends NameResolver<? extends T>> resolvers) {
        if (resolvers.isEmpty()) {
            return CoreResolvers.emptyResolver();
        }
        return new NameResolver<T>(){

            @Override
            public @NonNull List<T> resolveHere(String simpleName) {
                List result = Collections.emptyList();
                for (NameResolver r : resolvers) {
                    List ts = r.resolveHere(simpleName);
                    if (ts.isEmpty()) continue;
                    result = CollectionUtil.concatView(result, ts);
                }
                return result;
            }

            @Override
            public @Nullable T resolveFirst(String simpleName) {
                for (NameResolver r : resolvers) {
                    Object t = r.resolveFirst(simpleName);
                    if (t == null) continue;
                    return t;
                }
                return null;
            }

            @Override
            public String toString() {
                return "Composite[" + resolvers + "]";
            }
        };
    }

    public static interface SingleNameResolver<S>
    extends NameResolver<S> {
        @Override
        default public @NonNull List<S> resolveHere(String simpleName) {
            return CollectionUtil.listOfNotNull(this.resolveFirst(simpleName));
        }

        @Override
        public @Nullable S resolveFirst(String var1);
    }
}

