/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ArrowBody;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandArrow
extends SingleLineCommand2<SequenceDiagram> {
    static final String ANCHOR = "(\\{([%pLN_]+)\\}[%s]+)?";

    public CommandArrow() {
        super(CommandArrow.getRegexConcat());
    }

    public static String getColorOrStylePattern() {
        return "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?";
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandArrow.class.getName(), RegexLeaf.start(), new RegexLeaf("PARALLEL", "(&[%s]*)?"), new RegexLeaf("ANCHOR", ANCHOR), new RegexOr("PART1", new RegexLeaf("PART1CODE", "([%pLN_.@]+)"), new RegexLeaf("PART1LONG", "[%g]([^%g]+)[%g]"), new RegexLeaf("PART1LONGCODE", "[%g]([^%g]+)[%g][%s]*as[%s]+([%pLN_.@]+)"), new RegexLeaf("PART1CODELONG", "([%pLN_.@]+)[%s]+as[%s]*[%g]([^%g]+)[%g]")), new RegexLeaf("PART1ANCHOR", ANCHOR), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexOr("ARROW_DRESSING1", new RegexLeaf("[%s][ox]"), new RegexLeaf("(?:[%s][ox]|\\(\\d+\\))?<<?_?"), new RegexLeaf("(?:[%s][ox])?//?"), new RegexLeaf("(?:[%s][ox])?\\\\\\\\?"))), new RegexOr(new RegexConcat(new RegexLeaf("ARROW_BODYA1", "(-+)"), new RegexLeaf("ARROW_STYLE1", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYB1", "(-*)")), new RegexConcat(new RegexLeaf("ARROW_BODYA2", "(-*)"), new RegexLeaf("ARROW_STYLE2", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYB2", "(-+)"))), new RegexOptional((IRegex)new RegexOr("ARROW_DRESSING2", new RegexLeaf("_?>>?(?:[ox][%s]|\\(\\d+\\))?"), new RegexLeaf("//?(?:[ox][%s])?"), new RegexLeaf("\\\\\\\\?(?:[ox][%s])?"), new RegexLeaf("[ox][%s]"))), RegexLeaf.spaceZeroOrMore(), new RegexOr("PART2", new RegexLeaf("PART2CODE", "([%pLN_.@]+)"), new RegexLeaf("PART2LONG", "[%g]([^%g]+)[%g]"), new RegexLeaf("PART2LONGCODE", "[%g]([^%g]+)[%g][%s]*as[%s]+([%pLN_.@]+)"), new RegexLeaf("PART2CODELONG", "([%pLN_.@]+)[%s]+as[%s]*[%g]([^%g]+)[%g]")), new RegexLeaf("MULTICAST", "((?:\\s&\\s[%pLN_.@]+)*)"), new RegexLeaf("PART2ANCHOR", ANCHOR), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ACTIVATION", "(?:(\\+\\+|\\*\\*|!!|--|--\\+\\+|\\+\\+--)?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("LIFECOLOR", "(?:(#\\w+)?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), new RegexLeaf("MESSAGE", "(?::[%s]*(.*))?"), RegexLeaf.end()).protectSize(2000);
    }

    private List<Participant> getMulticasts(SequenceDiagram system, RegexResult arg2) {
        String multicast = arg2.get("MULTICAST", 0);
        if (multicast != null) {
            ArrayList<Participant> result = new ArrayList<Participant>();
            for (String s : multicast.split("&")) {
                Participant participant;
                if ((s = s.trim()).length() == 0 || (participant = system.getOrCreateParticipant(s)) == null) continue;
                result.add(participant);
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private Participant getOrCreateParticipant(SequenceDiagram system, RegexResult arg2, String n) {
        Display display;
        String code;
        if (arg2.get(n + "CODE", 0) != null) {
            code = arg2.get(n + "CODE", 0);
            display = Display.getWithNewlines(code);
        } else if (arg2.get(n + "LONG", 0) != null) {
            code = arg2.get(n + "LONG", 0);
            display = Display.getWithNewlines(code);
        } else if (arg2.get(n + "LONGCODE", 0) != null) {
            display = Display.getWithNewlines(arg2.get(n + "LONGCODE", 0));
            code = arg2.get(n + "LONGCODE", 1);
        } else {
            if (arg2.get(n + "CODELONG", 0) != null) {
                String code2 = arg2.get(n + "CODELONG", 0);
                Display display2 = Display.getWithNewlines(arg2.get(n + "CODELONG", 1));
                return system.getOrCreateParticipant(code2, display2);
            }
            throw new IllegalStateException();
        }
        return system.getOrCreateParticipant(code, display);
    }

    private boolean contains(String string, String ... totest) {
        for (String t : totest) {
            if (!string.contains(t)) continue;
            return true;
        }
        return false;
    }

    private String getDressing(RegexResult arg, String key) {
        String value = arg.get(key, 0);
        value = CommandLinkClass.notNull(value);
        value = value.replace("_", "");
        return StringUtils.goLowerCase(value);
    }

    private int getInclination(String key) {
        if (key == null) {
            return 0;
        }
        int x1 = key.indexOf(40);
        if (x1 == -1) {
            return 0;
        }
        int x2 = key.indexOf(41);
        if (x2 == -1) {
            return 0;
        }
        return Integer.parseInt(key.substring(x1 + 1, x2));
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        HColor activationColor;
        boolean parallel;
        ArrowConfiguration config;
        Display labels;
        boolean dotted;
        boolean reverseDefine;
        boolean circleAtEnd;
        boolean circleAtStart;
        Participant p2;
        Participant p1;
        String dressing1 = this.getDressing(arg, "ARROW_DRESSING1");
        String dressing2 = this.getDressing(arg, "ARROW_DRESSING2");
        int inclination1 = this.getInclination(arg.get("ARROW_DRESSING1", 0));
        int inclination2 = this.getInclination(arg.get("ARROW_DRESSING2", 0));
        boolean hasDressing2 = this.contains(dressing2, ">", "\\", "/", "x");
        boolean hasDressing1 = this.contains(dressing1, "x", "<", "\\", "/");
        if (hasDressing2) {
            p1 = this.getOrCreateParticipant(diagram, arg, "PART1");
            p2 = this.getOrCreateParticipant(diagram, arg, "PART2");
            circleAtStart = dressing1.contains("o");
            circleAtEnd = dressing2.contains("o");
            reverseDefine = false;
        } else if (hasDressing1) {
            p2 = this.getOrCreateParticipant(diagram, arg, "PART1");
            p1 = this.getOrCreateParticipant(diagram, arg, "PART2");
            circleAtStart = dressing2.contains("o");
            circleAtEnd = dressing1.contains("o");
            reverseDefine = true;
        } else {
            return CommandExecutionResult.error("Illegal sequence arrow");
        }
        boolean sync = this.contains(dressing1, "<<", "\\\\", "//") || this.contains(dressing2, ">>", "\\\\", "//");
        boolean bl = dotted = this.getLength(arg) > 1;
        if (arg.get("MESSAGE", 0) == null) {
            labels = Display.create("");
        } else {
            String message = arg.get("MESSAGE", 0);
            labels = Display.getWithNewlines(message);
        }
        ArrowConfiguration arrowConfiguration = config = hasDressing1 && hasDressing2 ? ArrowConfiguration.withDirectionBoth() : ArrowConfiguration.withDirectionNormal();
        if (dotted) {
            config = config.withBody(ArrowBody.DOTTED);
        }
        if (sync) {
            config = config.withHead(ArrowHead.ASYNC);
        }
        if (dressing2.contains("\\") || dressing1.contains("/")) {
            config = config.withPart(ArrowPart.TOP_PART);
        }
        if (dressing2.contains("/") || dressing1.contains("\\")) {
            config = config.withPart(ArrowPart.BOTTOM_PART);
        }
        if (circleAtEnd) {
            config = config.withDecoration2(ArrowDecoration.CIRCLE);
        }
        if (circleAtStart) {
            config = config.withDecoration1(ArrowDecoration.CIRCLE);
        }
        if (reverseDefine) {
            if (dressing1.contains("x")) {
                config = config.withHead2(ArrowHead.CROSSX);
            }
            if (dressing2.contains("x")) {
                config = config.withHead1(ArrowHead.CROSSX);
            }
        } else {
            if (dressing1.contains("x")) {
                config = config.withHead1(ArrowHead.CROSSX);
            }
            if (dressing2.contains("x")) {
                config = config.withHead2(ArrowHead.CROSSX);
            }
        }
        if (reverseDefine) {
            config = config.reverseDefine();
        }
        config = CommandArrow.applyStyle(arg.getLazzy("ARROW_STYLE", 0), config);
        config = config.withInclination(inclination1 + inclination2);
        String activationSpec = arg.get("ACTIVATION", 0);
        if (activationSpec != null && activationSpec.charAt(0) == '*') {
            diagram.activate(p2, LifeEventType.CREATE, null);
        }
        String messageNumber = diagram.getNextMessageNumber();
        Message msg = new Message(diagram.getSkinParam().getCurrentStyleBuilder(), p1, p2, diagram.manageVariable(labels), config, messageNumber);
        msg.setMulticast(this.getMulticasts(diagram, arg));
        String url = arg.get("URL", 0);
        if (url != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url urlLink = urlBuilder.getUrl(url);
            msg.setUrl(urlLink);
        }
        if (arg.get("STEREOTYPE", 0) != null) {
            Stereotype stereotype = Stereotype.build(arg.get("STEREOTYPE", 0));
            msg.getStereotype(stereotype);
        }
        boolean bl2 = parallel = arg.get("PARALLEL", 0) != null;
        if (parallel) {
            msg.goParallel();
        }
        msg.setAnchor(arg.get("ANCHOR", 1));
        msg.setPart1Anchor(arg.get("PART1ANCHOR", 1));
        msg.setPart2Anchor(arg.get("PART2ANCHOR", 1));
        CommandExecutionResult status = diagram.addMessage(msg);
        if (!status.isOk()) {
            return status;
        }
        String s = arg.get("LIFECOLOR", 0);
        HColor hColor = activationColor = s == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s);
        if (activationSpec != null) {
            return this.manageActivations(activationSpec, diagram, p1, p2, activationColor);
        }
        if (diagram.isAutoactivate() && (config.getHead() == ArrowHead.NORMAL || config.getHead() == ArrowHead.ASYNC)) {
            if (config.isDotted()) {
                diagram.activate(p1, LifeEventType.DEACTIVATE, null);
            } else {
                diagram.activate(p2, LifeEventType.ACTIVATE, activationColor);
            }
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult manageActivations(String spec, SequenceDiagram diagram, Participant p1, Participant p2, HColor activationColor) {
        switch (spec.charAt(0)) {
            case '+': {
                diagram.activate(p2, LifeEventType.ACTIVATE, activationColor);
                break;
            }
            case '-': {
                diagram.activate(p1, LifeEventType.DEACTIVATE, null);
                break;
            }
            case '!': {
                diagram.activate(p2, LifeEventType.DESTROY, null);
            }
        }
        if (spec.length() == 4) {
            switch (spec.charAt(2)) {
                case '+': {
                    diagram.activate(p2, LifeEventType.ACTIVATE, activationColor);
                    break;
                }
                case '-': {
                    diagram.activate(p1, LifeEventType.DEACTIVATE, null);
                }
            }
        }
        return CommandExecutionResult.ok();
    }

    private int getLength(RegexResult arg2) {
        String sb;
        String sa = arg2.getLazzy("ARROW_BODYA", 0);
        if (sa == null) {
            sa = "";
        }
        if ((sb = arg2.getLazzy("ARROW_BODYB", 0)) == null) {
            sb = "";
        }
        return sa.length() + sb.length();
    }

    public static ArrowConfiguration applyStyle(String arrowStyle, ArrowConfiguration config) throws NoSuchColorException {
        if (arrowStyle == null) {
            return config;
        }
        StringTokenizer st = new StringTokenizer(arrowStyle, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equalsIgnoreCase("dashed")) {
                config = config.withBody(ArrowBody.DOTTED);
                continue;
            }
            if (s.equalsIgnoreCase("bold")) continue;
            if (s.equalsIgnoreCase("dotted")) {
                config = config.withBody(ArrowBody.DOTTED);
                continue;
            }
            if (s.equalsIgnoreCase("hidden")) {
                config = config.withBody(ArrowBody.HIDDEN);
                continue;
            }
            config = config.withColor(HColorSet.instance().getColor(s));
        }
        return config;
    }
}

